/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.beanbuilder.data;

import java.util.Iterator;
import java.util.TreeMap;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.org.retep.beanbuilder.data.Field;
import uk.org.retep.beanbuilder.data.Project;
import uk.org.retep.util.compiler.JavaSource;
import uk.org.retep.xml.core.XML;
import uk.org.retep.xml.core.XMLUtils;
import uk.org.retep.xml.core.XMLWriter;

public abstract class BeanBase
implements XML {
    private String name = "";
    private String description = "";
    private TreeMap fields = new TreeMap();
    private Project project;
    private String jndiName = "";

    public void reset() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Project getProject() {
        return this.project;
    }

    public Iterator getFields() {
        return this.fields.keySet().iterator();
    }

    public Field getField(String string) {
        return (Field)this.fields.get(string);
    }

    public void addField(Field field2) {
        TreeMap treeMap = this.fields;
        synchronized (treeMap) {
            this.fields.put(field2.getName(), field2);
        }
    }

    public void removeField(Field field2) {
        TreeMap treeMap = this.fields;
        synchronized (treeMap) {
            this.fields.remove(field2.getName());
        }
    }

    public abstract void writeXML(XMLWriter var1);

    public abstract void writeXML(XMLWriter var1, String var2);

    public abstract JavaSource[] generate();

    public void writeSuperXML(XMLWriter xMLWriter) {
        xMLWriter.writeTag("NAME", this.getName());
        xMLWriter.writeTag("JNDI-NAME", this.getJndiName());
        xMLWriter.writeTag("DESCRIPTION", this.getDescription());
        xMLWriter.startTag("FIELDS");
        XMLUtils.writeXML(xMLWriter, this.fields);
        xMLWriter.closeTag();
    }

    public void decodeSuperXML(Element element) {
        Element element2 = element;
        this.fields.clear();
        NodeList nodeList = element2.getChildNodes();
        int n = 0;
        int n2 = nodeList.getLength();
        while (n < n2) {
            Node node = nodeList.item(n);
            String string = node.getNodeName();
            if (node.getNodeType() == 1) {
                if ("NAME".equals(string)) {
                    this.setName(XMLUtils.getText((Element)node));
                } else if ("JNDI-NAME".equals(string)) {
                    this.setJndiName(XMLUtils.getText((Element)node));
                } else if ("DESCRIPTION".equals(string)) {
                    this.setDescription(XMLUtils.getText((Element)node));
                } else if ("FIELDS".equals(string)) {
                    XMLUtils.decodeMap((Element)node, this.fields);
                }
            }
            ++n;
        }
    }

    public void setJndiName(String string) {
        this.jndiName = string;
    }

    public String getJndiName() {
        return this.jndiName;
    }
}

