/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.beanbuilder.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeMap;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import uk.org.retep.beanbuilder.data.BeanBase;
import uk.org.retep.beanbuilder.swing.BeanListModel;
import uk.org.retep.tools.Tool;
import uk.org.retep.tools.ToolData;
import uk.org.retep.xml.core.XML;
import uk.org.retep.xml.core.XMLUtils;
import uk.org.retep.xml.core.XMLWriter;

public class Project
implements ToolData,
XML {
    private String title = "";
    private String author = "";
    private boolean modified = true;
    private String packageName = "mypackage";
    private String description = "";
    private TreeMap beans = new TreeMap();
    private File file;
    private Tool tool;

    public void addBean(BeanBase beanBase) {
        TreeMap treeMap = this.beans;
        synchronized (treeMap) {
            this.beans.put(beanBase.getName(), beanBase);
            beanBase.setProject(this);
        }
    }

    public void removeBean(BeanBase beanBase) {
        TreeMap treeMap = this.beans;
        synchronized (treeMap) {
            this.beans.remove(beanBase.getName());
        }
    }

    public Iterator getBeans() {
        return this.beans.keySet().iterator();
    }

    public BeanBase getBean(String string) {
        return (BeanBase)this.beans.get(string);
    }

    public int getBeanSize() {
        return this.beans.size();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setAuthor(String string) {
        this.author = string;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setModified(boolean bl) {
        this.modified = bl;
    }

    public boolean isModified() {
        return this.modified;
    }

    public String toString() {
        return this.getTitle();
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void setPackageName(String string) {
        this.packageName = string;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public BeanListModel getBeanListModel() {
        return new BeanListModel(this);
    }

    public BeanListModel getBeanListModel(int n) {
        return new BeanListModel(this, n);
    }

    public static Project load(File file) throws IOException, SAXException {
        Project project = Project.load(new FileInputStream(file));
        project.setFile(file);
        return project;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setTool(Tool tool) {
        this.tool = tool;
    }

    public Tool getTool() {
        return this.tool;
    }

    public void writeXML(XMLWriter xMLWriter) {
        this.writeXML(xMLWriter, "PROJECT");
    }

    public void writeXML(XMLWriter xMLWriter, String string) {
        xMLWriter.startTag(string);
        xMLWriter.addAttribute("APPLICATION", "RetepJBoss");
        xMLWriter.addAttribute("VERSION", "0.1");
        xMLWriter.writeTag("TITLE", this.getTitle());
        xMLWriter.writeTag("AUTHOR", this.getAuthor());
        xMLWriter.writeTag("PACKAGE", this.getPackageName());
        xMLWriter.writeTag("DESCRIPTION", this.getDescription());
        xMLWriter.startTag("BEANS");
        XMLUtils.writeXML(xMLWriter, this.beans);
        xMLWriter.closeTag();
        xMLWriter.closeTag();
    }

    public static Project load(InputStream inputStream) throws IOException, SAXException {
        return Project.decodeXML(XMLUtils.parseXML(inputStream));
    }

    public static Project decodeXML(Element element) {
        Element element2 = element;
        Project project = new Project();
        NodeList nodeList = element2.getChildNodes();
        int n = 0;
        int n2 = nodeList.getLength();
        while (n < n2) {
            Node node = nodeList.item(n);
            String string = node.getNodeName();
            if (node.getNodeType() == 1) {
                if ("TITLE".equals(string)) {
                    project.setTitle(XMLUtils.getText((Element)node));
                } else if ("AUTHOR".equals(string)) {
                    project.setAuthor(XMLUtils.getText((Element)node));
                } else if ("FILE".equals(string)) {
                    project.setFile(new File(XMLUtils.getText((Element)node)));
                } else if ("PACKAGE".equals(string)) {
                    project.setPackageName(XMLUtils.getText((Element)node));
                } else if ("DESCRIPTION".equals(string)) {
                    project.setDescription(XMLUtils.getText((Element)node));
                } else if ("BEANS".equals(string)) {
                    Hashtable hashtable = (Hashtable)XMLUtils.decodeMap((Element)node, new Hashtable());
                    project.beans = new TreeMap();
                    Enumeration enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        Object k = enumeration.nextElement();
                        project.addBean((BeanBase)hashtable.get(k));
                    }
                }
            }
            ++n;
        }
        return project;
    }
}

