/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.beanbuilder.swing;

import java.util.Iterator;
import javax.swing.AbstractListModel;
import uk.org.retep.beanbuilder.data.BeanBase;
import uk.org.retep.beanbuilder.data.BeanListener;
import uk.org.retep.beanbuilder.data.EntityBean;
import uk.org.retep.beanbuilder.data.Project;

public class BeanListModel
extends AbstractListModel
implements BeanListener {
    public static final int NONE = 0;
    public static final int ENTITY = 1;
    private Project project;
    private String[] titles;
    private int size;
    private int filter;
    private static final int increment = 10;

    public BeanListModel(Project project) {
        this(project, 0);
    }

    public BeanListModel(Project project, int n) {
        this.project = project;
        this.filter = n;
        this.refresh();
    }

    public int getSize() {
        return this.size;
    }

    public Object getElementAt(int n) {
        return this.titles[n];
    }

    private void refresh() {
        this.size = 0;
        Iterator iterator = this.project.getBeans();
        block6: while (iterator.hasNext()) {
            BeanBase beanBase = this.project.getBean((String)iterator.next());
            switch (this.filter) {
                case 1: {
                    if (!(beanBase instanceof EntityBean)) continue block6;
                    ++this.size;
                    break;
                }
                default: {
                    ++this.size;
                }
            }
        }
        if (this.titles != null && this.size > this.titles.length) {
            this.titles = null;
        }
        if (this.titles == null) {
            this.titles = new String[this.size + 10];
        }
        int n = 0;
        iterator = this.project.getBeans();
        block7: while (iterator.hasNext()) {
            String string = (String)iterator.next();
            BeanBase beanBase = this.project.getBean(string);
            switch (this.filter) {
                case 1: {
                    if (!(beanBase instanceof EntityBean)) continue block7;
                    this.titles[n++] = string;
                    break;
                }
                default: {
                    this.titles[n++] = string;
                }
            }
        }
    }

    public void beanAdded() {
        this.refresh();
        this.fireIntervalAdded(this, 0, 0);
    }

    public void beanRemoved() {
        this.refresh();
        this.fireIntervalRemoved(this, 0, 0);
    }

    public void beanModified() {
        this.refresh();
        this.fireContentsChanged(this, 0, 0);
    }
}

