/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ExceptionDialog
extends JDialog {
    private static ExceptionDialog INSTANCE = null;
    private static Frame frame;
    private Exception exception;
    JPanel jPanel1 = new JPanel();
    JButton bClose = new JButton();
    JButton bShow = new JButton();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JTextArea stack = new JTextArea();
    JScrollPane jScrollPane1 = new JScrollPane();
    JLabel msg = new JLabel();

    public ExceptionDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ExceptionDialog() {
        this((Frame)null, "", false);
    }

    void jbInit() throws Exception {
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.bClose.setText("Close");
        this.bClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExceptionDialog.this.closeDialog(actionEvent);
            }
        });
        this.bShow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExceptionDialog.this.showTrace(actionEvent);
            }
        });
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.stack.setLineWrap(true);
        this.bShow.setText("Show Stack Trace");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.bClose, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 16, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.msg, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jScrollPane1.getViewport().add((Component)this.stack, null);
    }

    public static void setFrame(Frame frame) {
        if (INSTANCE != null) {
            INSTANCE.dispose();
        }
        if ((ExceptionDialog.frame = frame) != null) {
            INSTANCE = new ExceptionDialog(frame, "Exception", true);
        }
    }

    public static Frame getFrame() {
        return frame;
    }

    public static void show(Exception exception) {
        if (INSTANCE == null) {
            exception.printStackTrace();
        } else {
            INSTANCE.setException(exception);
            INSTANCE.show();
        }
    }

    protected void setException(Exception exception) {
        this.exception = exception;
        this.setTitle(this.exception.getClass().getName());
        String string = this.exception.getLocalizedMessage();
        if (string == null) {
            string = this.exception.getMessage();
        }
        if (string == null) {
            string = "The exception contains no message";
        }
        this.msg.setText(string);
        this.jPanel1.add((Component)this.bShow, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 14, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jScrollPane1.setVisible(false);
        this.stack.setVisible(false);
        this.pack();
    }

    private void showTrace(ActionEvent actionEvent) {
        this.jPanel1.remove(this.bShow);
        this.jPanel1.add((Component)this.jScrollPane1, new GridBagConstraints(1, 1, 3, 1, 1.0, 0.9, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.exception.printStackTrace(new PrintStream(byteArrayOutputStream));
            byteArrayOutputStream.flush();
            this.stack.setText(byteArrayOutputStream.toString());
            byteArrayOutputStream.close();
            this.stack.setCaretPosition(0);
            this.jScrollPane1.setVisible(true);
            this.stack.setVisible(true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.pack();
    }

    private void closeDialog(ActionEvent actionEvent) {
        ((Component)this).setVisible(false);
    }

    public void pack() {
        super.pack();
        if (frame != null) {
            Dimension dimension = this.getSize();
            Dimension dimension2 = frame.getSize();
            Point point = frame.getLocation();
            if (dimension.width > dimension2.width) {
                dimension.width = dimension2.width;
            }
            if (dimension.height > dimension2.height) {
                dimension.height = dimension2.height;
            }
            ((Component)this).setSize(dimension);
            point.x += dimension2.width - dimension.width >> 1;
            point.y += dimension2.height - dimension.height >> 1;
            ((Component)this).setLocation(point);
            this.validate();
        }
    }
}

