/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.swing;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import uk.org.retep.swing.ExceptionDialog;
import uk.org.retep.swing.ImageLibrary;
import uk.org.retep.swing.WebBrowser;

public class WebToolBar
extends JToolBar
implements HyperlinkListener,
WebBrowser.WebBrowserListener {
    private WebBrowser browser;
    private JButton tb_back = new JButton();
    private JButton tb_forward = new JButton();
    private JButton tb_reload = new JButton();
    private JTextField tf_url = new JTextField();
    private JButton tb_print = new JButton();
    private JButton tb_stop = new JButton();

    public WebToolBar() {
        this((WebBrowser)null);
    }

    public WebToolBar(WebBrowser webBrowser) {
        this.tb_back.setIcon(ImageLibrary.getImageIcon("images/navigation/Back16.gif"));
        this.tb_forward.setIcon(ImageLibrary.getImageIcon("images/navigation/Forward16.gif"));
        this.tb_reload.setIcon(ImageLibrary.getImageIcon("images/general/Refresh16.gif"));
        this.tb_print.setIcon(ImageLibrary.getImageIcon("images/general/Print16.gif"));
        this.tb_stop.setIcon(ImageLibrary.getImageIcon("images/general/Stop16.gif"));
        Insets insets = new Insets(2, 2, 2, 2);
        this.tb_back.setMargin(insets);
        this.tb_forward.setMargin(insets);
        this.tb_reload.setMargin(insets);
        this.tb_print.setMargin(insets);
        this.tb_stop.setMargin(insets);
        this.add((Component)this.tb_back, null);
        this.add((Component)this.tb_forward, null);
        this.add((Component)this.tb_reload, null);
        this.add((Component)this.tb_stop, null);
        this.add((Component)this.tb_print, null);
        this.add((Component)this.tf_url, null);
        this.setBrowser(webBrowser);
        this.tb_back.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WebToolBar.this.browser.back();
            }
        });
        this.tb_forward.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WebToolBar.this.browser.forward();
            }
        });
        this.tb_print.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WebToolBar.this.browser.print();
            }
        });
        this.tf_url.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    WebToolBar.this.browser.display(new URL(WebToolBar.this.tf_url.getText()));
                }
                catch (MalformedURLException malformedURLException) {
                    ExceptionDialog.show(malformedURLException);
                }
            }
        });
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            URL uRL = hyperlinkEvent.getURL();
            this.browser.display(uRL);
            this.tf_url.setText(uRL.toString());
        }
    }

    public void setBrowser(WebBrowser webBrowser) {
        if (this.browser != null) {
            this.browser.removeHyperlinkListener(this);
            this.browser.removeWebBrowserListener(this);
        }
        this.browser = webBrowser;
        boolean bl = this.browser != null;
        this.tb_back.setEnabled(bl);
        this.tb_forward.setEnabled(bl);
        this.tb_reload.setEnabled(bl);
        this.tb_stop.setEnabled(bl);
        this.tb_print.setEnabled(bl);
        this.tf_url.setEditable(bl);
        if (bl) {
            this.browser.addHyperlinkListener(this);
            this.browser.addWebBrowserListener(this);
            this.browserUpdate(this.browser);
        }
    }

    public WebBrowser getBrowser() {
        return this.browser;
    }

    public void browserUpdate(WebBrowser webBrowser) {
        this.tb_back.setEnabled(webBrowser.hasPast());
        this.tb_forward.setEnabled(webBrowser.hasFuture());
        this.tf_url.setText(this.browser.getPageURL());
    }
}

