/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.swing.model.list;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

public class VectorListModel
extends AbstractListModel
implements ComboBoxModel {
    protected Vector data;
    private Object selected;

    public VectorListModel() {
        this(new Vector());
    }

    public VectorListModel(Vector vector) {
        this.data = vector;
    }

    public VectorListModel(Collection collection) {
        this.data = new Vector(collection);
        this.data.trimToSize();
    }

    public VectorListModel(Iterator iterator) {
        this.data = new Vector();
        while (iterator.hasNext()) {
            this.data.add(iterator.next());
        }
        this.data.trimToSize();
    }

    public int getSize() {
        return this.data.size();
    }

    public Object getElementAt(int n) {
        return this.data.elementAt(n);
    }

    public Vector getVector() {
        return this.data;
    }

    public void setVector(Vector vector) {
        this.data = vector;
        this.fireContentsChanged(this, 0, this.data.size());
    }

    public void contentsChanged() {
        this.contentsChanged(0, this.data.size());
    }

    public void contentsChanged(int n) {
        this.contentsChanged(n, n);
    }

    public void contentsChanged(int n, int n2) {
        this.fireContentsChanged(this, n, n2);
    }

    public void entryAdded(int n, int n2) {
        this.fireIntervalAdded(this, n, n2);
    }

    public void entryRemoved(int n, int n2) {
        this.fireIntervalRemoved(this, n, n2);
    }

    public void setSelectedItem(Object object) {
        this.selected = object;
    }

    public Object getSelectedItem() {
        return this.selected;
    }
}

