/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.tools.ant;

import java.util.Iterator;
import java.util.TreeMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.org.retep.tools.AbstractToolData;
import uk.org.retep.tools.ant.Property;
import uk.org.retep.tools.ant.Target;
import uk.org.retep.xml.core.XML;
import uk.org.retep.xml.core.XMLWriter;

public class Project
extends AbstractToolData
implements XML {
    private static final String ELEMENT = "project";
    private static final String NAME = "name";
    private static final String DEFAULT = "default";
    private static final String BASEDIR = "basedir";
    private String name = "untitled";
    private String defaultTarget = "main";
    private String basedir = ".";
    private TreeMap properties = new TreeMap();
    private TreeMap targets = new TreeMap();

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setDefaultTarget(String string) {
        this.defaultTarget = string;
    }

    public String getDefaultTarget() {
        return this.defaultTarget;
    }

    public void setBasedir(String string) {
        this.basedir = string;
    }

    public String getBasedir() {
        return this.basedir;
    }

    public TreeMap getProperties() {
        return this.properties;
    }

    public TreeMap getTargets() {
        return this.targets;
    }

    public void writeXML(XMLWriter xMLWriter) {
        this.writeXML(xMLWriter, ELEMENT);
    }

    public void writeXML(XMLWriter xMLWriter, String string) {
        xMLWriter.startTag(string);
        xMLWriter.addAttribute(NAME, this.getName());
        xMLWriter.addAttribute(DEFAULT, this.getDefaultTarget());
        xMLWriter.addAttribute(BASEDIR, this.getBasedir());
        Iterator iterator = this.properties.keySet().iterator();
        while (iterator.hasNext()) {
            ((Property)iterator.next()).writeXML(xMLWriter);
        }
        iterator = this.targets.keySet().iterator();
        while (iterator.hasNext()) {
            ((Target)iterator.next()).writeXML(xMLWriter);
        }
        xMLWriter.closeTag();
    }

    public static Project decodeXML(Element element) {
        Project project = new Project();
        Attr attr = element.getAttributeNode(NAME);
        if (attr != null) {
            project.setName(attr.getValue());
        }
        if ((attr = element.getAttributeNode(DEFAULT)) != null) {
            project.setDefaultTarget(attr.getValue());
        }
        if ((attr = element.getAttributeNode(BASEDIR)) != null) {
            project.setBasedir(attr.getValue());
        }
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        int n2 = nodeList.getLength();
        while (n < n2) {
            Node node = nodeList.item(n);
            String string = node.getNodeName();
            if (node.getNodeType() == 1) {
                XML xML;
                if ("property".equals(string)) {
                    xML = Property.decodeXML((Element)node);
                    project.properties.put(((Property)xML).getName(), xML);
                } else if ("target".equals(string)) {
                    xML = Target.decodeXML((Element)node);
                    project.targets.put(((Target)xML).getName(), xML);
                }
            }
            ++n;
        }
        return project;
    }
}

