/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DoubleVector {
    private double[] data = null;
    private int pos = 0;
    private int inc = 0;

    public DoubleVector() {
        this(10, 0);
    }

    public DoubleVector(int n) {
        this(n, 0);
    }

    public DoubleVector(int n, int n2) {
        this.data = new double[n];
        this.inc = n2;
        this.pos = 0;
    }

    public synchronized void add(double d) {
        this.ensureCapacity(this.pos + 1);
        this.data[this.pos++] = d;
    }

    public void ensureCapacity(int n) {
        int n2 = this.data.length;
        if (n > n2) {
            int n3;
            double[] dArray = this.data;
            int n4 = n3 = this.inc > 0 ? n2 + this.inc : n2 * 2;
            if (n3 < n) {
                n3 = n;
            }
            this.data = new double[n3];
            System.arraycopy(dArray, 0, this.data, 0, this.pos);
        }
    }

    public void trim() {
        double[] dArray = this.data;
        this.data = new double[this.pos];
        System.arraycopy(dArray, 0, this.data, 0, this.pos);
    }

    public void clear() {
        this.pos = 0;
    }

    public int size() {
        return this.pos;
    }

    public int getSize() {
        return this.pos;
    }

    public double removeIndex(int n) {
        if (n < 0 | n >= this.pos) {
            throw new IllegalArgumentException("index out of bounds");
        }
        double d = this.data[n];
        System.arraycopy(this.data, n + 1, this.data, n, this.pos - n - 1);
        return d;
    }

    public double getIndex(int n) {
        if (n < 0 | n >= this.pos) {
            throw new IllegalArgumentException("index out of bounds");
        }
        return this.data[n];
    }

    public Enumeration elements() {
        return new Enumeration(){
            int count = 0;

            public boolean hasMoreElements() {
                return this.count < DoubleVector.this.pos;
            }

            public Object nextElement() {
                DoubleVector doubleVector = DoubleVector.this;
                synchronized (doubleVector) {
                    if (this.count < DoubleVector.this.pos) {
                        Double d = new Double(DoubleVector.this.data[this.count++]);
                        return d;
                    }
                }
                throw new NoSuchElementException("DoubleVector Enumeration");
            }
        };
    }

    public Iterator iterator() {
        return new Iterator(){
            int count = 0;
            boolean rem = false;

            public boolean hasNext() {
                return this.count < DoubleVector.this.pos;
            }

            public Object next() {
                DoubleVector doubleVector = DoubleVector.this;
                synchronized (doubleVector) {
                    if (this.count < DoubleVector.this.pos) {
                        this.rem = false;
                        Double d = new Double(DoubleVector.this.data[this.count++]);
                        return d;
                    }
                }
                throw new NoSuchElementException("DoubleVector Iterator");
            }

            public void remove() {
                DoubleVector doubleVector = DoubleVector.this;
                synchronized (doubleVector) {
                    if (!this.rem) {
                        DoubleVector.this.removeIndex(this.count--);
                        if (this.count < 0) {
                            this.count = 0;
                        }
                    } else {
                        throw new IllegalStateException("DoubleVector Iterator");
                    }
                    this.rem = true;
                }
            }
        };
    }

    public double[] toArray() {
        return this.toArray(null);
    }

    public double[] toArray(double[] dArray) {
        if (dArray == null || dArray.length < this.pos) {
            dArray = new double[this.pos];
        }
        System.arraycopy(this.data, 0, dArray, 0, dArray.length);
        return dArray;
    }
}

