/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IntVector {
    private int[] data = null;
    private int pos = 0;
    private int inc = 0;

    public IntVector() {
        this(10, 0);
    }

    public IntVector(int n) {
        this(n, 0);
    }

    public IntVector(int n, int n2) {
        this.data = new int[n];
        this.inc = n2;
        this.pos = 0;
    }

    public synchronized void add(int n) {
        this.ensureCapacity(this.pos + 1);
        this.data[this.pos++] = n;
    }

    public void ensureCapacity(int n) {
        int n2 = this.data.length;
        if (n > n2) {
            int n3;
            int[] nArray = this.data;
            int n4 = n3 = this.inc > 0 ? n2 + this.inc : n2 * 2;
            if (n3 < n) {
                n3 = n;
            }
            this.data = new int[n3];
            System.arraycopy(nArray, 0, this.data, 0, this.pos);
        }
    }

    public void trim() {
        int[] nArray = this.data;
        this.data = new int[this.pos];
        System.arraycopy(nArray, 0, this.data, 0, this.pos);
    }

    public void clear() {
        this.pos = 0;
    }

    public int size() {
        return this.pos;
    }

    public int getSize() {
        return this.pos;
    }

    public int removeIndex(int n) {
        if (n < 0 | n >= this.pos) {
            throw new IllegalArgumentException("index out of bounds");
        }
        int n2 = this.data[n];
        System.arraycopy(this.data, n + 1, this.data, n, this.pos - n - 1);
        return n2;
    }

    public int getIndex(int n) {
        if (n < 0 | n >= this.pos) {
            throw new IllegalArgumentException("index out of bounds");
        }
        return this.data[n];
    }

    public Enumeration elements() {
        return new Enumeration(){
            int count = 0;

            public boolean hasMoreElements() {
                return this.count < IntVector.this.pos;
            }

            public Object nextElement() {
                IntVector intVector = IntVector.this;
                synchronized (intVector) {
                    if (this.count < IntVector.this.pos) {
                        Integer n = new Integer(IntVector.this.data[this.count++]);
                        return n;
                    }
                }
                throw new NoSuchElementException("IntVector Enumeration");
            }
        };
    }

    public Iterator iterator() {
        return new Iterator(){
            int count = 0;
            boolean rem = false;

            public boolean hasNext() {
                return this.count < IntVector.this.pos;
            }

            public Object next() {
                IntVector intVector = IntVector.this;
                synchronized (intVector) {
                    if (this.count < IntVector.this.pos) {
                        this.rem = false;
                        Integer n = new Integer(IntVector.this.data[this.count++]);
                        return n;
                    }
                }
                throw new NoSuchElementException("IntVector Iterator");
            }

            public void remove() {
                IntVector intVector = IntVector.this;
                synchronized (intVector) {
                    if (!this.rem) {
                        IntVector.this.removeIndex(this.count--);
                        if (this.count < 0) {
                            this.count = 0;
                        }
                    } else {
                        throw new IllegalStateException("IntVector Iterator");
                    }
                    this.rem = true;
                }
            }
        };
    }

    public int[] toArray() {
        return this.toArray(null);
    }

    public int[] toArray(int[] nArray) {
        if (nArray == null || nArray.length < this.pos) {
            nArray = new int[this.pos];
        }
        System.arraycopy(this.data, 0, nArray, 0, nArray.length);
        return nArray;
    }
}

