/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class StringUtils {
    public static final String EMPTY = "";
    public static final char NL = '\n';
    public static final String NLS = "\n";
    public static final char BACKSLASH = '\\';
    public static final String COMMENT = "#";
    public static final String keyValueSeparators = "=: \t\r\n\f";
    public static final String strictKeyValueSeparators = "=:";
    public static final String specialSaveChars = "=: \t\r\n\f#!";
    public static final String whiteSpaceChars = " \t\r\n\f";
    public static final String hexLow = "0123456789abcdef";
    public static final String hexHigh = "0123456789ABCDEF";

    public static boolean continueLine(String string) {
        int n = 0;
        int n2 = string.length() - 1;
        while (n2 >= 0 && string.charAt(n2--) == '\\') {
            ++n;
        }
        return n % 2 == 1;
    }

    public static int decodeHex(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        throw new IllegalArgumentException("Malformed hexadecimal " + c);
    }

    public static char encodeHex(int n) {
        return hexHigh.charAt(n & 0xF);
    }

    public static String decodeUnicode(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            if ((n3 = string.charAt(n2++)) == 92) {
                if ((n3 = string.charAt(n2++)) == 117) {
                    int n4 = 0;
                    int n5 = 0;
                    while (n5 < 4) {
                        n4 = (n4 << 4) + StringUtils.decodeHex(string.charAt(n2++));
                        ++n5;
                    }
                    stringBuffer.append((char)n4);
                    continue;
                }
                if (n3 == 116) {
                    n3 = 9;
                } else if (n3 == 114) {
                    n3 = 13;
                } else if (n3 == 110) {
                    n3 = 10;
                } else if (n3 == 102) {
                    n3 = 12;
                }
                stringBuffer.append((char)n3);
                continue;
            }
            stringBuffer.append((char)n3);
        }
        return stringBuffer.toString();
    }

    public static String encodeUnicode(String string) {
        return StringUtils.encodeUnicode(string, false);
    }

    public static String encodeUnicode(String string, boolean bl) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case ' ': {
                    if (n2 == 0 || bl) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(' ');
                    break;
                }
                case '\\': {
                    stringBuffer.append('\\').append('\\');
                    break;
                }
                case '\t': {
                    stringBuffer.append('\\').append('t');
                    break;
                }
                case '\n': {
                    stringBuffer.append('\\').append('n');
                    break;
                }
                case '\r': {
                    stringBuffer.append('\\').append('r');
                    break;
                }
                case '\f': {
                    stringBuffer.append('\\').append('f');
                    break;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        stringBuffer.append('\\').append('u');
                        stringBuffer.append(StringUtils.encodeHex(c >> 12 & 0xF));
                        stringBuffer.append(StringUtils.encodeHex(c >> 8 & 0xF));
                        stringBuffer.append(StringUtils.encodeHex(c >> 4 & 0xF));
                        stringBuffer.append(StringUtils.encodeHex(c & 0xF));
                        break;
                    }
                    if (specialSaveChars.indexOf(c) != -1) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static int findNonWhitespace(String string) {
        return StringUtils.findNonWhitespace(string, 0);
    }

    public static int findNonWhitespace(String string, int n) {
        int n2 = string.length();
        while (n < n2) {
            if (whiteSpaceChars.indexOf(string.charAt(n)) == -1) break;
            ++n;
        }
        return n;
    }

    public static int findKeySeparator(String string, int n) {
        int n2 = n;
        int n3 = string.length();
        while (n2 < n3) {
            char c = string.charAt(n2);
            if (c == '\\') {
                ++n2;
            } else if (keyValueSeparators.indexOf(c) != -1) break;
            ++n2;
        }
        return n2;
    }

    public static int findKeyValue(String string, int n) {
        if (strictKeyValueSeparators.indexOf(string.charAt(n)) != -1) {
            ++n;
        }
        return StringUtils.findNonWhitespace(string, n);
    }

    public static void writeln(BufferedWriter bufferedWriter, String string) throws IOException {
        bufferedWriter.write(string);
        bufferedWriter.write(10);
    }

    public static String fixComment(String string) {
        if (string == null || string == EMPTY) {
            string = EMPTY;
        } else {
            StringBuffer stringBuffer = new StringBuffer(string.length());
            StringTokenizer stringTokenizer = new StringTokenizer(string, NLS);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (!string2.startsWith(COMMENT)) {
                    stringBuffer.append(COMMENT);
                }
                stringBuffer.append(string2).append('\n');
            }
            if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) != '\n') {
                stringBuffer.append('\n');
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public static String getUniqueKey(Map map, String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (true) {
            String string2;
            stringBuffer.setLength(string.length());
            if (n > 0) {
                stringBuffer.append(n);
            }
            if (!map.containsKey(string2 = stringBuffer.toString())) {
                return string2;
            }
            ++n;
        }
    }

    public static String capitalise(String string) {
        if (string == null) {
            return EMPTY;
        }
        if (string.length() < 2) {
            return string.toUpperCase();
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public static int scanToken(String string, String string2, int n) {
        int n2 = string.length();
        int n3 = string2.length() - 1;
        while (n3 > -1) {
            int n4 = string.indexOf(string2.charAt(n3), n);
            if (n4 > -1 && n4 < n2) {
                n2 = n4;
            }
            --n3;
        }
        return n2 == string.length() ? -1 : n2;
    }
}

