/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import uk.org.retep.util.IntVector;
import uk.org.retep.util.StringUtils;

public class Tokenizer {
    public static final String DELIMITERS = " \t\n\r\f";
    private String string;
    private String delimiters;
    private boolean returnDelimiters;
    private IntVector tokens = new IntVector(10, 10);
    private IntVector positions = new IntVector(10, 10);
    private int pos;

    public Tokenizer(String string) {
        this(string, DELIMITERS, false);
    }

    public Tokenizer(String string, String string2) {
        this(string, string2, false);
    }

    public Tokenizer(String string, boolean bl) {
        this(string, DELIMITERS, bl);
    }

    public Tokenizer(String string, String string2, boolean bl) {
        this.tokenize(string, string2, bl);
    }

    public String getString() {
        return this.string;
    }

    public String getDelimiters() {
        return this.delimiters;
    }

    public boolean isReturnDelimiters() {
        return this.returnDelimiters;
    }

    public int countTokens() {
        return this.tokens.getSize();
    }

    public void tokenize(String string) {
        this.tokenize(string, this.getDelimiters(), this.isReturnDelimiters());
    }

    public void tokenize(String string, String string2) {
        this.tokenize(string, string2, this.isReturnDelimiters());
    }

    public void tokenize(String string, String string2, boolean bl) {
        this.string = string;
        this.delimiters = string2;
        this.returnDelimiters = bl;
        this.reset();
        this.tokens.clear();
        this.positions.clear();
        int n = 0;
        int n2 = 0;
        while (n2 > -1) {
            this.positions.add(n);
            if (this.delimiters.indexOf(this.string.substring(n, n + 1)) == -1) {
                this.tokens.add(this.positions.getSize() - 1);
            }
            if ((n2 = StringUtils.scanToken(this.string, this.delimiters, n)) <= -1) continue;
            if (n2 > n) {
                this.positions.add(n2);
            }
            if (this.returnDelimiters) {
                this.tokens.add(this.positions.getSize() - 1);
            }
            n = n2 + 1;
        }
    }

    public void reset() {
        this.pos = 0;
    }

    public boolean hasMoreTokens() {
        return this.pos < this.tokens.getSize();
    }

    public String nextToken() {
        int n;
        int n2 = this.tokens.getSize();
        if (this.pos == n2) {
            throw new NoSuchElementException("no more tokens");
        }
        if ((n = this.tokens.getIndex(this.pos++)) + 1 == this.positions.getSize()) {
            return this.string.substring(this.positions.getIndex(n));
        }
        return this.string.substring(this.positions.getIndex(n), this.positions.getIndex(n + 1));
    }

    public Iterator iterator() {
        return new Iterator(){

            public boolean hasNext() {
                return Tokenizer.this.hasMoreTokens();
            }

            public Object next() {
                return Tokenizer.this.nextToken();
            }

            public void remove() {
                throw new UnsupportedOperationException("Method remove() not supported");
            }
        };
    }

    public Enumeration enumerator() {
        return new Enumeration(){

            public boolean hasMoreElements() {
                return Tokenizer.this.hasMoreTokens();
            }

            public Object nextElement() {
                return Tokenizer.this.nextToken();
            }
        };
    }
}

