/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.compiler;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import uk.org.retep.util.compiler.Compiler;

public abstract class AbstractCompiler
implements Compiler {
    private static final String INDENT0 = "  ";
    private static final String INDENT1 = "    ";
    public static final String BCLOSE = ")";
    public static final String BOPEN = "(";
    public static final String CLOSE = "}";
    public static final String COMMENT = "// ";
    public static final String CCOMSTART = "/*";
    public static final String COMSTART = "/**";
    public static final String COMLINE = " * ";
    public static final String COMEND = " */";
    public static final String EMPTY = "";
    public static final String OPEN = "{";
    public static final String QUOTE = "\"";
    public static final String SPC = " ";
    public static final String WARNING = "Warning! this file was generated by retepTools - BEWARE if editing this file";
    protected String name;
    protected Vector comment;
    private boolean indent = true;

    public AbstractCompiler() {
    }

    public AbstractCompiler(String string) {
        this.setName(string);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public static Vector add(Vector vector, Object object) {
        if (vector == null) {
            vector = new Vector<Object>();
        }
        vector.add(object);
        return vector;
    }

    public void addComment(String string) {
        this.comment = AbstractCompiler.add(this.comment, string);
    }

    public void addComment() {
        this.addComment(EMPTY);
    }

    public void write(PrintWriter printWriter) throws IOException {
        Vector vector = new Vector();
        this.write(vector);
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = ((AbstractList)vector).iterator();
        while (iterator.hasNext()) {
            stringBuffer.setLength(0);
            String string = (String)iterator.next();
            n = this.indent(n, stringBuffer, string);
            printWriter.println(stringBuffer.toString());
        }
    }

    public abstract void write(Vector var1) throws IOException;

    public abstract File getFile(File var1);

    public void save(File file) throws IOException {
        File file2 = this.getFile(file);
        file2.getParentFile().mkdirs();
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file2));
        this.write(printWriter);
        printWriter.close();
    }

    public static void writeComment(Vector vector, Vector vector2) {
        AbstractCompiler.writeComment(vector, vector2, COMSTART, COMLINE, COMEND);
    }

    public static void writeComment(Vector vector, Vector vector2, String string, String string2, String string3) {
        if (vector2 != null) {
            vector.add(string);
            Iterator iterator = ((AbstractList)vector2).iterator();
            while (iterator.hasNext()) {
                vector.add(string2 + iterator.next().toString());
            }
            vector.add(string3);
        }
    }

    public void setIndent(boolean bl) {
        this.indent = bl;
    }

    public boolean isIndent() {
        return this.indent;
    }

    public int indent(int n, StringBuffer stringBuffer, String string) {
        if (this.isIndent()) {
            if (string.startsWith(CLOSE) | string.endsWith(CLOSE) && --n < 0) {
                n = 0;
            }
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(INDENT0);
                ++n2;
            }
            stringBuffer.append(string);
            if (string.endsWith(OPEN)) {
                ++n;
            }
        } else {
            stringBuffer.append(string);
        }
        return n;
    }
}

