/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.compiler;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import uk.org.retep.util.compiler.AbstractCompiler;

public class CSource
extends AbstractCompiler {
    public static String VOID = "void";
    TreeMap include = new TreeMap();
    TreeMap functions = new TreeMap();

    public CSource() {
    }

    public CSource(String string) {
        super(string);
        this.addComment("Warning! this file was generated by retepTools - BEWARE if editing this file");
        this.addComment("Source created " + new Date());
        this.addComment();
    }

    public void addInclude(String string) {
        this.include.put(string, string);
    }

    public function addFunction(String string, String string2, String string3) {
        return this.addFunction(string, string2, string3, false);
    }

    public function addFunction(String string, String string2, String string3, boolean bl) {
        function function2 = new function(string, string2, string3, bl);
        this.functions.put(string, function2);
        return function2;
    }

    public function getFunction(String string) {
        return (function)this.functions.get(string);
    }

    public function addMain() {
        return this.addFunction("main", "int", "int argc,char** argv");
    }

    public function getMain() {
        return this.getFunction("main");
    }

    public File getFile(File file) {
        return new File(file, this.getName());
    }

    public void write(Vector vector) throws IOException {
        Object object;
        AbstractCompiler.writeComment(vector, this.comment);
        vector.add("");
        Iterator iterator = this.include.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            vector.add("#include \"" + (String)object + "\"");
        }
        vector.add("");
        iterator = this.functions.keySet().iterator();
        while (iterator.hasNext()) {
            object = (function)this.functions.get(iterator.next());
            ((function)object).write(vector);
        }
    }

    public class function {
        private String name;
        private String retType;
        private String args;
        private boolean fStatic;
        private Vector content = new Vector();
        private Vector comment;

        private function(String string, String string2, String string3, boolean bl) {
            this.name = string;
            this.retType = string2;
            this.args = string3;
            this.fStatic = bl;
        }

        public void write(Vector vector) {
            StringBuffer stringBuffer = new StringBuffer();
            vector.add("");
            AbstractCompiler.writeComment(vector, this.comment);
            stringBuffer.setLength(0);
            if (this.fStatic) {
                stringBuffer.append("static ");
            }
            stringBuffer.append(this.retType).append(" ").append(this.name).append("(").append(this.args).append(")");
            vector.add(stringBuffer.toString());
            vector.add("{");
            vector.addAll(this.content);
            vector.add("}");
        }

        public function clearCode() {
            this.content.clear();
            return this;
        }

        public function clearComment() {
            this.comment = null;
            return this;
        }

        public function append(String string) {
            this.content.add(string);
            return this;
        }

        public function append() {
            return this.append("");
        }

        public function appendComment(String string) {
            this.content.add("// " + string);
            return this;
        }

        public function appendWhile(String string) {
            return this.append("while(" + string + ") {");
        }

        public function appendIf(String string) {
            return this.append("if(" + string + ") {");
        }

        public function appendElse() {
            return this.append("} else {");
        }

        public function appendElseIf(String string) {
            return this.appendClose().append("else if(" + string + ") {");
        }

        public function appendSwitch(String string) {
            return this.append("switch" + string + ")").appendOpen();
        }

        public function appendCase(String string) {
            return this.append("case " + string + ":");
        }

        public function appendBreak() {
            return this.append("break;").append();
        }

        public function appendDefault() {
            return this.append("default;");
        }

        public function appendOpen() {
            return this.append("{");
        }

        public function appendClose() {
            return this.append("}");
        }

        public function appendPrintf(String string) {
            return this.appendPrintf("\"%s\"", string);
        }

        public function appendPrintf(String string, String string2) {
            return this.append("printf(" + string + "," + string2 + ");");
        }

        public function appendFor(String string, String string2, String string3) {
            return this.append("for(" + string + ";" + string2 + ";" + string3 + ") " + "{");
        }

        public function appendDebug(String string) {
            return this.appendDebug("%s", string);
        }

        public function appendDebug(String string, String string2) {
            return this.appendPrintf("\"%s:%d:" + string + "\\n\"", "__FILE__,__LINE__," + string2);
        }

        public function comment(String string) {
            this.comment = AbstractCompiler.add(this.comment, string);
            return this;
        }

        public function comment() {
            return this.comment("");
        }
    }
}

