/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.xml.core;

import java.util.HashMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import uk.org.retep.xml.core.XMLWriter;

public class XMLRef {
    private HashMap refs = new HashMap();
    private int oid = 0;
    private XMLWriter out;
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public XMLRef() {
    }

    protected XMLRef(XMLWriter xMLWriter) {
        this.out = xMLWriter;
    }

    public void close() {
        this.refs.clear();
    }

    public boolean test(Object object) {
        if (this.refs.containsKey(object)) {
            this.out.addAttribute("XREF", (String)this.getObject(object));
            this.out.closeTag();
            return false;
        }
        this.out.addAttribute("REF", (String)this.getObject(object));
        return true;
    }

    public boolean contains(Object object) {
        return this.refs.containsKey(object);
    }

    public Object getRef(Object object) {
        return this.refs.get(object);
    }

    public Object getObject(Object object) {
        Object object2 = this.refs.get(object);
        if (object2 == null) {
            object2 = this.createUUID();
            this.addObject(object, object2);
        }
        return object2;
    }

    public void addObject(Object object, Object object2) {
        this.refs.put(object, object2);
        this.refs.put(object2, object);
    }

    public boolean removeObject(Object object) {
        Object v = this.refs.get(object);
        if (v == null) {
            return false;
        }
        this.refs.remove(v);
        this.refs.remove(object);
        return true;
    }

    public String createUUID() {
        StringBuffer stringBuffer = new StringBuffer();
        ++this.oid;
        stringBuffer.append(this.oid);
        return stringBuffer.toString();
    }

    public Object retrieveElement(Element element) {
        Element element2 = element;
        Attr attr = element2.getAttributeNode("XREF");
        if (attr != null) {
            return this.getRef(attr.getValue());
        }
        return null;
    }

    public void addElement(Element element, Object object) {
        Element element2 = element;
        Attr attr = element2.getAttributeNode("REF");
        if (attr != null) {
            this.addObject(object, attr.getValue());
        }
    }

    public int size() {
        return this.refs.size() / 2;
    }
}

