/*
 * Decompiled with CFR 0.152.
 */
package jp.turbosql.modules.sketcher.app;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.event.MouseInputAdapter;

public class CurveApplet
extends JApplet {
    Point2D.Double startQ = new Point2D.Double(50.0, 150.0);
    Point2D.Double endQ = new Point2D.Double(150.0, 150.0);
    Point2D.Double control = new Point2D.Double(80.0, 100.0);
    Point2D.Double startC = new Point2D.Double(50.0, 300.0);
    Point2D.Double endC = new Point2D.Double(150.0, 300.0);
    Point2D.Double controlStart = new Point2D.Double(80.0, 250.0);
    Point2D.Double controlEnd = new Point2D.Double(160.0, 250.0);
    QuadCurve2D.Double quadCurve;
    CubicCurve2D.Double cubicCurve;
    CurvePane pane = new CurvePane();
    Marker ctrlQuad = new Marker(this.control);
    Marker ctrlCubic1 = new Marker(this.controlStart);
    Marker ctrlCubic2 = new Marker(this.controlEnd);

    public void init() {
        this.pane = new CurvePane();
        Container content = this.getContentPane();
        content.add(this.pane);
        MouseHandler handler = new MouseHandler();
        this.pane.addMouseListener(handler);
        this.pane.addMouseMotionListener(handler);
    }

    class MouseHandler
    extends MouseInputAdapter {
        Marker selected = null;

        MouseHandler() {
        }

        public void mousePressed(MouseEvent e) {
            if (CurveApplet.this.ctrlQuad.contains(e.getX(), e.getY())) {
                this.selected = CurveApplet.this.ctrlQuad;
            } else if (CurveApplet.this.ctrlCubic1.contains(e.getX(), e.getY())) {
                this.selected = CurveApplet.this.ctrlCubic1;
            } else if (CurveApplet.this.ctrlCubic2.contains(e.getX(), e.getY())) {
                this.selected = CurveApplet.this.ctrlCubic2;
            }
            CurveApplet.this.pane.repaint();
        }

        public void mouseReleased(MouseEvent e) {
            this.selected = null;
            CurveApplet.this.pane.repaint();
        }

        public void mouseDragged(MouseEvent e) {
            if (this.selected != null) {
                this.selected.setLocation(e.getX(), e.getY());
                CurveApplet.this.pane.repaint();
            }
        }
    }

    class Marker {
        Ellipse2D.Double circle;
        Point2D.Double center;
        static final double radius = 3.0;

        public Marker(Point2D.Double control) {
            this.center = control;
            this.circle = new Ellipse2D.Double(control.x - 3.0, control.y - 3.0, 6.0, 6.0);
        }

        public void draw(Graphics2D g2D) {
            g2D.draw(this.circle);
        }

        Point2D.Double getCenter() {
            return this.center;
        }

        public boolean contains(double x, double y) {
            return this.circle.contains(x, y);
        }

        public void setLocation(double x, double y) {
            this.center.x = x;
            this.center.y = y;
            this.circle.x = x - 3.0;
            this.circle.y = y - 3.0;
        }

        static {
            radius = 3.0;
        }
    }

    class CurvePane
    extends JComponent {
        public CurvePane() {
            CurveApplet.this.quadCurve = new QuadCurve2D.Double(CurveApplet.this.startQ.x, CurveApplet.this.startQ.y, CurveApplet.this.control.x, CurveApplet.this.control.y, CurveApplet.this.endQ.x, CurveApplet.this.endQ.y);
            CurveApplet.this.cubicCurve = new CubicCurve2D.Double(CurveApplet.this.startC.x, CurveApplet.this.startC.y, CurveApplet.this.controlStart.x, CurveApplet.this.controlStart.y, CurveApplet.this.controlEnd.x, CurveApplet.this.controlEnd.y, CurveApplet.this.endC.x, CurveApplet.this.endC.y);
        }

        public void paint(Graphics g) {
            Graphics2D g2D = (Graphics2D)g;
            CurveApplet.this.quadCurve.ctrlx = CurveApplet.this.ctrlQuad.getCenter().x;
            CurveApplet.this.quadCurve.ctrly = CurveApplet.this.ctrlQuad.getCenter().y;
            CurveApplet.this.cubicCurve.ctrlx1 = CurveApplet.this.ctrlCubic1.getCenter().x;
            CurveApplet.this.cubicCurve.ctrly1 = CurveApplet.this.ctrlCubic1.getCenter().y;
            CurveApplet.this.cubicCurve.ctrlx2 = CurveApplet.this.ctrlCubic2.getCenter().x;
            CurveApplet.this.cubicCurve.ctrly2 = CurveApplet.this.ctrlCubic2.getCenter().y;
            g2D.setPaint(Color.blue);
            g2D.draw(CurveApplet.this.quadCurve);
            g2D.draw(CurveApplet.this.cubicCurve);
            g2D.setPaint(Color.red);
            CurveApplet.this.ctrlQuad.draw(g2D);
            CurveApplet.this.ctrlCubic1.draw(g2D);
            CurveApplet.this.ctrlCubic2.draw(g2D);
            Line2D.Double tangent = new Line2D.Double(CurveApplet.this.startQ, CurveApplet.this.ctrlQuad.getCenter());
            g2D.draw(tangent);
            tangent = new Line2D.Double(CurveApplet.this.endQ, CurveApplet.this.ctrlQuad.getCenter());
            g2D.draw(tangent);
            tangent = new Line2D.Double(CurveApplet.this.startC, CurveApplet.this.ctrlCubic1.getCenter());
            g2D.draw(tangent);
            tangent = new Line2D.Double(CurveApplet.this.endC, CurveApplet.this.ctrlCubic1.getCenter());
            g2D.draw(tangent);
            tangent = new Line2D.Double(CurveApplet.this.startC, CurveApplet.this.ctrlCubic2.getCenter());
            g2D.draw(tangent);
            tangent = new Line2D.Double(CurveApplet.this.endC, CurveApplet.this.ctrlCubic2.getCenter());
            g2D.draw(tangent);
        }
    }
}

