/*
 * Decompiled with CFR 0.152.
 */
package jp.turbosql.modules.sketcher.app;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JPanel;

public class Lottery
extends JApplet {
    static final int numberCount = 6;
    static final int minValue = 1;
    static final int maxValue = 49;
    static int[] values;
    private Selection[] luckyNumbers = new Selection[6];
    public static final int PICK_LUCKY_NUMBERS = 1;
    public static final int COLOR = 2;
    Color flipColor = new Color(Color.yellow.getRGB() ^ Color.red.getRGB());
    Color startColor = new Color(Color.yellow.getRGB());
    private static Random choice;
    private JButton pickButton = new JButton("Lucky Numbers!");
    private JButton colorButton = new JButton("Color");

    public void init() {
        Container content = this.getContentPane();
        content.setLayout(new GridLayout(0, 1));
        JPanel buttonPane = new JPanel();
        buttonPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(Color.cyan, Color.blue), "\u52dd\u3063\u305f\u305c\uff01"));
        int[] choices = Lottery.getNumbers();
        MouseHandler mouseHandler = new MouseHandler();
        int i = 0;
        while (i < 6) {
            this.luckyNumbers[i] = new Selection(choices[i]);
            this.luckyNumbers[i].addMouseListener(mouseHandler);
            buttonPane.add(this.luckyNumbers[i]);
            ++i;
        }
        content.add(buttonPane);
        JPanel controlPane = new JPanel(new FlowLayout(1, 5, 10));
        Dimension buttonSize = new Dimension(100, 20);
        this.pickButton.setPreferredSize(buttonSize);
        this.pickButton.setBorder(BorderFactory.createRaisedBevelBorder());
        this.colorButton.setPreferredSize(buttonSize);
        this.colorButton.setBorder(BorderFactory.createRaisedBevelBorder());
        HandleControlButton controlHandler = new HandleControlButton();
        this.pickButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int[] numbers = Lottery.getNumbers();
                int i = 0;
                while (i < 6) {
                    Lottery.this.luckyNumbers[i].setValue(numbers[i]);
                    ++i;
                }
            }
        });
        this.colorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Color color = new Color(Lottery.this.flipColor.getRGB() ^ Lottery.this.luckyNumbers[0].getBackground().getRGB());
                int i = 0;
                while (i < 6) {
                    Lottery.this.luckyNumbers[i].setBackground(color);
                    ++i;
                }
            }
        });
        controlPane.add(this.pickButton);
        controlPane.add(this.colorButton);
        content.add(controlPane);
    }

    static int[] getNumbers() {
        int[] numbers = new int[6];
        int candidate = 0;
        int i = 0;
        while (i < 6) {
            block1: while (true) {
                candidate = values[choice.nextInt(values.length)];
                int j = 0;
                while (j < i) {
                    if (candidate == numbers[j]) continue block1;
                    ++j;
                }
                break;
            }
            numbers[i] = candidate;
            ++i;
        }
        return numbers;
    }

    static {
        numberCount = 6;
        minValue = 1;
        maxValue = 49;
        values = new int[49];
        int i = 0;
        while (i < values.length) {
            Lottery.values[i] = i + 1;
            ++i;
        }
        PICK_LUCKY_NUMBERS = 1;
        COLOR = 2;
        choice = new Random();
    }

    class MouseHandler
    extends MouseAdapter {
        Cursor handCursor = new Cursor(12);
        Cursor defaultCursor = new Cursor(0);

        MouseHandler() {
        }

        public void mouseEntered(MouseEvent e) {
            e.getComponent().setCursor(this.handCursor);
        }

        public void mouseExited(MouseEvent e) {
            e.getComponent().setCursor(this.defaultCursor);
        }
    }

    class HandleControlButton
    implements ActionListener {
        HandleControlButton() {
        }

        public void actionPerformed(ActionEvent e) {
            block3: {
                Object source;
                block2: {
                    source = e.getSource();
                    if (source != Lottery.this.pickButton) break block2;
                    int[] numbers = Lottery.getNumbers();
                    int i = 0;
                    while (i < 6) {
                        Lottery.this.luckyNumbers[i].setValue(numbers[i]);
                        ++i;
                    }
                    break block3;
                }
                if (source != Lottery.this.colorButton) break block3;
                Color color = new Color(Lottery.this.flipColor.getRGB() ^ Lottery.this.luckyNumbers[0].getBackground().getRGB());
                int i = 0;
                while (i < 6) {
                    Lottery.this.luckyNumbers[i].setBackground(color);
                    ++i;
                }
            }
        }
    }

    class Selection
    extends JButton
    implements ActionListener {
        private int value;

        public Selection(int value) {
            super(Integer.toString(value));
            this.value = value;
            this.setBackground(Lottery.this.startColor);
            this.setBorder(BorderFactory.createRaisedBevelBorder());
            this.setPreferredSize(new Dimension(80, 20));
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            int candidate = 0;
            while (this.isCurrentSelection(candidate = values[choice.nextInt(values.length)])) {
            }
            this.setValue(candidate);
        }

        public void setValue(int value) {
            this.setText(Integer.toString(value));
            this.value = value;
        }

        boolean hasValue(int possible) {
            return this.value == possible;
        }

        boolean isCurrentSelection(int possible) {
            int i = 0;
            while (i < 6) {
                if (Lottery.this.luckyNumbers[i].hasValue(possible)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

