/*
 * Decompiled with CFR 0.152.
 */
package jp.turbosql.modules.sketcher.app;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import jp.turbosql.modules.sketcher.app.Constants;

public class SketchFrame
extends JFrame
implements Constants {
    private JMenuBar menuBar = new JMenuBar();
    private JMenuItem newItem;
    private JMenuItem openItem;
    private JMenuItem closeItem;
    private JMenuItem saveItem;
    private JMenuItem saveAsItem;
    private JMenuItem printItem;
    private JRadioButtonMenuItem lineItem;
    private JRadioButtonMenuItem rectangleItem;
    private JRadioButtonMenuItem circleItem;
    private JRadioButtonMenuItem curveItem;
    private JRadioButtonMenuItem textItem;
    private JCheckBoxMenuItem redItem;
    private JCheckBoxMenuItem yellowItem;
    private JCheckBoxMenuItem greenItem;
    private JCheckBoxMenuItem blueItem;
    private Color elementColor = Constants.DEFAULT_ELEMENT_COLOR;
    private int elementType = 101;

    public SketchFrame(String title) {
        this.setTitle(title);
        this.setDefaultCloseOperation(2);
        this.setJMenuBar(this.menuBar);
        JMenu fileMenu = new JMenu("File");
        JMenu elementMenu = new JMenu("Elements");
        fileMenu.setMnemonic('F');
        elementMenu.setMnemonic('E');
        this.newItem = fileMenu.add("New");
        this.openItem = fileMenu.add("Open");
        this.closeItem = fileMenu.add("Close");
        fileMenu.addSeparator();
        this.saveItem = fileMenu.add("Save");
        this.saveAsItem = fileMenu.add("Save As...");
        this.printItem = fileMenu.add("Print");
        this.newItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.openItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.saveItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.printItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.lineItem = new JRadioButtonMenuItem("Line", this.elementType == 101);
        elementMenu.add(this.lineItem);
        this.rectangleItem = new JRadioButtonMenuItem("Rectangle", this.elementType == 102);
        elementMenu.add(this.rectangleItem);
        this.circleItem = new JRadioButtonMenuItem("Circle", this.elementType == 103);
        elementMenu.add(this.circleItem);
        this.curveItem = new JRadioButtonMenuItem("Curve", this.elementType == 104);
        elementMenu.add(this.curveItem);
        ButtonGroup types = new ButtonGroup();
        types.add(this.lineItem);
        types.add(this.rectangleItem);
        types.add(this.circleItem);
        types.add(this.curveItem);
        this.lineItem.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.rectangleItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.circleItem.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        this.curveItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.lineItem.addActionListener(new TypeListener(101));
        this.rectangleItem.addActionListener(new TypeListener(102));
        this.circleItem.addActionListener(new TypeListener(103));
        this.curveItem.addActionListener(new TypeListener(104));
        elementMenu.addSeparator();
        JMenu colorMenu = new JMenu("Color");
        elementMenu.add(colorMenu);
        this.redItem = new JCheckBoxMenuItem("Red", this.elementColor.equals(Color.red));
        colorMenu.add(this.redItem);
        this.yellowItem = new JCheckBoxMenuItem("Yellow", this.elementColor.equals(Color.yellow));
        colorMenu.add(this.yellowItem);
        this.greenItem = new JCheckBoxMenuItem("Green", this.elementColor.equals(Color.green));
        colorMenu.add(this.greenItem);
        this.blueItem = new JCheckBoxMenuItem("Blue", this.elementColor.equals(Color.blue));
        colorMenu.add(this.blueItem);
        this.redItem.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.yellowItem.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        this.greenItem.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        this.blueItem.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        this.redItem.addActionListener(new ColorListener(Color.red));
        this.yellowItem.addActionListener(new ColorListener(Color.yellow));
        this.greenItem.addActionListener(new ColorListener(Color.green));
        this.blueItem.addActionListener(new ColorListener(Color.blue));
        ButtonGroup colors = new ButtonGroup();
        colors.add(this.redItem);
        colors.add(this.yellowItem);
        colors.add(this.greenItem);
        colors.add(this.blueItem);
        this.menuBar.add(fileMenu);
        this.menuBar.add(elementMenu);
    }

    class ColorListener
    implements ActionListener {
        private Color color;

        public ColorListener(Color color) {
            this.color = color;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SketchFrame.this.elementColor = this.color;
        }
    }

    class TypeListener
    implements ActionListener {
        private int type;

        TypeListener(int type) {
            this.type = type;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SketchFrame.this.elementType = this.type;
        }
    }
}

