/*
 * Decompiled with CFR 0.152.
 */
package jp.turbosql.modules.sketcher.app;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import jp.turbosql.modules.sketcher.app.SketchFrame2;
import jp.turbosql.modules.sketcher.app.SketchModel;
import jp.turbosql.modules.sketcher.app.SketchView;
import org.openide.windows.TopComponent;

public class Sketcher
extends TopComponent {
    private static SketchFrame2 window;
    private static Sketcher theApp;
    private static SketchModel sketch;
    private static SketchView view;

    public static void main(String[] args) {
        theApp = new Sketcher();
        theApp.init();
    }

    public Sketcher() {
        this.init();
    }

    public void init() {
        window = new SketchFrame2("Sketcher", this);
        Toolkit theKit = window.getToolkit();
        Dimension wndSize = theKit.getScreenSize();
        this.add(window);
        window.setBounds(wndSize.width / 6, wndSize.height / 6, 2 * wndSize.width / 3, 2 * wndSize.height / 3);
        sketch = new SketchModel();
        view = new SketchView(this);
        sketch.addObserver(view);
        window.getContentPane().add((Component)view, "Center");
        window.setVisible(true);
        sketch.addObserver(window);
    }

    public SketchFrame2 getWindow() {
        return window;
    }

    public SketchModel getModel() {
        return sketch;
    }

    public SketchView getView() {
        return view;
    }

    public void insertModel(SketchModel newSketch) {
        sketch = newSketch;
        sketch.addObserver(view);
        sketch.addObserver(window);
        view.repaint();
    }

    class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        public void windowClosing(WindowEvent e) {
            window.checkForSave();
            window.dispose();
            System.exit(0);
        }
    }
}

