/*
 * Decompiled with CFR 0.152.
 */
package jp.turbosql.modules.sketcher.ide;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.StringTokenizer;
import java.util.Vector;
import jp.turbosql.modules.sketcher.ide.DatabaseDataObjectInterface;
import jp.turbosql.modules.sketcher.ide.StatementMetaData;

public class PostgreSQLDataObject
implements DatabaseDataObjectInterface {
    private static final String QUOTE = "\"";
    private static final String SQL_GET_DATABASES = "SELECT oid, *, pg_encoding_to_char(encoding) AS serverencoding, pg_get_userbyid(datdba) AS datowner FROM pg_database";
    private static final String SQL_GET_LANGUAGES = "SELECT now() AS ts, oid, * FROM pg_language";
    private static final String SQL_GET_USERS = "SELECT * FROM pg_user";
    private static final String SQL_GET_GROUPS = "SELECT * FROM pg_group";
    private static final String SQL_GET_SEQUENCES = "SELECT now() AS ts, oid, relname, pg_get_userbyid(relowner) AS seqowner, relacl FROM pg_class WHERE relkind = 'S'";
    private static final String SQL_GET_VIEWS = "SELECT now() AS ts, c.oid, c.relname, pg_get_userbyid(c.relowner) AS viewowner, c.relacl, pg_get_viewdef(c.relname) AS definition FROM pg_class c WHERE ((c.relhasrules AND (EXISTS (SELECT r.rulename FROM pg_rewrite r WHERE ((r.ev_class = c.oid) AND (bpchar(r.ev_type) = '1'::bpchar))))) OR (c.relkind = 'v'::\"char\"))";
    private static final String SQL_GET_TYPES7_1 = "SELECT now() AS ts, oid, *, pg_get_userbyid(typowner) as typeowner FROM pg_type WHERE typrelid = 0";
    private static final String SQL_GET_TYPES7_3 = "SELECT now() AS ts, oid, *, pg_get_userbyid(typowner) as typeowner FROM pg_type WHERE typtype = 'b'";
    private static final String SQL_GET_DOMAINS = "SELECT now() AS ts, oid, *, pg_get_userbyid(typowner) as domainowner FROM pg_type WHERE typtype = 'd'";
    private static final String SQL_GET_FUNCTIONS = "SELECT now() AS ts, oid, *, pg_get_userbyid(proowner) as funcowner FROM pg_proc";
    private static final String SQL_GET_OPERATORS = "SELECT now() AS ts, oid, *, pg_get_userbyid(oprowner) as opowner FROM pg_operator";
    private static final String SQL_GET_RULES = "SELECT now() AS ts, oid, rulename, pg_get_ruledef(rulename) as definition FROM pg_rewrite";
    private static final String SQL_GET_TRIGGERS = "SELECT now() AS ts, t.oid, tgname, proname, tgargs, tgtype FROM pg_trigger t, pg_proc p WHERE t.tgfoid = p.oid AND tgisconstraint = FALSE";
    private static final String SQL_GET_TABLES7_1 = "SELECT now() AS ts, oid, relname, pg_get_userbyid(relowner) as tableowner, relacl FROM pg_class WHERE ((relkind = 'r') OR (relkind = 's'))";
    private static final String SQL_GET_TABLES7_2 = "SELECT now() AS ts, oid, relname, pg_get_userbyid(relowner) as tableowner, relacl, relhasoids FROM pg_class WHERE ((relkind = 'r') OR (relkind = 's'))";
    private static final String SQL_GET_COLUMNS7_1 = "SELECT a.oid, a.attname, a.attnum, t.typname, CASE WHEN ((a.attlen = -1) AND ((a.atttypmod)::int4 = (-1)::int4)) THEN (0)::int4 ELSE CASE WHEN a.attlen = -1 THEN CASE WHEN ((t.typname = 'bpchar') OR (t.typname = 'char') OR (t.typname = 'varchar')) THEN (a.atttypmod -4)::int4 ELSE (a.atttypmod)::int4 END ELSE (a.attlen)::int4 END END AS length, a.attnotnull, (SELECT adsrc FROM pg_attrdef d WHERE d.adrelid = a.attrelid AND d.adnum = a.attnum) AS default, (SELECT indisprimary FROM pg_index i, pg_class ic, pg_attribute ia  WHERE i.indrelid = a.attrelid AND i.indexrelid = ic.oid AND ic.oid = ia.attrelid AND ia.attname = a.attname LIMIT 1) AS primarykey FROM pg_attribute a, pg_type t WHERE a.atttypid = t.oid";
    private static final String SQL_GET_COLUMNS7_2 = "SELECT 0::oid AS oid, a.attname, a.attnum, t.typname, CASE WHEN ((a.attlen = -1) AND ((a.atttypmod)::int4 = (-1)::int4)) THEN (0)::int4 ELSE CASE WHEN a.attlen = -1 THEN CASE WHEN ((t.typname = 'bpchar') OR (t.typname = 'char') OR (t.typname = 'varchar')) THEN (a.atttypmod -4)::int4 ELSE (a.atttypmod)::int4 END ELSE (a.attlen)::int4 END END AS length, a.attnotnull, (SELECT adsrc FROM pg_attrdef d WHERE d.adrelid = a.attrelid AND d.adnum = a.attnum) AS default, (SELECT indisprimary FROM pg_index i, pg_class ic, pg_attribute ia  WHERE i.indrelid = a.attrelid AND i.indexrelid = ic.oid AND ic.oid = ia.attrelid AND ia.attname = a.attname LIMIT 1) AS primarykey FROM pg_attribute a, pg_type t WHERE a.atttypid = t.oid";
    private static final String SQL_GET_INDEXES = "SELECT now() AS ts, i.oid, i.relname, x.indisunique, x.indisprimary, pg_get_indexdef(i.oid) AS definition FROM pg_index x, pg_class i WHERE i.oid = x.indexrelid";
    private static final String SQL_GET_INDEX_COLUMNS = "SELECT attname FROM pg_attribute";
    private static final String SQL_GET_CHECKS = "SELECT rcname, rcsrc FROM pg_relcheck WHERE NOT EXISTS (SELECT * FROM pg_relcheck AS c, pg_inherits AS i WHERE i.inhrelid = pg_relcheck.rcrelid AND (c.rcname = pg_relcheck.rcname OR (c.rcname[0] = '$' AND pg_relcheck.rcname[0] = '$')) AND c.rcsrc = pg_relcheck.rcsrc AND  c.rcrelid = i.inhparent)";
    private static final String SQL_GET_INHERITED_TABLES = "SELECT c.relname FROM pg_class c, pg_inherits i WHERE c.oid = i.inhparent";
    private static final String SQL_GET_AGGREGATES = "SELECT now() AS ts, oid, aggname, pg_get_userbyid(aggowner) AS owner, aggtransfn, aggfinalfn, aggbasetype, aggtranstype, aggfinaltype, agginitval FROM pg_aggregate";
    private static final String SQL_GET_FOREIGN_KEYS = "SELECT oid, tgrelid, tgconstrname, tgnargs, tgargs, tgdeferrable, tginitdeferred FROM pg_trigger WHERE tgisconstraint = TRUE AND tgtype = 21";
    private static final String SQL_CREATE_REVLOG = "CREATE TABLE pgadmin_rclog(rc_timestamp timestamp DEFAULT now(), rc_user name DEFAULT current_user, rc_action varchar(1), rc_type varchar(32), rc_identifier varchar(256), rc_oid oid, rc_table varchar(64), rc_version int4, rc_definition text, rc_comment text); GRANT SELECT, INSERT ON pgadmin_rclog TO PUBLIC; COMMENT ON TABLE pgadmin_rclog IS 'pgAdmin II Revision Log'; CREATE INDEX pgadmin_rclog_idx ON pgadmin_rclog (rc_action, rc_type, rc_identifier, rc_table, rc_oid, rc_version);";
    private static final String SQL_DROP_REVLOG = "DROP TABLE pgadmin_rclog;";
    private static final String SQL_GRAVEYARD = "SELECT DISTINCT ON (rc_type, rc_identifier) * FROM pgadmin_rclog ORDER BY rc_type, rc_identifier, rc_version DESC";

    public static Vector processToDataRows(ResultSet results) {
        Vector<Object[]> dataRows = new Vector<Object[]>();
        try {
            ResultSetMetaData metadata = results.getMetaData();
            int columns = metadata.getColumnCount();
            int[] columnTypes = new int[columns];
            String[] columnTypeNames = new String[columns];
            int i = 0;
            while (i < columns) {
                columnTypes[i] = metadata.getColumnType(i + 1);
                columnTypeNames[i] = metadata.getColumnTypeName(i + 1);
                System.out.println("column " + (i + 1) + ": " + metadata.getColumnTypeName(i + 1));
                ++i;
            }
            while (results.next()) {
                Object[] rowData = new Object[columns];
                int i2 = 0;
                while (i2 < columns) {
                    switch (columnTypes[i2]) {
                        case -7: {
                            System.out.println("column " + (i2 + 1) + " Datatype is BIT");
                            rowData[i2] = new Boolean(results.getBoolean(i2 + 1));
                            break;
                        }
                        case -6: {
                            System.out.println("column " + (i2 + 1) + " Datatype is TINYINT");
                            rowData[i2] = new Byte(results.getByte(i2 + 1));
                            break;
                        }
                        case 5: {
                            System.out.println("column " + (i2 + 1) + " Datatype is SMALLINT");
                            rowData[i2] = new Short(results.getShort(i2 + 1));
                            break;
                        }
                        case 4: {
                            System.out.println("column " + (i2 + 1) + " Datatype is INTEGER");
                            rowData[i2] = new Integer(results.getInt(i2 + 1));
                            break;
                        }
                        case -5: {
                            System.out.println("column " + (i2 + 1) + " Datatype is BIGINT");
                            rowData[i2] = new Long(results.getLong(i2 + 1));
                            break;
                        }
                        case 6: {
                            System.out.println("column " + (i2 + 1) + " Datatype is FLOAT");
                            rowData[i2] = new Float(results.getFloat(i2 + 1));
                            break;
                        }
                        case 8: {
                            System.out.println("column " + (i2 + 1) + " Datatype is DOUBLE");
                            rowData[i2] = new Double(results.getDouble(i2 + 1));
                            break;
                        }
                        case 3: {
                            System.out.println("column " + (i2 + 1) + " Datatype is DECIMAL");
                            rowData[i2] = results.getBigDecimal(i2 + 1);
                            rowData[i2] = new Double(results.getDouble(i2 + 1));
                            break;
                        }
                        case 2: {
                            System.out.println("column " + (i2 + 1) + " Datatype is NUMERIC");
                            rowData[i2] = results.getBigDecimal(i2 + 1);
                            break;
                        }
                        case 1: {
                            System.out.println("column " + (i2 + 1) + " Datatype is CHAR");
                            rowData[i2] = results.getString(i2 + 1);
                            break;
                        }
                        case 12: {
                            System.out.println("column " + (i2 + 1) + " Datatype is VARCHAR");
                            rowData[i2] = results.getString(i2 + 1);
                            break;
                        }
                        case 91: {
                            System.out.println("column " + (i2 + 1) + " Datatype is DATE");
                            Date temp_date = results.getDate(i2 + 1);
                            if (temp_date != null) {
                                rowData[i2] = temp_date.toString();
                                break;
                            }
                            rowData[i2] = null;
                            break;
                        }
                        case 92: {
                            System.out.println("column " + (i2 + 1) + " Datatype is TIME");
                            Time temp_time = results.getTime(i2 + 1);
                            if (temp_time != null) {
                                rowData[i2] = temp_time.toString();
                                break;
                            }
                            rowData[i2] = null;
                            break;
                        }
                        case 93: {
                            System.out.println("column " + (i2 + 1) + " Datatype is TIMESTAMP");
                            Timestamp temp_timestamp = results.getTimestamp(i2 + 1);
                            if (temp_timestamp != null) {
                                rowData[i2] = temp_timestamp.toString();
                                break;
                            }
                            rowData[i2] = null;
                            break;
                        }
                        case 2000: {
                            System.out.println("column " + (i2 + 1) + " Datatype is JAVA_OBJECT");
                            rowData[i2] = results.getObject(i2 + 1);
                            break;
                        }
                        default: {
                            if (columnTypeNames[i2].equals("text")) {
                                System.out.println("column " + (i2 + 1) + " Datatype is text");
                                rowData[i2] = results.getString(i2 + 1);
                                break;
                            }
                            System.out.println("column " + (i2 + 1) + " Datatype is unknown");
                            rowData[i2] = results.getString(i2 + 1);
                        }
                    }
                    if (results.wasNull()) {
                        rowData[i2] = null;
                    }
                    ++i2;
                }
                dataRows.addElement(rowData);
            }
        }
        catch (SQLException sqle) {
            System.err.println(sqle);
        }
        return dataRows;
    }

    public static Object[] processToColumnTypeArray(int[] columnTypes, String[] columnTypeNames) {
        int columnCount = columnTypes.length;
        Object[] columnTypeArray = new Object[columnCount];
        int i = 0;
        while (i < columnCount) {
            switch (columnTypes[i]) {
                case -7: {
                    columnTypeArray[i] = new Boolean(false);
                    break;
                }
                case -6: {
                    columnTypeArray[i] = new Byte(-128);
                    break;
                }
                case 5: {
                    columnTypeArray[i] = new Short(Short.MIN_VALUE);
                    break;
                }
                case 4: {
                    columnTypeArray[i] = new Integer(0);
                    break;
                }
                case -5: {
                    columnTypeArray[i] = new Long(0L);
                    break;
                }
                case 6: {
                    columnTypeArray[i] = new Float(0.0f);
                    break;
                }
                case 8: {
                    columnTypeArray[i] = new Double(0.0);
                    break;
                }
                case 3: {
                    columnTypeArray[i] = new BigDecimal(0.0);
                    break;
                }
                case 2: {
                    columnTypeArray[i] = new BigDecimal(0.0);
                    break;
                }
                case 1: {
                    columnTypeArray[i] = new String("");
                    break;
                }
                case 12: {
                    columnTypeArray[i] = "";
                    break;
                }
                case 91: {
                    columnTypeArray[i] = new String("");
                    break;
                }
                case 92: {
                    columnTypeArray[i] = new String("");
                    break;
                }
                case 93: {
                    columnTypeArray[i] = new String("");
                    break;
                }
                case 2000: {
                    columnTypeArray[i] = new Object();
                    break;
                }
                default: {
                    columnTypeArray[i] = columnTypeNames[i].equals("text") ? new String("") : new String("");
                }
            }
            ++i;
        }
        return columnTypeArray;
    }

    public static StatementMetaData parseSQLStatement(String statement) {
        String statementTrimmed = statement.trim();
        String statementQuote = "";
        boolean inQuote = false;
        int start_ptr = 0;
        boolean end_ptr = false;
        boolean from_start_ptr = false;
        String SQL_KEYWORD_FROM_lc = "from";
        boolean has_FROM = false;
        boolean is_escape = false;
        boolean was_space = false;
        String table_name = "";
        boolean table_updatable = true;
        System.out.println(statementTrimmed.length());
        int i = 0;
        while (i < statementTrimmed.length()) {
            if (is_escape) {
                is_escape = false;
                statementQuote = statementQuote + statementTrimmed.substring(i, i + 1);
            } else if (statementTrimmed.substring(i, i + 1).equals("\\")) {
                is_escape = true;
                statementQuote = statementQuote + statementTrimmed.substring(i, i + 1);
            } else if (statementTrimmed.substring(i, i + 1).equals("'") || statementTrimmed.substring(i, i + 1).equals(QUOTE)) {
                statementQuote = statementQuote + statementTrimmed.substring(i, i + 1);
                inQuote = !inQuote;
            } else {
                statementQuote = (statementTrimmed.substring(i, i + 1).equals(" ") || statementTrimmed.substring(i, i + 1).equals("\n")) && inQuote ? statementQuote + "\t" : ((statementTrimmed.substring(i, i + 1).equals("\t") || statementTrimmed.substring(i, i + 1).equals("\n")) && !inQuote ? statementQuote + " " : statementQuote + statementTrimmed.substring(i, i + 1));
            }
            ++i;
        }
        String temp_str = "";
        String temp_str2 = "";
        int i2 = 0;
        while (i2 < statementQuote.length()) {
            if (statementQuote.substring(i2, i2 + 1).equals(" ") && !was_space) {
                was_space = true;
                temp_str = temp_str + statementQuote.substring(i2, i2 + 1);
            } else if (!statementQuote.substring(i2, i2 + 1).equals(" ")) {
                was_space = false;
                temp_str = temp_str + statementQuote.substring(i2, i2 + 1);
            }
            ++i2;
        }
        statementQuote = temp_str;
        System.out.println(statementQuote);
        temp_str = "";
        String lowerCaseStatementQuote = statementQuote.toLowerCase();
        if (lowerCaseStatementQuote.indexOf(" from ", start_ptr) != -1) {
            has_FROM = true;
            temp_str = statementQuote.substring(lowerCaseStatementQuote.indexOf(" from ", start_ptr) + SQL_KEYWORD_FROM_lc.length() + 2);
            StringTokenizer strTokenizer = new StringTokenizer(temp_str, " ");
            if (strTokenizer.hasMoreTokens()) {
                table_name = strTokenizer.nextToken();
            }
            if (table_name.toLowerCase().equals("only")) {
                table_name = strTokenizer.nextToken();
            }
            temp_str2 = "";
            int i3 = 0;
            while (i3 < table_name.length()) {
                temp_str2 = table_name.substring(i3, i3 + 1).equals("\t") ? temp_str2 + " " : temp_str2 + table_name.substring(i3, i3 + 1);
                ++i3;
            }
            table_name = temp_str2;
            if (table_name.substring(table_name.length() - 1, table_name.length()).equals(",")) {
                table_updatable = false;
                table_name = table_name.substring(0, table_name.length() - 1);
            }
        } else {
            table_updatable = false;
        }
        System.out.println("table: " + table_name);
        return new StatementMetaData(table_name, table_updatable);
    }

    public static PreparedStatement getPreparedStatementForUpdate(Connection conn, String tableName, String[] columnNames, int[] columnTypes, String[] columnTypeNames, Object[] originalRowData, Object[] changedRowData) {
        Vector<Integer> SET_parameters = new Vector<Integer>();
        String sql_statement = "UPDATE " + tableName;
        String WHERE_statement = " WHERE";
        PreparedStatement pStatement = null;
        String temp_condition = "";
        int i = 0;
        while (i < columnNames.length) {
            if (changedRowData[i] != null || originalRowData[i] != null) {
                if (originalRowData[i] == null) {
                    SET_parameters.add(new Integer(i));
                } else if (changedRowData[i] == null) {
                    SET_parameters.add(new Integer(i));
                } else if (!changedRowData[i].equals(originalRowData[i])) {
                    SET_parameters.add(new Integer(i));
                }
            }
            temp_condition = originalRowData[i] == null ? columnNames[i] + " IS NULL" : columnNames[i] + "=?";
            WHERE_statement = i == 0 ? WHERE_statement + " " + temp_condition : WHERE_statement + " AND " + temp_condition;
            ++i;
        }
        sql_statement = sql_statement + " SET";
        int i2 = 0;
        while (i2 < SET_parameters.size()) {
            sql_statement = i2 == 0 ? sql_statement + " " + columnNames[(Integer)SET_parameters.get(i2)] + "=?" : sql_statement + ", " + columnNames[(Integer)SET_parameters.get(i2)] + "=?";
            ++i2;
        }
        sql_statement = sql_statement + WHERE_statement;
        System.out.println(sql_statement);
        if (SET_parameters.size() == 0) {
            sql_statement = ";";
            return null;
        }
        int temp_index = 0;
        try {
            pStatement = conn.prepareStatement(sql_statement);
            int i3 = 0;
            while (i3 < SET_parameters.size()) {
                pStatement.setObject(++temp_index, changedRowData[(Integer)SET_parameters.get(i3)]);
                ++i3;
            }
            int i4 = 0;
            while (i4 < columnNames.length) {
                if (originalRowData[i4] != null) {
                    pStatement.setObject(++temp_index, originalRowData[i4]);
                }
                ++i4;
            }
        }
        catch (SQLException sqle) {
            System.err.println("From pStatement" + sqle);
        }
        System.out.println("temp index: " + temp_index);
        return pStatement;
    }

    static {
        QUOTE = QUOTE;
        SQL_GET_DATABASES = SQL_GET_DATABASES;
        SQL_GET_LANGUAGES = SQL_GET_LANGUAGES;
        SQL_GET_USERS = SQL_GET_USERS;
        SQL_GET_GROUPS = SQL_GET_GROUPS;
        SQL_GET_SEQUENCES = SQL_GET_SEQUENCES;
        SQL_GET_VIEWS = SQL_GET_VIEWS;
        SQL_GET_TYPES7_1 = SQL_GET_TYPES7_1;
        SQL_GET_TYPES7_3 = SQL_GET_TYPES7_3;
        SQL_GET_DOMAINS = SQL_GET_DOMAINS;
        SQL_GET_FUNCTIONS = SQL_GET_FUNCTIONS;
        SQL_GET_OPERATORS = SQL_GET_OPERATORS;
        SQL_GET_RULES = SQL_GET_RULES;
        SQL_GET_TRIGGERS = SQL_GET_TRIGGERS;
        SQL_GET_TABLES7_1 = SQL_GET_TABLES7_1;
        SQL_GET_TABLES7_2 = SQL_GET_TABLES7_2;
        SQL_GET_COLUMNS7_1 = SQL_GET_COLUMNS7_1;
        SQL_GET_COLUMNS7_2 = SQL_GET_COLUMNS7_2;
        SQL_GET_INDEXES = SQL_GET_INDEXES;
        SQL_GET_INDEX_COLUMNS = SQL_GET_INDEX_COLUMNS;
        SQL_GET_CHECKS = SQL_GET_CHECKS;
        SQL_GET_INHERITED_TABLES = SQL_GET_INHERITED_TABLES;
        SQL_GET_AGGREGATES = SQL_GET_AGGREGATES;
        SQL_GET_FOREIGN_KEYS = SQL_GET_FOREIGN_KEYS;
        SQL_CREATE_REVLOG = SQL_CREATE_REVLOG;
        SQL_DROP_REVLOG = SQL_DROP_REVLOG;
        SQL_GRAVEYARD = SQL_GRAVEYARD;
    }
}

