/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.dtu;

import java.io.IOException;
import java.io.Serializable;
import uk.org.retep.dtu.DElement;
import uk.org.retep.dtu.DEnvironment;
import uk.org.retep.dtu.DTransform;
import uk.org.retep.util.Logger;
import uk.org.retep.xml.core.XMLFactory;
import uk.org.retep.xml.core.XMLFactoryException;

public class DNode
implements DElement,
Serializable {
    protected int id = -1;
    protected int type;
    protected int x;
    protected int y;
    public static final int OK = 0;
    public static final int ERROR = 1;
    public static int NOP = 0;
    protected int nf;
    protected int mf;
    protected int nt;
    protected int mt;
    protected DTransform[] fn;
    protected DTransform[] tn;

    public DNode() {
        this(NOP);
    }

    public DNode(int n) {
        this.type = n;
        this.mt = 5;
        this.mf = 5;
        this.nt = 0;
        this.nf = 0;
        this.fn = new DTransform[this.mf];
        this.tn = new DTransform[this.mt];
        Logger.log(2, "new DNode");
    }

    public int getFromTransforms() {
        return this.nf;
    }

    public int getID() {
        return this.id;
    }

    public int getToTransforms() {
        return this.nt;
    }

    public DTransform getTransform(int n) {
        return this.tn[n];
    }

    public int getType() {
        return this.type;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    protected synchronized void removeFrom(DTransform dTransform) {
        int n = 0;
        while (n < this.nf) {
            if (this.tn[n].equals(dTransform)) {
                int n2 = n + 1;
                while (n2 < this.nf) {
                    this.fn[n] = this.fn[n2];
                    ++n2;
                    ++n;
                }
                --this.nf;
                return;
            }
            ++n;
        }
    }

    protected synchronized void removeTo(DTransform dTransform) {
        int n = 0;
        while (n < this.nt) {
            if (this.tn[n].equals(dTransform)) {
                int n2 = n + 1;
                while (n2 < this.nt) {
                    this.tn[n] = this.tn[n2];
                    ++n2;
                    ++n;
                }
                --this.nt;
                return;
            }
            ++n;
        }
    }

    public int run(DEnvironment dEnvironment) {
        return 0;
    }

    public void saveXML(XMLFactory xMLFactory) throws IOException, XMLFactoryException {
        Logger.log(2, "DNode.saveXML start", this);
        xMLFactory.startTag("NODE");
        xMLFactory.addAttribute("ID", new Integer(this.getID()));
        xMLFactory.addAttribute("TYPE", new Integer(this.getType()));
        xMLFactory.addAttribute("X", new Integer(this.getX()));
        xMLFactory.addAttribute("Y", new Integer(this.getY()));
        int n = 0;
        while (n < this.nf) {
            this.fn[n].saveXML(xMLFactory);
            ++n;
        }
        xMLFactory.endTag();
        Logger.log(2, "DNode.saveXML finish", this);
    }

    protected synchronized void setFrom(DTransform dTransform) {
        int n = 0;
        while (n < this.nf) {
            if (this.fn[n].equals(dTransform)) {
                return;
            }
            ++n;
        }
        if (this.nf >= this.mf) {
            this.mf += 5;
            DTransform[] dTransformArray = new DTransform[this.mf];
            System.arraycopy(this.fn, 0, dTransformArray, 0, this.nf);
            this.fn = dTransformArray;
        }
        this.fn[this.nf++] = dTransform;
    }

    public void setID(int n) {
        this.id = n;
        Logger.log(2, "DNode.setID", n);
    }

    public void setPosition(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    protected synchronized void setTo(DTransform dTransform) {
        int n = 0;
        while (n < this.nt) {
            if (this.tn[n].equals(dTransform)) {
                return;
            }
            ++n;
        }
        if (this.nt >= this.mt) {
            this.mt += 5;
            DTransform[] dTransformArray = new DTransform[this.mt];
            System.arraycopy(this.tn, 0, dTransformArray, 0, this.nt);
            this.tn = dTransformArray;
        }
        this.tn[this.nt++] = dTransform;
    }

    public void setType(int n) {
        this.type = n;
        Logger.log(2, "DNode.setType", n);
    }

    public void setX(int n) {
        this.x = n;
    }

    public void setY(int n) {
        this.y = n;
    }
}

