/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util;

import java.io.CharArrayWriter;
import java.io.PrintWriter;

public class Logger {
    protected static int level = -1;
    protected static PrintWriter logger = null;
    public static final int NONE = -1;
    public static final int INFO = 0;
    public static final int ERROR = 1;
    public static final int DEBUG = 2;
    public static final int ALL = 3;
    private static final String[] levels = new String[]{"INFO :", "ERROR:", "DEBUG:", "ALL  :"};

    public static void log(int n, String string) {
        Logger.write(n, string, null);
    }

    public static void log(int n, String string, double d) {
        Object[] objectArray = new Object[]{new Double(d)};
        Logger.write(n, string, objectArray);
    }

    public static void log(int n, String string, double d, Object object) {
        Object[] objectArray = new Object[]{new Double(d), object};
        Logger.write(n, string, objectArray);
    }

    public static void log(int n, String string, int n2) {
        Object[] objectArray = new Object[]{new Integer(n2)};
        Logger.write(n, string, objectArray);
    }

    public static void log(int n, String string, int n2, Object object) {
        Object[] objectArray = new Object[]{new Integer(n2), object};
        Logger.write(n, string, objectArray);
    }

    public static void log(int n, String string, Object object) {
        Object[] objectArray = new Object[]{object};
        Logger.write(n, string, objectArray);
    }

    public static void log(int n, String string, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        Logger.write(n, string, objectArray);
    }

    public static void log(int n, String string, Object object, Object object2, Object object3) {
        Object[] objectArray = new Object[]{object, object2, object3};
        Logger.write(n, string, objectArray);
    }

    public static void log(int n, String string, Throwable throwable) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        PrintWriter printWriter = new PrintWriter(charArrayWriter);
        throwable.printStackTrace(printWriter);
        Object[] objectArray = new Object[]{charArrayWriter.toString()};
        charArrayWriter.close();
        Logger.write(n, string, objectArray);
    }

    public static void log(String string) {
        Logger.log(0, string);
    }

    public static void setLevel(int n) {
        if (logger == null) {
            logger = new PrintWriter(System.out);
        }
        if (n < -1) {
            n = -1;
        } else if (n > 3) {
            n = 3;
        }
        level = n;
        if (level > -1) {
            Logger.log(0, "Log level changed to", level, (Object)levels[level]);
        }
    }

    public static void setLogger(PrintWriter printWriter) {
        if (logger != null) {
            try {
                logger.flush();
                logger.close();
            }
            catch (Exception exception) {
                logger = printWriter;
                Logger.log(1, "Exception while closing logger", exception);
            }
        }
        logger = printWriter;
    }

    private static void write(int n, String string, Object[] objectArray) {
        if (n > 3) {
            n = 3;
        }
        if (n < 0 || n > level) {
            return;
        }
        logger.print("Logger:");
        logger.print(levels[n]);
        logger.print(string);
        if (objectArray != null) {
            int n2 = 0;
            while (n2 < objectArray.length) {
                logger.print(":");
                logger.print(objectArray[n2]);
                ++n2;
            }
        }
        logger.println();
        logger.flush();
    }
}

