/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.misc;

import java.util.StringTokenizer;

public class IPAddress {
    protected long address;
    protected long[] b = new long[4];
    protected boolean invalid = true;

    public IPAddress() {
    }

    public IPAddress(String string) {
        this.setAddress(string);
    }

    public boolean equals(Object object) {
        if (object instanceof IPAddress) {
            IPAddress iPAddress = (IPAddress)object;
            this.refresh();
            iPAddress.refresh();
            if (iPAddress.invalid == this.invalid) {
                return false;
            }
            return this.address == iPAddress.address;
        }
        return false;
    }

    public IPAddress getMask() {
        IPAddress iPAddress = new IPAddress();
        int n = 3;
        while (n > -1 && this.b[n] == 0L) {
            iPAddress.b[n--] = 0L;
        }
        while (n > -1) {
            iPAddress.b[n--] = 255L;
        }
        iPAddress.invalid = false;
        iPAddress.refresh();
        return iPAddress;
    }

    private static int gethoststart(long l) {
        if ((l & 0x80L) == 0L) {
            return 1;
        }
        if ((l & 0xC0L) == 128L) {
            return 2;
        }
        if ((l & 0xE0L) == 192L) {
            return 3;
        }
        return 4;
    }

    public boolean isInvalid() {
        this.refresh();
        return this.invalid;
    }

    public void refresh() {
        if (this.invalid) {
            return;
        }
        this.address = this.b[0] << 24 | this.b[1] << 16 | this.b[2] << 8 | this.b[3];
    }

    public synchronized void setAddress(String string) {
        if (string == null || string.equals("")) {
            this.invalid = true;
            return;
        }
        this.address = 0L;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = 0;
        while (n < 4 && stringTokenizer.hasMoreElements()) {
            this.b[n++] = Long.parseLong(stringTokenizer.nextToken());
        }
        while (n < 4) {
            this.b[n++] = 0L;
        }
        this.invalid = false;
        this.refresh();
    }

    public String toString() {
        this.refresh();
        if (this.invalid) {
            return "*INVALID*";
        }
        return String.valueOf(Long.toString(this.b[0])) + "." + Long.toString(this.b[1]) + "." + Long.toString(this.b[2]) + "." + Long.toString(this.b[3]);
    }

    public boolean validateMask(IPAddress iPAddress) {
        int n = IPAddress.gethoststart(this.b[0]);
        System.out.println("Host start " + n);
        while (n < 4 && this.b[n] == 0L) {
            if (iPAddress.b[n++] <= 0L) continue;
            return false;
        }
        n = 0;
        while (n < 4) {
            if ((this.b[n] & iPAddress.b[n]) != this.b[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

