/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.misc;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeMap;

public class PropertiesIO {
    private static final String specialSaveChars = "=: \t\r\n\f#!";
    private static final char[] hd = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String encode(String string, boolean bl) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n << 1);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case ' ': {
                    if (n2 == 0 || bl) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(' ');
                    break;
                }
                case '\\': {
                    stringBuffer.append('\\').append('\\');
                    break;
                }
                case '\t': {
                    stringBuffer.append('\\').append('t');
                    break;
                }
                case '\n': {
                    stringBuffer.append('\\').append('n');
                    break;
                }
                case '\r': {
                    stringBuffer.append('\\').append('r');
                    break;
                }
                case '\f': {
                    stringBuffer.append('\\').append('f');
                    break;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        stringBuffer.append('\\').append('u');
                        stringBuffer.append(PropertiesIO.toHex(c >> 12 & 0xF));
                        stringBuffer.append(PropertiesIO.toHex(c >> 8 & 0xF));
                        stringBuffer.append(PropertiesIO.toHex(c >> 4 & 0xF));
                        stringBuffer.append(PropertiesIO.toHex(c & 0xF));
                        break;
                    }
                    if (specialSaveChars.indexOf(c) != -1) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static TreeMap getTreeMap(Properties properties) {
        TreeMap treeMap = new TreeMap();
        Iterator iterator2 = ((Hashtable)properties).keySet().iterator();
        while (iterator2.hasNext()) {
            Object k = iterator2.next();
            treeMap.put(k, ((Hashtable)properties).get(k));
        }
        return treeMap;
    }

    public static synchronized void save(Properties properties, OutputStream outputStream, char c, String string) throws IOException {
        PropertiesIO.save(properties, ((Hashtable)properties).keySet().iterator(), outputStream, c, string);
    }

    public static synchronized void save(Properties properties, Iterator iterator2, OutputStream outputStream, char c, String string) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "8859_1"));
        if (string != null) {
            bufferedWriter.write(35);
            bufferedWriter.write(string);
            bufferedWriter.newLine();
        }
        bufferedWriter.write(35);
        bufferedWriter.write(new Date().toString());
        bufferedWriter.newLine();
        while (iterator2.hasNext()) {
            String string2 = (String)iterator2.next();
            bufferedWriter.write(PropertiesIO.encode(string2, true));
            bufferedWriter.write(c);
            bufferedWriter.write(PropertiesIO.encode((String)((Hashtable)properties).get(string2), false));
            bufferedWriter.newLine();
        }
        bufferedWriter.flush();
    }

    public static synchronized void saveSorted(Properties properties, OutputStream outputStream, char c, String string) throws IOException {
        PropertiesIO.save(properties, PropertiesIO.getTreeMap(properties).keySet().iterator(), outputStream, c, string);
    }

    public static char toHex(int n) {
        return hd[n & 0xF];
    }
}

