/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.xml.core;

import java.io.IOException;
import java.io.Writer;
import uk.org.retep.xml.core.XMLFactoryException;

public class XMLFactory {
    protected int level = 0;
    protected int maxlevel;
    protected String[] names;
    protected boolean hascontent;
    protected boolean[] contbuf;
    private char[] nestbuf;
    protected Writer out;
    protected boolean inTag;
    protected boolean inArg;

    public XMLFactory() {
        this(10);
    }

    public XMLFactory(int n) {
        this.maxlevel = n;
        this.names = new String[this.maxlevel];
        this.contbuf = new boolean[this.maxlevel];
        this.nestbuf = new char[this.maxlevel];
        int n2 = 0;
        while (n2 < this.maxlevel) {
            this.nestbuf[n2] = 32;
            ++n2;
        }
    }

    public XMLFactory(int n, Writer writer) throws IOException {
        this(n);
        this.setWriter(writer);
    }

    public XMLFactory(int n, Writer writer, String string) throws IOException {
        this(n);
        this.setWriter(writer, string);
    }

    public XMLFactory(Writer writer) throws IOException {
        this();
        this.setWriter(writer);
    }

    public XMLFactory(Writer writer, String string) throws IOException {
        this();
        this.setWriter(writer, string);
    }

    public void addAttribute(String string, Object object) throws IOException, XMLFactoryException {
        if (object == null) {
            return;
        }
        if (!this.inArg) {
            throw new XMLFactoryException("Cannot add attribute outside of a tag");
        }
        this.out.write(32);
        this.out.write(string);
        this.out.write("=\"");
        this.out.write(this.encode(object.toString()));
        this.out.write("\"");
    }

    public void addComment(Object object) throws IOException, XMLFactoryException {
        if (this.inTag) {
            throw new XMLFactoryException("Cannot add comments within a tag");
        }
        this.out.write("\n<!-- ");
        this.out.write(object.toString());
        this.out.write(" -->");
    }

    public void addContent(Object object) throws IOException, XMLFactoryException {
        if (object == null) {
            return;
        }
        if (this.inTag) {
            if (this.inArg) {
                this.out.write(62);
                this.inArg = false;
            }
        } else {
            throw new XMLFactoryException("Cannot add content outside of a tag");
        }
        this.out.write(object.toString());
        this.hascontent = true;
    }

    public void close() throws IOException, XMLFactoryException {
        while (this.level > 0) {
            this.endTag();
        }
        this.out.write(10);
        this.out.flush();
    }

    protected String encode(String string) {
        return string;
    }

    public void endTag() throws IOException, XMLFactoryException {
        if (this.level < 1) {
            throw new XMLFactoryException("endTag called above root node");
        }
        --this.level;
        if (this.inArg) {
            this.out.write(" />");
        } else {
            if (!this.hascontent) {
                this.nest(this.level);
            }
            this.out.write("</");
            this.out.write(this.names[this.level]);
            this.out.write(62);
        }
        this.inArg = false;
        this.inTag = this.level > 0;
        this.hascontent = this.contbuf[this.level];
    }

    public Writer getWriter() {
        return this.out;
    }

    protected void nest(int n) throws IOException {
        this.out.write(10);
        while (n > this.nestbuf.length) {
            this.out.write(this.nestbuf, 0, this.nestbuf.length);
            n -= this.nestbuf.length;
        }
        this.out.write(this.nestbuf, 0, n);
    }

    public void setWriter(Writer writer) throws IOException {
        this.setWriter(writer, "ISO-8859-1");
    }

    public void setWriter(Writer writer, String string) throws IOException {
        this.out = writer;
        writer.write("<?xml version=\"1.0\" encoding=\"");
        writer.write(string);
        writer.write("\" ?>\n");
    }

    public void startTag(String string) throws IOException {
        if (this.inTag && this.inArg) {
            this.out.write(">");
        }
        this.nest(this.level);
        this.out.write(60);
        this.out.write(string);
        this.inTag = true;
        this.inArg = true;
        this.names[this.level] = string;
        this.contbuf[this.level] = this.hascontent;
        this.hascontent = false;
        ++this.level;
        if (this.level > this.maxlevel) {
            this.maxlevel += 10;
            String[] stringArray = new String[this.maxlevel];
            System.arraycopy(this.names, 0, stringArray, 0, this.level);
            this.names = stringArray;
            boolean[] blArray = new boolean[this.maxlevel];
            System.arraycopy(this.contbuf, 0, blArray, 0, this.level);
            this.contbuf = blArray;
        }
    }
}

