/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.xml.jdbc;

import java.io.IOException;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Properties;
import uk.org.retep.xml.core.XMLFactory;
import uk.org.retep.xml.core.XMLFactoryException;

public class XMLResultSet {
    protected ResultSet rs;
    protected XMLFactory factory = new XMLFactory();
    protected static Properties defaults;
    public static String RESULTSET_NAME;
    public static String DEFAULT_RESULTSET_NAME;
    public static String ROW_NAME;
    public static String DEFAULT_ROW_NAME;
    public static String COLNAME;
    public static String CONTENT;
    public static String ATTRIBUTE;
    public static String DEFAULT_ATTRIBUTE;
    public static String ROW_ATTRIBUTE;
    public static String FIRST_ROW;
    public static String LAST_ROW;

    static {
        RESULTSET_NAME = "resultset.name";
        DEFAULT_RESULTSET_NAME = "RESULTSET";
        ROW_NAME = "row.name";
        DEFAULT_ROW_NAME = "RECORD";
        COLNAME = ".name";
        CONTENT = "content";
        ATTRIBUTE = "attribute";
        DEFAULT_ATTRIBUTE = "VALUE";
        ROW_ATTRIBUTE = "row";
        FIRST_ROW = "row.first";
        LAST_ROW = "row.last";
    }

    public XMLResultSet() {
    }

    public XMLResultSet(ResultSet resultSet) {
        this();
        this.setResultSet(resultSet);
    }

    public void buildDTD(ResultSet resultSet) throws IOException, SQLException {
        this.buildDTD(resultSet, null, this.getWriter());
    }

    public void buildDTD(ResultSet resultSet, Writer writer) throws IOException, SQLException {
        this.buildDTD(resultSet, null, writer);
    }

    public void buildDTD(ResultSet resultSet, Properties properties) throws IOException, SQLException {
        this.buildDTD(resultSet, properties, this.getWriter());
    }

    public void buildDTD(ResultSet resultSet, Properties properties, Writer writer) throws IOException, SQLException {
        int n;
        int[] nArray;
        String[] stringArray;
        String[] stringArray2;
        if (properties == null) {
            properties = XMLResultSet.getDefaultProperties();
        }
        String string = properties.getProperty(RESULTSET_NAME, DEFAULT_RESULTSET_NAME);
        String string2 = properties.getProperty(ROW_NAME, DEFAULT_ROW_NAME);
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n2 = resultSetMetaData.getColumnCount();
        int[] nArray2 = this.getRowAttributes(n2, stringArray2 = new String[n2], stringArray = new String[n2], nArray = new int[n2], resultSetMetaData, properties);
        int n3 = nArray2 == null ? 0 : nArray2.length;
        boolean bl = n3 > 0;
        writer.write("<!ELEMENT ");
        writer.write(string);
        writer.write(" (");
        writer.write(string2);
        writer.write("*)>\n");
        writer.write("<!ELEMENT ");
        writer.write(string2);
        writer.write(" (");
        boolean bl2 = false;
        int n4 = 0;
        while (n4 < n2) {
            if (nArray[n4] != 2) {
                if (bl2) {
                    writer.write(",");
                }
                writer.write(stringArray2[n4]);
                bl2 = true;
            }
            ++n4;
        }
        writer.write(")>\n");
        if (bl) {
            writer.write("<!ATTLIST ");
            writer.write(string2);
            n = 0;
            while (n < n3) {
                writer.write("\n ");
                writer.write(stringArray2[nArray2[n]]);
                writer.write(" CDATA #IMPLIED");
                ++n;
            }
            writer.write("\n>\n");
        }
        n = 0;
        while (n < n2) {
            if (nArray[n] != 2) {
                writer.write("<!ELEMENT ");
                writer.write(stringArray2[n]);
                if (nArray[n] == 0) {
                    writer.write(" (#PCDATA)");
                } else {
                    writer.write(" EMPTY");
                }
                writer.write(">\n");
                if (nArray[n] == 1) {
                    writer.write("<!ATTLIST ");
                    writer.write(stringArray2[n]);
                    writer.write("\n ");
                    writer.write(stringArray[n]);
                    writer.write(" CDATA #IMPLIED\n>\n");
                }
            }
            ++n;
        }
    }

    public void close() throws IOException, XMLFactoryException {
        this.factory.close();
    }

    public static Properties getDefaultProperties() {
        if (defaults == null) {
            defaults = new Properties();
            defaults.setProperty(RESULTSET_NAME, DEFAULT_RESULTSET_NAME);
            defaults.setProperty(ROW_NAME, DEFAULT_ROW_NAME);
        }
        return defaults;
    }

    public ResultSet getResultSet() {
        return this.rs;
    }

    private int[] getRowAttributes(int n, String[] stringArray, String[] stringArray2, int[] nArray, ResultSetMetaData resultSetMetaData, Properties properties) throws SQLException {
        int[] nArray2 = null;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            stringArray[n3] = resultSetMetaData.getColumnName(n3 + 1);
            stringArray2[n3] = properties.getProperty(String.valueOf(stringArray[n3]) + COLNAME, DEFAULT_ATTRIBUTE);
            if (properties.getProperty(stringArray[n3], CONTENT).equals(ROW_ATTRIBUTE)) {
                nArray[n3] = 2;
                if (nArray2 == null) {
                    nArray2 = new int[n];
                }
                nArray2[n2++] = n3;
            } else {
                nArray[n3] = properties.getProperty(stringArray[n3], CONTENT).equals(ATTRIBUTE) ? 1 : 0;
            }
            ++n3;
        }
        if (n2 > 0) {
            int[] nArray3 = new int[n2];
            System.arraycopy(nArray2, 0, nArray3, 0, n2);
            return nArray3;
        }
        return null;
    }

    public Writer getWriter() {
        return this.factory.getWriter();
    }

    public XMLFactory getXMLFactory() {
        return this.factory;
    }

    public void setResultSet(ResultSet resultSet) {
        this.rs = resultSet;
    }

    public void setWriter(Writer writer) throws IOException {
        this.factory.setWriter(writer);
    }

    public void translate(ResultSet resultSet) throws XMLFactoryException, IOException, SQLException {
        this.translate(resultSet, (Properties)null);
    }

    public void translate(ResultSet resultSet, Writer writer) throws XMLFactoryException, IOException, SQLException {
        this.factory.setWriter(writer);
        this.translate(resultSet, (Properties)null);
    }

    public void translate(ResultSet resultSet, Properties properties) throws XMLFactoryException, IOException, SQLException {
        int[] nArray;
        String[] stringArray;
        String[] stringArray2;
        if (properties == null) {
            properties = XMLResultSet.getDefaultProperties();
        }
        String string = properties.getProperty(RESULTSET_NAME, DEFAULT_RESULTSET_NAME);
        String string2 = properties.getProperty(ROW_NAME, DEFAULT_ROW_NAME);
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        int[] nArray2 = this.getRowAttributes(n, stringArray2 = new String[n], stringArray = new String[n], nArray = new int[n], resultSetMetaData, properties);
        int n2 = nArray2 == null ? 0 : nArray2.length;
        boolean bl = n2 > 0;
        int n3 = Integer.parseInt(properties.getProperty(FIRST_ROW, "0"));
        int n4 = Integer.parseInt(properties.getProperty(LAST_ROW, "0"));
        int n5 = 0;
        this.factory.startTag(string);
        while (resultSet.next()) {
            if (n3 <= n5 && (n4 == 0 || n5 < n4)) {
                int n6;
                this.factory.startTag(string2);
                if (bl) {
                    n6 = 0;
                    while (n6 < n2) {
                        this.factory.addAttribute(stringArray2[n6], resultSet.getString(n6 + 1));
                        ++n6;
                    }
                }
                if (n2 < n) {
                    n6 = 1;
                    while (n6 <= n) {
                        switch (nArray[n6 - 1]) {
                            case 1: {
                                this.factory.startTag(stringArray2[n6 - 1]);
                                this.factory.addAttribute(stringArray[n6 - 1], resultSet.getString(n6));
                                this.factory.endTag();
                                break;
                            }
                            case 0: {
                                this.factory.startTag(stringArray2[n6 - 1]);
                                this.factory.addContent(resultSet.getString(n6));
                                this.factory.endTag();
                                break;
                            }
                        }
                        ++n6;
                    }
                }
                this.factory.endTag();
            }
            ++n5;
        }
        this.factory.endTag();
    }

    public void translate(ResultSet resultSet, Properties properties, Writer writer) throws XMLFactoryException, IOException, SQLException {
        this.factory.setWriter(writer);
        this.translate(resultSet, properties);
    }
}

