/*
 *                 Sun Public License Notice
 * 
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 * 
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2000 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.mymodules.notifyui;

import java.awt.Dialog;
import org.openide.TopManager;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;


/** Simple action. Opens up a new window and displays a message. */
public class NotifyAction extends CallableSystemAction {
    // generated
    private static final long serialVersionUID = 6101321673293585672L;
        
    public String getName () {
        return NbBundle.getBundle (NotifyAction.class).getString ("LBL_NotifyAction");
    }
    public HelpCtx getHelpCtx () {
        // In a real situation could map to installed JavaHelp...
        return HelpCtx.DEFAULT_HELP;
    }
    protected String iconResource(){
        return "NotifyIcon.gif";
    }
    public void performAction () {       
 //           Popping up a Message Window     
     TopManager.getDefault ().notify
    (new NotifyDescriptor.Message
    (NbBundle.getBundle (NotifyAction.class).getString ("MSG_perform"))); // ......yes, this works!         

    }

}
