/*
 *                 Sun Public License Notice
 * 
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 * 
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2000 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.mymodules.dialogui;

import java.awt.Dialog;
import org.openide.TopManager;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;


/** Simple action. Opens up a new window and displays a message. */
public class DialogAction extends CallableSystemAction {
    // generated
    private static final long serialVersionUID = 6101321673293585672L;
        
    public String getName () {
        return NbBundle.getBundle (DialogAction.class).getString ("LBL_DialogAction");
    }
    public HelpCtx getHelpCtx () {
        // In a real situation could map to installed JavaHelp...
        return HelpCtx.DEFAULT_HELP;
    }
    protected String iconResource(){
        return "DialogIcon.gif";
    }
    public void performAction () {          

    DialogPanel dp = new DialogPanel(); // create new DialogPanel 
    DialogDescriptor dd = new DialogDescriptor (dp, "Text in title"); //create new DialogDescriptor 
    dp.requestFocus(); // set focus to component which was specified in MyPanel's requestFocus() method 
    TopManager.getDefault ().createDialog (dd).show (); //show dialog 

    //what to do when dialog was closed 
    if (dd.getValue () == DialogDescriptor.OK_OPTION) { 
    //ok button was pressed 
        TopManager.getDefault ().notify (new NotifyDescriptor.Message("You entered "+ 
        dp.getTextField().getText()));
    } 
     else{ 
     //cancel button was pressed 
          TopManager.getDefault ().notify (new NotifyDescriptor.Message("No Name Was Entered! "));
    }                                    
    }
}
