/*
 * Copyright (c) 2002 Sosnoski Software Solutions, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

import org.xml.sax.*;
import org.xml.sax.helpers.*;

/**
 * SAX2 handler for parsing trade history information stream.
 *
 * @author Dennis M. Sosnoski
 * @version 1.0
 */

public class TradeStreamHandler extends DefaultHandler
{
	/** Handler for stock trade elements. */
	protected StockTradeHandler m_stockHandler = new StockTradeHandler();
	
	/** Handler for option trade elements */
	protected OptionTradeHandler m_optionHandler = new OptionTradeHandler();
	
	/** Currently active end element handler. */
	protected EndElementHandler m_endHandler;
	
	/** Character data collection buffer. */
	protected StringBuffer m_contentBuffer = new StringBuffer();
	
	public void startElement(String uri, String lname, String qname,
		Attributes attributes) {
		m_contentBuffer.setLength(0);
		if (lname.equals(m_stockHandler.TRADE_ELEMENT_NAME)) {
			m_endHandler = m_stockHandler;
		} else if (lname.equals(m_optionHandler.TRADE_ELEMENT_NAME)) {
			m_endHandler = m_optionHandler;
		}
	}
	
	public void characters(char[] chars, int start, int length) {
		m_contentBuffer.append(chars, start, length);
	}
	
	public void endElement(String uri, String lname, String qname) {
		String content = m_contentBuffer.toString().trim();
		m_endHandler.endElement(lname, content);
	}
}

