import javax.swing.*;
import java.awt.*;
import javax.swing.border.*;

public class TryBoxLayout
{
    // The window object
    static JFrame aWindow = new JFrame("ԥ8");
    
    public static void main(String[] args)
    {
        Toolkit theKit = aWindow.getToolkit();
        Dimension wndSize = theKit.getScreenSize();
        
        aWindow.setBounds(wndSize.width/4, wndSize.height/4, wndSize.width/2, wndSize.height/2);
        aWindow.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);

        Box left = Box.createVerticalBox();
        left.add(Box.createVerticalStrut(30));
        ButtonGroup radioGroup = new ButtonGroup();
        JRadioButton rbutton;
        radioGroup.add(rbutton = new JRadioButton(""));
        left.add(rbutton);
        left.add(Box.createVerticalStrut(30));
        radioGroup.add(rbutton = new JRadioButton(""));
        left.add(rbutton);
        left.add(Box.createVerticalStrut(30));
        radioGroup.add(rbutton = new JRadioButton(""));
        left.add(rbutton);
        left.add(Box.createVerticalStrut(30));
        radioGroup.add(rbutton = new JRadioButton(""));
        left.add(rbutton);
        left.add(Box.createGlue());
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.setBorder(new TitledBorder(new EtchedBorder(), "Line Color"));
        leftPanel.add(left, BorderLayout.CENTER);
        
        Box right = Box.createVerticalBox();
        right.add(Box.createVerticalStrut(30));
        right.add(new JCheckBox("Dashed"));
        right.add(Box.createVerticalStrut(30));
        right.add(new JCheckBox("Thick"));
        right.add(Box.createVerticalStrut(30));
        right.add(new JCheckBox("Rounded"));
        right.add(Box.createVerticalStrut(30));
        right.add(Box.createGlue());
        JPanel rightPanel = new JPanel(new BorderLayout());
        rightPanel.setBorder(new TitledBorder(new EtchedBorder(), "Line Properties"));
        rightPanel.add(right, BorderLayout.CENTER);
        
        Box top = Box.createHorizontalBox();
        top.add(leftPanel);
        top.add(Box.createHorizontalStrut(5));
        top.add(rightPanel);
        
        JPanel bottomPanel = new JPanel();
        bottomPanel.setBorder(new CompoundBorder(BorderFactory.createLineBorder(Color.red, 1), BorderFactory.createBevelBorder(BevelBorder.RAISED, Color.green, Color.blue, Color.magenta, Color.cyan)));
        Border edge = BorderFactory.createRaisedBevelBorder();
        JButton button;
        Dimension size = new Dimension(80, 20);
        bottomPanel.add(button = new JButton("Defaults"));
        button.setBorder(edge);
        button.setPreferredSize(size);
        bottomPanel.add(button = new JButton("OK"));
        button.setBorder(edge);
        button.setPreferredSize(size);
        bottomPanel.add(button = new JButton("Cancel"));
        button.setBorder(edge);
        button.setPreferredSize(size);
        
        Container content = aWindow.getContentPane();
        content.setLayout(new BorderLayout());
        content.add(top, BorderLayout.CENTER);
        content.add(bottomPanel, BorderLayout.SOUTH);
        
        aWindow.setVisible(true);
    } // public static void main(String[] args)
} // public class TryFlowLayout
