import javax.swing.*;
import java.awt.*;
import javax.swing.border.*;

public class TryGridBagLayout
{
    // The window object
    static JFrame aWindow = new JFrame("ԥ8");
    
    public static void main(String[] args)
    {
        Toolkit theKit = aWindow.getToolkit();
        Dimension wndSize = theKit.getScreenSize();
        
        aWindow.setBounds(wndSize.width/4, wndSize.height/4, wndSize.width/2, wndSize.height/2);
        aWindow.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
        
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        aWindow.getContentPane().setLayout(gridbag);
        
        constraints.weightx = constraints.weighty = 10.0;
        constraints.fill = constraints.NONE;
        constraints.ipadx = 30;
        constraints.ipady = 10;
        addButton("", constraints, gridbag);
        
        constraints.weightx = 5.0;
        constraints.fill = constraints.BOTH;
        constraints.ipadx = constraints.ipady = 0;
        constraints.gridwidth = constraints.REMAINDER;
        constraints.gridheight = 2;
        constraints.insets = new Insets(10, 30, 10, 20);
        addButton("GO!!!!!!!!!!!", constraints, gridbag);
        
        constraints.gridx = 0;
        constraints.fill = constraints.NONE;
        constraints.ipadx = 30;
        constraints.ipady = 10;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(0, 0, 0, 0);
        addButton("Push", constraints, gridbag);
        
        aWindow.setVisible(true);
    } // public static void main(String[] args)
    
    static void addButton(String label, GridBagConstraints constraints, GridBagLayout layout)
    {
        Border edge = BorderFactory.createRaisedBevelBorder();
        
        JButton button = new JButton(label);
        button.setBorder(edge);
        layout.setConstraints(button, constraints);
        aWindow.getContentPane().add(button);
    } // static void addButton(String label, GridBagConstraints constraints, GridBagLayout layout)
    
} // public class TryFlowLayout

