package jp.turbosql.examples.modules.minicomposer;

import java.io.*;
import org.openide.loaders.*;
import org.openide.filesystems.*;
import org.openide.util.*;
import org.openide.util.actions.*;
import org.openide.actions.*;

public class ScoreDataLoader extends UniFileLoader
{
    public static final String SCORE_MIME = "text/x-minicomposer-score";
    
    private static final long serialVersionUID = 642449189229774122L;
    
    public ScoreDataLoader()
    {
        super("jp.turbosql.examples.modules.minicomposer.ScoreDataObject");
    } // public ScoreDataLoader()
    
    protected void initialize()
    {
        super.initialize();
        getExtensions().addMimeType(SCORE_MIME);
    } // protected void initialize()
    
    protected String defaultDisplayName()
    {
        return NbBundle.getMessage(ScoreDataLoader.class, "LBL_loaderName");
    } // protected String defaultDisplayName()
    
    protected SystemAction[] defaultActions()
    {
        return new SystemAction[] {
            SystemAction.get(EditAction.class),
            SystemAction.get(FileSystemAction.class),
            null,
            SystemAction.get(ExecuteAction.class),
            null,
            SystemAction.get(CutAction.class),
            SystemAction.get(CopyAction.class),
            null,
            SystemAction.get(DeleteAction.class),
            SystemAction.get(RenameAction.class),
            null,
            SystemAction.get(SaveAsTemplateAction.class),
            null,
            SystemAction.get(ToolsAction.class),
            SystemAction.get(PropertiesAction.class)
        };     
    }
        
    protected MultiDataObject createMultiObject(FileObject primaryFile) throws DataObjectExistsException, IOException
    {
        return new ScoreDataObject(primaryFile, this);
    } // protected MultiDataObject createMultiObject(FileObject primaryFile) throws DataObjectExistsException, IOException
    
 // protected SystemAction[] defaultActions()
    
} // public class ScoreDataLoader extends UniFileLoader

