package jp.turbosql.examples.modules.minicomposer;

import java.io.*;
import org.openide.cookies.*;
import org.openide.*;
import org.openide.loaders.*;
import javax.sound.sampled.*;

public class ScoreExec implements ExecCookie
{
    private final DataObject obj;
    public ScoreExec(DataObject obj)
    {
        this.obj = obj;
    } // public ScoreExec(DataObject obj)
    public void start()
    {
        try {
            Score score;
            InputStream is = obj.getPrimaryFile().getInputStream();
            try
            {
                score = Score.parse(new InputStreamReader(is));
            } // try
            finally
            {
                is.close();
            } // finally
            LineInFromScore line = new LineInFromScore(score);
            AudioInputStream ais = new LineInFromScore.ScoreAudioInputStream(line, 24000.0f);
            AudioFormat format = ais.getFormat();
            DataLine.Info dlinfo = new DataLine.Info(Clip.class, ais.getFormat());
            Clip clip = (Clip) AudioSystem.getLine(dlinfo);
            clip.open(ais);
            clip.start();
            while (clip.isActive())
            {
                Thread.sleep(1000);
            } // while (clip.isActive())
            clip.stop();
            clip.close();
        } // try
        catch (Exception e)
        {
            TopManager.getDefault().getErrorManager().notify(e);
        } // catch (Exception e)
    } // public void start()
} // public class ScoreExec implements ExecCookie