/*
 * GazoogleDataObjectLoader.java
 *
 * Created on 12 July 2001 1656 MDT
 */

package com.example.nb.tutorial.chapter_4;

import java.io.IOException;

import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.UniFileLoader;

/**
 *
 * @author  adams
 * @version 1.0
 */
public class GazoogleDataObjectLoader extends UniFileLoader
{

    /** Creates new GazoogleDataObjectLoader */
    public GazoogleDataObjectLoader() 
    {
        super(GazoogleDataObject.class);
    }

    protected MultiDataObject createMultiObject(FileObject fileObject) 
      throws DataObjectExistsException, IOException 
    {
        return new GazoogleDataObject(fileObject, this);
    }
    
    /**
     * We have a qualifying FileObject if the object
     * is a file with extension ".gazoogle".
     */
    protected FileObject findPrimaryFile(FileObject fo)
    {
        FileObject primaryFile = null;
        if (fo.isData() && fo.getExt().equals("gazoogle"))
        {
            primaryFile = fo;
        }
        return primaryFile;
    }
}

