package com.example.nb.tutorial.chapter_5;

import java.sql.*;
import java.util.Vector;
import java.util.StringTokenizer;
import java.math.BigDecimal;

public class PostgreSQLDataObject implements DatabaseDataObjectInterface
{
    //SQL constants
    private static final String QUOTE = "\"";
    private static final String SQL_GET_DATABASES = "SELECT oid, *, pg_encoding_to_char(encoding) AS serverencoding, pg_get_userbyid(datdba) AS datowner FROM pg_database";
    private static final String SQL_GET_LANGUAGES = "SELECT now() AS ts, oid, * FROM pg_language";
    private static final String SQL_GET_USERS = "SELECT * FROM pg_user";
    private static final String SQL_GET_GROUPS = "SELECT * FROM pg_group";
    private static final String SQL_GET_SEQUENCES = "SELECT now() AS ts, oid, relname, pg_get_userbyid(relowner) AS seqowner, relacl FROM pg_class WHERE relkind = 'S'";
    private static final String SQL_GET_VIEWS = "SELECT now() AS ts, c.oid, c.relname, pg_get_userbyid(c.relowner) AS viewowner, c.relacl, pg_get_viewdef(c.relname) AS definition FROM pg_class c WHERE ((c.relhasrules AND (EXISTS (SELECT r.rulename FROM pg_rewrite r WHERE ((r.ev_class = c.oid) AND (bpchar(r.ev_type) = '1'::bpchar))))) OR (c.relkind = 'v'::" + QUOTE + "char" + QUOTE + "))";
    private static final String SQL_GET_TYPES7_1 = "SELECT now() AS ts, oid, *, pg_get_userbyid(typowner) as typeowner FROM pg_type WHERE typrelid = 0";
    private static final String SQL_GET_TYPES7_3 = "SELECT now() AS ts, oid, *, pg_get_userbyid(typowner) as typeowner FROM pg_type WHERE typtype = 'b'";
    private static final String SQL_GET_DOMAINS = "SELECT now() AS ts, oid, *, pg_get_userbyid(typowner) as domainowner FROM pg_type WHERE typtype = 'd'";
    private static final String SQL_GET_FUNCTIONS = "SELECT now() AS ts, oid, *, pg_get_userbyid(proowner) as funcowner FROM pg_proc";
    private static final String SQL_GET_OPERATORS = "SELECT now() AS ts, oid, *, pg_get_userbyid(oprowner) as opowner FROM pg_operator";
    private static final String SQL_GET_RULES = "SELECT now() AS ts, oid, rulename, pg_get_ruledef(rulename) as definition FROM pg_rewrite";
    private static final String SQL_GET_TRIGGERS = "SELECT now() AS ts, t.oid, tgname, proname, tgargs, tgtype FROM pg_trigger t, pg_proc p WHERE t.tgfoid = p.oid AND tgisconstraint = FALSE";
    private static final String SQL_GET_TABLES7_1 = "SELECT now() AS ts, oid, relname, pg_get_userbyid(relowner) as tableowner, relacl FROM pg_class WHERE ((relkind = 'r') OR (relkind = 's'))";
    private static final String SQL_GET_TABLES7_2 = "SELECT now() AS ts, oid, relname, pg_get_userbyid(relowner) as tableowner, relacl, relhasoids FROM pg_class WHERE ((relkind = 'r') OR (relkind = 's'))";
    private static final String SQL_GET_COLUMNS7_1 = "SELECT a.oid, a.attname, a.attnum, t.typname, CASE WHEN ((a.attlen = -1) AND ((a.atttypmod)::int4 = (-1)::int4)) THEN (0)::int4 ELSE CASE WHEN a.attlen = -1 THEN CASE WHEN ((t.typname = 'bpchar') OR (t.typname = 'char') OR (t.typname = 'varchar')) THEN (a.atttypmod -4)::int4 ELSE (a.atttypmod)::int4 END ELSE (a.attlen)::int4 END END AS length, a.attnotnull, (SELECT adsrc FROM pg_attrdef d WHERE d.adrelid = a.attrelid AND d.adnum = a.attnum) AS default, (SELECT indisprimary FROM pg_index i, pg_class ic, pg_attribute ia  WHERE i.indrelid = a.attrelid AND i.indexrelid = ic.oid AND ic.oid = ia.attrelid AND ia.attname = a.attname LIMIT 1) AS primarykey FROM pg_attribute a, pg_type t WHERE a.atttypid = t.oid";
    private static final String SQL_GET_COLUMNS7_2 = "SELECT 0::oid AS oid, a.attname, a.attnum, t.typname, CASE WHEN ((a.attlen = -1) AND ((a.atttypmod)::int4 = (-1)::int4)) THEN (0)::int4 ELSE CASE WHEN a.attlen = -1 THEN CASE WHEN ((t.typname = 'bpchar') OR (t.typname = 'char') OR (t.typname = 'varchar')) THEN (a.atttypmod -4)::int4 ELSE (a.atttypmod)::int4 END ELSE (a.attlen)::int4 END END AS length, a.attnotnull, (SELECT adsrc FROM pg_attrdef d WHERE d.adrelid = a.attrelid AND d.adnum = a.attnum) AS default, (SELECT indisprimary FROM pg_index i, pg_class ic, pg_attribute ia  WHERE i.indrelid = a.attrelid AND i.indexrelid = ic.oid AND ic.oid = ia.attrelid AND ia.attname = a.attname LIMIT 1) AS primarykey FROM pg_attribute a, pg_type t WHERE a.atttypid = t.oid";
    private static final String SQL_GET_INDEXES = "SELECT now() AS ts, i.oid, i.relname, x.indisunique, x.indisprimary, pg_get_indexdef(i.oid) AS definition FROM pg_index x, pg_class i WHERE i.oid = x.indexrelid";
    private static final String SQL_GET_INDEX_COLUMNS = "SELECT attname FROM pg_attribute";
    private static final String SQL_GET_CHECKS = "SELECT rcname, rcsrc FROM pg_relcheck WHERE NOT EXISTS (SELECT * FROM pg_relcheck AS c, pg_inherits AS i WHERE i.inhrelid = pg_relcheck.rcrelid AND (c.rcname = pg_relcheck.rcname OR (c.rcname[0] = '$' AND pg_relcheck.rcname[0] = '$')) AND c.rcsrc = pg_relcheck.rcsrc AND  c.rcrelid = i.inhparent)";
    private static final String SQL_GET_INHERITED_TABLES = "SELECT c.relname FROM pg_class c, pg_inherits i WHERE c.oid = i.inhparent";
    private static final String SQL_GET_AGGREGATES = "SELECT now() AS ts, oid, aggname, pg_get_userbyid(aggowner) AS owner, aggtransfn, aggfinalfn, aggbasetype, aggtranstype, aggfinaltype, agginitval FROM pg_aggregate";
    private static final String SQL_GET_FOREIGN_KEYS = "SELECT oid, tgrelid, tgconstrname, tgnargs, tgargs, tgdeferrable, tginitdeferred FROM pg_trigger WHERE tgisconstraint = TRUE AND tgtype = 21";

    //SQL related to Revision Control.
    //Note that the object OID is also logged to help create objects in dependency order when building scripts.
    private static final String SQL_CREATE_REVLOG = "CREATE TABLE pgadmin_rclog(rc_timestamp timestamp DEFAULT now(), rc_user name DEFAULT current_user, rc_action varchar(1), rc_type varchar(32), rc_identifier varchar(256), rc_oid oid, rc_table varchar(64), rc_version int4, rc_definition text, rc_comment text); GRANT SELECT, INSERT ON pgadmin_rclog TO PUBLIC; COMMENT ON TABLE pgadmin_rclog IS 'pgAdmin II Revision Log'; CREATE INDEX pgadmin_rclog_idx ON pgadmin_rclog (rc_action, rc_type, rc_identifier, rc_table, rc_oid, rc_version);";
    private static final String SQL_DROP_REVLOG = "DROP TABLE pgadmin_rclog;";
    private static final String SQL_GRAVEYARD = "SELECT DISTINCT ON (rc_type, rc_identifier) * FROM pgadmin_rclog ORDER BY rc_type, rc_identifier, rc_version DESC";
    
    /*
    public ResultSet executeQuery()
    {
        ;
    }
     */
    
    public static Vector processToDataRows(ResultSet results)
    {
        
            // Get all rows.
            Vector dataRows = new Vector();                                // New Vector to store the data
            //String[] rowData;                                       // Stores one row
            try
            { 
                ResultSetMetaData metadata = results.getMetaData();
                int columns = metadata.getColumnCount();         // Get number of columns
                int[] columnTypes = new int[columns];
                String[] columnTypeNames = new String[columns];
            
                for(int i = 0; i < columns; i++)
                {
                    //columnNames[i] = metadata.getColumnLabel(i + 1);
                    columnTypes[i] = metadata.getColumnType(i + 1);
                    columnTypeNames[i] = metadata.getColumnTypeName(i + 1);
                    System.out.println("column " + (i+1) +": " + metadata.getColumnTypeName(i+1));
                } // for(int i = 0; i < columns; i++)
            
                Object[] rowData;
                while(results.next())                                   // For each row...
                {
                    //rowData = new String[columns];                      // create array to hold the data
                    rowData = new Object[columns];
                    for(int i = 0; i < columns; i++)                    // For each column
                    {
                    //rowData[i] = results.getString(i+1);            // retrive the data item
                    //rowData[i] = results.getObject(i+1);
                        switch(columnTypes[i])
                        {
                            case Types.BIT:
                                System.out.println("column " + (i+1) +" Datatype is BIT" );
                                rowData[i] = new Boolean(results.getBoolean(i+1));
                                break;
                            case Types.TINYINT:
                                System.out.println("column " + (i+1) +" Datatype is TINYINT" );
                                rowData[i] = new Byte(results.getByte(i+1));
                                break;  
                            case Types.SMALLINT:
                                System.out.println("column " + (i+1) +" Datatype is SMALLINT" );
                                rowData[i] = new Short(results.getShort(i+1));
                                break;
                            case Types.INTEGER:
                                System.out.println("column " + (i+1) +" Datatype is INTEGER" );
                                rowData[i] = new Integer(results.getInt(i+1));
                                break;
                            case Types.BIGINT:
                                System.out.println("column " + (i+1) +" Datatype is BIGINT" );
                                rowData[i] = new Long(results.getLong(i+1));
                                break;
                            case Types.FLOAT:
                                System.out.println("column " + (i+1) +" Datatype is FLOAT" );
                                rowData[i] = new Float(results.getFloat(i+1));
                                break;
                            case Types.DOUBLE:
                                System.out.println("column " + (i+1) +" Datatype is DOUBLE" );
                                rowData[i] = new Double(results.getDouble(i+1));
                                break;
                            case Types.DECIMAL:
                                System.out.println("column " + (i+1) +" Datatype is DECIMAL" );
                                rowData[i] = results.getBigDecimal(i+1);
                                //rowData[i] = new Float(results.getFloat(i+1));
                                rowData[i] = new Double(results.getDouble(i+1));
                                break;
                            case Types.NUMERIC:
                                System.out.println("column " + (i+1) +" Datatype is NUMERIC" );
                                rowData[i] = results.getBigDecimal(i+1);
                                //rowData[i] = new Float(results.getFloat(i+1));
                                //rowData[i] = new Double(results.getDouble(i+1));
                                break;
                            case Types.CHAR:
                                System.out.println("column " + (i+1) +" Datatype is CHAR" );
                                rowData[i] = results.getString(i+1);
                                break;
                            case Types.VARCHAR:
                                System.out.println("column " + (i+1) +" Datatype is VARCHAR" );
                                rowData[i] = results.getString(i+1);
                                break;
                            case Types.DATE:
                                System.out.println("column " + (i+1) +" Datatype is DATE" );
                                //rowData[i] = results.getDate(i+1);
                                // String representation makes it modifyable.
                                Date temp_date;
                                temp_date = results.getDate(i+1);
                                if(temp_date != null)
                                    rowData[i] = temp_date.toString();
                                else
                                    rowData[i] = null;
                                //rowData[i] = results.getDate(i+1).toString();
                                //rowData[i] = results.getString(i+1);
                                break;
                            case Types.TIME:
                                System.out.println("column " + (i+1) +" Datatype is TIME" );
                                //rowData[i] = results.getString(i+1);
                                Time temp_time;
                                temp_time = results.getTime(i+1);
                                if(temp_time != null)
                                    rowData[i] = temp_time.toString();
                                else
                                    rowData[i] = null;
                                //rowData[i] = results.getTime(i+1).toString();
                                //rowData[i] = results.getString(i+1);
                                break;
                            case Types.TIMESTAMP:
                                System.out.println("column " + (i+1) +" Datatype is TIMESTAMP" );
                                //rowData[i] = results.getString(i+1);
                                Timestamp temp_timestamp;
                                temp_timestamp = results.getTimestamp(i+1);
                                if(temp_timestamp != null)
                                    rowData[i] = temp_timestamp.toString();
                                else
                                    rowData[i] = null;
                                //rowData[i] = results.getTimestamp(i+1).toString();
                                //rowData[i] = results.getString(i+1);
                                break;
                            case Types.JAVA_OBJECT:
                                System.out.println("column " + (i+1) +" Datatype is JAVA_OBJECT" );
                                rowData[i] = results.getObject(i+1);
                                break;
                            default:
                                if(columnTypeNames[i].equals("text"))
                                {
                                    System.out.println("column " + (i+1) +" Datatype is text" );
                                    rowData[i] = results.getString(i+1);
                                } // if(columnTypeNames[i].equals("text"))
                                else
                                {
                                    System.out.println("column " + (i+1) +" Datatype is unknown" );
                                    rowData[i] = results.getString(i+1);
                                } // else
                                break;
                        } // switch(args.length)
                        
                        if(results.wasNull())                                   // This should take care of all nulls in the columns.
                            rowData[i] = null;
                                    //rowData[i] = results.getObject(i+1);
                                    //rowData[i] = results.getString(i+1);
                        /*
                                if(columnTypeNames[i].equals("oid"))
                                {
                                    //System.out.println("column " + (i+1) +" Datatype is text" );
                                    rowData[i] = new Integer(results.getInt(i+1));                                  
                                } // if(columnTypeNames[i].equals("text"))
                                else
                                {
                                    System.out.println("column " + (i+1) +" Datatype is unknown" );
                                    rowData[i] = results.getObject(i+1);
                                } // else
                         */
                    } // for(int i = 0; i < columns; i++)
                    dataRows.addElement(rowData);                       // Store the row in the vector
                } // while(results.next())
            } // try
            catch (SQLException sqle)
            {
                System.err.println(sqle);
            } // catch (SQLException sqle)
            return dataRows;
    } // public void setDataRows(Vector param_dataRows)
    
    public static Object[] processToColumnTypeArray(int[] columnTypes, String[] columnTypeNames)
    {
        int columnCount = columnTypes.length;
        Object[] columnTypeArray = new Object[columnCount];
        //int[] columnTypes = param_ColumnTypes;
        //String[] columnTypeNames = param_ColumnTypeNames;
        
        for(int i = 0; i < columnCount; i++)                    // For each column
        {
            //rowData[i] = results.getString(i+1);            // retrive the data item
            //rowData[i] = results.getObject(i+1);
            switch(columnTypes[i])
            {
                case Types.BIT:
                    //System.out.println("column " + (i+1) +" Datatype is BIT" );
                    columnTypeArray[i] = new Boolean(false);
                    break;
                case Types.TINYINT:
                    //System.out.println("column " + (i+1) +" Datatype is TINYINT" );
                    columnTypeArray[i] = new Byte(Byte.MIN_VALUE);
                    break;  
                case Types.SMALLINT:
                    //System.out.println("column " + (i+1) +" Datatype is SMALLINT" );
                    columnTypeArray[i] = new Short(Short.MIN_VALUE);
                    break;
                case Types.INTEGER:
                    //System.out.println("column " + (i+1) +" Datatype is INTEGER" );
                    columnTypeArray[i] = new Integer(0);
                    break;
                case Types.BIGINT:
                    //System.out.println("column " + (i+1) +" Datatype is BIGINT" );
                    columnTypeArray[i] = new Long(0);
                    break;
                case Types.FLOAT:
                    //System.out.println("column " + (i+1) +" Datatype is FLOAT" );
                    columnTypeArray[i] = new Float(0);
                    break;
                case Types.DOUBLE:
                    //System.out.println("column " + (i+1) +" Datatype is DOUBLE" );
                    columnTypeArray[i] = new Double(0);
                    break;
                case Types.DECIMAL:
                    //System.out.println("column " + (i+1) +" Datatype is DECIMAL" );
                    columnTypeArray[i] = new BigDecimal(0);
                    break;
                case Types.NUMERIC:
                    //System.out.println("column " + (i+1) +" Datatype is NUMERIC" );
                    columnTypeArray[i] = new BigDecimal(0);
                    break;
                case Types.CHAR:
                    //System.out.println("column " + (i+1) +" Datatype is CHAR" );
                    columnTypeArray[i] = new String("");
                    break;
                case Types.VARCHAR:
                    //System.out.println("column " + (i+1) +" Datatype is VARCHAR" );
                    columnTypeArray[i] = "";
                    break;
                case Types.DATE:
                    //System.out.println("column " + (i+1) +" Datatype is DATE" );
                    //rowData[i] = results.getDate(i+1);
                    // String representation makes it modifyable.
                    //rowData[i] = results.getDate(i+1).toString();
                    columnTypeArray[i] =  new String("");
                    break;
                case Types.TIME:
                    //System.out.println("column " + (i+1) +" Datatype is TIME" );
                    //rowData[i] = results.getString(i+1);
                    //rowData[i] = results.getTime(i+1).toString();
                    columnTypeArray[i] = new String("");
                    break;
                case Types.TIMESTAMP:
                    //System.out.println("column " + (i+1) +" Datatype is TIMESTAMP" );
                    //rowData[i] = results.getString(i+1);
                    //rowData[i] = results.getTimestamp(i+1).toString();
                    columnTypeArray[i] = new String("");
                    break;
                case Types.JAVA_OBJECT:
                    //System.out.println("column " + (i+1) +" Datatype is JAVA_OBJECT" );
                    columnTypeArray[i] = new Object();
                    break;
                default:
                    if(columnTypeNames[i].equals("text"))
                    {
                        //System.out.println("column " + (i+1) +" Datatype is text" );
                        columnTypeArray[i] = new String("");
                    } // if(columnTypeNames[i].equals("text"))
                    else
                    {
                        //System.out.println("column " + (i+1) +" Datatype is unknown" );
                        columnTypeArray[i] = new String("");
                    } // else
                        break;
                    } // switch(args.length)
                    //rowData[i] = results.getObject(i+1);
                    //rowData[i] = results.getString(i+1);
                     /*
                   if(columnTypeNames[i].equals("oid"))
                   {
                        //System.out.println("column " + (i+1) +" Datatype is text" );
                        rowData[i] = new Integer(results.getInt(i+1));                                  
                    } // if(columnTypeNames[i].equals("text"))
                    else
                    {
                        System.out.println("column " + (i+1) +" Datatype is unknown" );
                        rowData[i] = results.getObject(i+1);
                    } // else
                    */
        } // for(int i = 0; i < columns; i++)
        return columnTypeArray;
    } // public static Object[] processToColumnTypeArray(int[] param_ColumnTypes, String[] param_ColumnTypeNames)
    
    public static StatementMetaData parseSQLStatement(String statement)
    {
        StringTokenizer strTokenizer;
        String statementTrimmed = statement.trim();
        String statementQuote = "";                               // statement with spaces within QUOTEs and DOUBLE QUOTEs removed
        boolean inQuote = false;
        String lowerCaseStatementQuote;
        int start_ptr = 0;                                      // start pointer for sub-string
        int end_ptr = 0;                                        // end pointer for sub-string
        int from_start_ptr = 0;                                 // start pointer for the SQL keyword FROM
        String SQL_KEYWORD_FROM_lc = "from";                    // the FROM keyword in lower case;
        boolean has_FROM = false;                               // has the keyword FROM
        boolean is_escape = false;                              // an escape character
        boolean was_space = false;                              // to indicate that the previous character was a space
        String table_name = "";                                 // the table name
        boolean table_updatable = true;                         // whether the table is updatable or not.
        
        System.out.println(statementTrimmed.length());
        
        
        // Replace spaces and new lines \n inside QUOTEs with tabs \t
        // Replace tabs \t and new lines \n outside QUOTEs with spaces
        
        for(int i = 0; i < statementTrimmed.length(); i++)
        {
            if(is_escape)
            {
                is_escape = false;
                statementQuote = statementQuote + statementTrimmed.substring(i, i+1);
            } // if(is_escape)
            else if(statementTrimmed.substring(i, i+1).equals("\\"))
            {
                is_escape = true;
                statementQuote = statementQuote + statementTrimmed.substring(i, i+1);
            } // else if(statementTrimmed.substring(i, i+1).equals("\\"))
            else if(statementTrimmed.substring(i, i+1).equals("'") || statementTrimmed.substring(i, i+1).equals("\""))
            {
                statementQuote = statementQuote + statementTrimmed.substring(i, i+1);
                inQuote = !inQuote;
            } // if(statementTrimmed.substring(i, i).equals("'") || statementTrimmed.substring(i).equals("\""))
            else if(((statementTrimmed.substring(i, i+1).equals(" ") || statementTrimmed.substring(i, i+1).equals("\n")) && inQuote))
            {
                statementQuote = statementQuote + "\t";                  // <tab>
            } // else if((statementTrimmed.substring(i, i+1).equals(" ") && inQuote))
            else if(((statementTrimmed.substring(i, i+1).equals("\t") || statementTrimmed.substring(i, i+1).equals("\n")) && (!inQuote)))
            {
                statementQuote = statementQuote + " ";                      // <SPACE>
            }
            else
                statementQuote = statementQuote + statementTrimmed.substring(i, i+1);
        } // for(int i = 0; i < statementTrimmed.length(); i++)
                       
        String temp_str = "";
        String temp_str2 = "";
        
        // Remove the unnescessary spaces
        for(int i = 0; i < statementQuote.length(); i++)
        {
            if(statementQuote.substring(i, i+1).equals(" ") && (!was_space))
            {
                was_space = true;
                temp_str = temp_str + statementQuote.substring(i, i+1);
            } // if(is_escape)
            else if((!statementQuote.substring(i, i+1).equals(" ")))
            {
                was_space = false;
                temp_str = temp_str + statementQuote.substring(i, i+1);
            } // else if(was_space)
        } // for(int i = 0; i < statement.length(); i++)
        statementQuote = temp_str;
        System.out.println(statementQuote);
        
        // find a 'FROM'
        temp_str = "";
        lowerCaseStatementQuote = statementQuote.toLowerCase();
        if((lowerCaseStatementQuote.indexOf(" from ", start_ptr)) != -1)
        {
            has_FROM = true;
            temp_str = statementQuote.substring(lowerCaseStatementQuote.indexOf(" from ", start_ptr) + SQL_KEYWORD_FROM_lc.length() + 2); // adjusted + 2 for space
            strTokenizer = new StringTokenizer(temp_str, " ");
            if(strTokenizer.hasMoreTokens())
                table_name = strTokenizer.nextToken();
            if(table_name.toLowerCase().equals("only"))                         // take care of the keyword ONLY.
                table_name = strTokenizer.nextToken();
            temp_str2 = "";
        
            for(int i = 0; i < table_name.length(); i++)
            {
                if(table_name.substring(i, i+1).equals("\t"))
                    temp_str2 = temp_str2 + " ";
                else
                    temp_str2 = temp_str2 + table_name.substring(i, i+1);
            } // for(int i = 0; i < table_name; i++)
        
            table_name = temp_str2;
        
            // find a comma ,
            
            if(table_name.substring(table_name.length()-1, table_name.length()).equals(","))
            {
                table_updatable = false;
                table_name = table_name.substring(0, table_name.length()-1);
            }
             
                    
        } // if((from_start_ptr = lowerCaseStatementQuote.indexOf(" from ", start_ptr)) != -1)
        else
        {
            table_updatable = false;
        } // else
                
        System.out.println("table: " + table_name);
        
        /*
        if((from_start_ptr = lowerCaseStatementQuote.indexOf(" from ", start_ptr)) == -1)
            if((from_start_ptr = lowerCaseStatementQuote.indexOf("\nfrom ", start_ptr)) == -1)
                if((from_start_ptr = lowerCaseStatementQuote.indexOf("\nfrom\n", start_ptr)) == -1)
                    if((from_start_ptr = lowerCaseStatementQuote.indexOf(" from\n", start_ptr)) == -1)
        */
        
        //Integer
        
        return new StatementMetaData(table_name, table_updatable);
    } // public StatementMetaData parseSQLStatement()
        
    // make a prepared statement
    public static PreparedStatement getPreparedStatementForUpdate(Connection conn, String tableName, String[] columnNames, int[] columnTypes, String[] columnTypeNames, Object[] originalRowData, Object[] changedRowData)
    {
        Vector SET_parameters = new Vector();                       // parameter list for only changed columns
        String sql_statement = "UPDATE " + tableName;
        String WHERE_statement = " WHERE";
        
        PreparedStatement pStatement = null;
        
        String temp_condition = "";
        // get the list of columns with changed data
        for(int i = 0; i < columnNames.length; i++)
        {
            if((changedRowData[i] == null) && (originalRowData[i] == null))
                ;                                                   // If both are still null, we don't need to do anything.
            else if(originalRowData[i] == null)
                SET_parameters.add(new Integer(i));                 // If the original data is null, we will take the new value if it is not null(automatically not null since it passed the first if statement)
            else if(changedRowData[i] == null)
                SET_parameters.add(new Integer(i));                 // If the changed data is null, we will take the new value as null(original value automatically not null since it passed the first if statement)
            else if(!(changedRowData[i].equals(originalRowData[i])))
                SET_parameters.add(new Integer(i));
            
            // construct the WHERE_statement
            // Need to compansate for null
            if(originalRowData[i] == null)
                temp_condition = columnNames[i] + " IS NULL";
            else
                temp_condition = columnNames[i] + "=?";
                //if(originalRowData[i].getClass().equals(new BigDecimal(0).getClass()))
                //    temp_condition = columnNames[i] + "=\'?\'";
                //else
                    //temp_condition = columnNames[i] + "=?";
            if(i == 0)
                WHERE_statement = WHERE_statement + " " + temp_condition;
            else
                WHERE_statement = WHERE_statement + " AND " + temp_condition;
        } // for(int i = 0; i < columnNames.length; i++)
        
        // Form the sql statement
        sql_statement = sql_statement + " SET";
        for(int i = 0; i < SET_parameters.size(); i++)
        {
            if(i == 0)
                sql_statement = sql_statement + " " + columnNames[((Integer)SET_parameters.get(i)).intValue()] + "=?";
            else
                sql_statement = sql_statement + ", " + columnNames[((Integer)SET_parameters.get(i)).intValue()] + "=?";
        } // for(int i = 0; i < SET_parameters.size(); i++)
        
        sql_statement = sql_statement + WHERE_statement;
        
        System.out.println(sql_statement);
        
        if(SET_parameters.size() == 0)      // Don't do anything if statement if 0;
        {
            sql_statement = ";";
            return null;
        } // if(SET_parameters.size() == 0)
        
        // Fiil up the parameters
        int temp_index = 0;
        
        try
        {
        pStatement = conn.prepareStatement(sql_statement);
        
        for(int i = 0; i < SET_parameters.size(); i++)
            pStatement.setObject(++temp_index, changedRowData[((Integer)SET_parameters.get(i)).intValue()]);    // increment before using the varaible
        
        for(int i = 0; i < columnNames.length; i++)
            if(originalRowData[i] != null)                                      // skip if it is a null, value is already assigned as "IS NULL"
                pStatement.setObject(++temp_index, originalRowData[i]);                                             // increment before using the varaible
        }
        catch (SQLException sqle)
        {
            System.err.println("From pStatement" +  sqle);
        } // catch (SQLException sqle)
        
        System.out.println("temp index: " +temp_index);
        
        return pStatement;
    } // public void preparePreparedStatementforUpdate();
    
} // public class PostgreSQLDataObject implements DatabaseDataObjectAbstract
