package org.netbeans.mymodules.classevent;

import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.src.*;
import org.openide.src.ElementProperties;

import org.openide.src.SourceException;
import org.openide.cookies.*;

import org.openide.loaders.*;
import org.openide.filesystems.Repository;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;
import org.openide.windows.TopComponent;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.SwingConstants;

/** Action that can always be invoked and work procedurally.
 *
 * @author  oye
 */

public class ClassEvent extends CallableSystemAction {
  
    public void performAction () {

        Repository repo = TopManager.getDefault().getRepository();       
        FileObject filetobechecked = 
        repo.findResource("org/netbeans/mymodules/createfile/sub/NewSourceFile.java");         
        
        try {
        DataObject dataObject = DataObject.find ( filetobechecked );          
        SourceElement src = ((SourceCookie) dataObject.getCookie (SourceCookie.class)).getSource ();
                    // Should also check for multiple top-level classes:
        final ClassElement clazz = src.getClasses () [0];  //
        clazz.addPropertyChangeListener (new PropertyChangeListener () {
            
            public void propertyChange (PropertyChangeEvent ev) {
                if (ElementProperties.PROP_METHODS.equals (ev.getPropertyName())) {               
                    MethodElement[] newMethods = clazz.getMethods();  // gets the newly created methods
                      for (int i = 0; i < newMethods.length; i++)  {
                       System.out.println ("newMethods [i].getName()");    
                       System.out.println (newMethods [i].getName());
                }
               System.out.println ("newMethods.length");     
               System.out.println (newMethods.length);                    
             }
           }
        }); 
        
        } catch (IOException ioe){
            ioe.printStackTrace();
        
        } catch (Exception e){
            e.printStackTrace();
        }        
     }

    public String getName () {
        return NbBundle.getMessage (ClassEvent.class, "LBL_Action");
    }
    
    /*
    protected String iconResource () {
        return "ClassEventIcon.gif";
    }
     */
    
    public HelpCtx getHelpCtx () {
        return HelpCtx.DEFAULT_HELP;
    }
}
