/*
 *                 Sun Public License Notice
 * 
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 * 
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2000 Sun
 * Microopenide.systems, Inc. All Rights Reserved.
 */

package org.netbeans.mymodules.deletefile;

import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.TopManager;

import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.filesystems.FileLock;
import java.io.IOException;
import org.openide.filesystems.FileAlreadyLockedException;
/** Simple action. Opens up a new window and displays a message. */
public class DeleteFile extends CallableSystemAction {

    // generated
    private static final long serialVersionUID = 6101321673293585672L;

    public String getName () {
        return NbBundle.getBundle (DeleteFile.class).getString ("LBL_DeleteFile");
    }

    public HelpCtx getHelpCtx () {
        // In a real situation could map to installed JavaHelp...
        return HelpCtx.DEFAULT_HELP;
    }

    public void performAction () {       
        //This example deletes a subfolder with it's content files        
        Repository repo = TopManager.getDefault().getRepository();
        FileObject oldfolder =repo.findResource("org/netbeans/mymodules/newmenuitem/sub"); // from an existing file system
        FileLock lock = null;                      
         try {
           lock=oldfolder.lock();
         } catch (FileAlreadyLockedException e) {
         // Try again later; perhaps display a warning dialog.
         return;
         } catch ( IOException ioe) {
            ioe.printStackTrace();
         }
         try {
         // Delete it.
             oldfolder.delete(lock);
         } catch ( IOException exc) {
             exc.printStackTrace();
         } finally {
         // Always put this in a finally block!
         lock.releaseLock();
         }
     }
}
