/*
 *                 Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 *
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2000 Sun
 * Microopenide.systems, Inc. All Rights Reserved.
 */

package org.netbeans.mymodules.fileevent;

import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.TopManager;

import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;

import java.io.IOException;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.SwingConstants;
import java.lang.String;

import org.openide.src.*;
import org.openide.src.nodes.*;
import org.openide.loaders.*;
import org.openide.filesystems.FileSystem; // override java.io.FileSystem
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.windows.TopComponent;

/** Simple action. Listens to changes to a pre-existing file. /
 * /** No threading here*/

public class FileChanged extends CallableSystemAction  {
    // generated
    // private static final long serialVersionUID = 6101321673293585672L;
    
   /* private String parameter = "first";  //*/
    
    public String getName () {
        return NbBundle.getBundle (FileChanged.class).getString ("LBL_FileEvent");
    }
    
    public HelpCtx getHelpCtx () {
        // In a real situation could map to installed JavaHelp...
        return HelpCtx.DEFAULT_HELP;
    }
    
    public void performAction () {
        // Presentation code!      
        Repository repo = TopManager.getDefault().getRepository();
        FileObject filetobechanged 
        = repo.findResource("org/netbeans/mymodules/createfile/sub/NewSourceFile.java"); 
        // from an existing file system
        
        filetobechanged.addFileChangeListener(new FileChangeAdapter() {
            public void fileChanged(FileEvent ev) {
                System.out.println("Contents changed.");
             //  parameter = "Contents changed.";    
             //   openWindow(parameter);
            }
         /*   public void fileAttributeChanged(FileAttributeEvent ev) {
                parameter = ev.getName() + ": " + ev.getOldValue() + " -> " + ev.getNewValue();   
            //    openWindow(parameter);
            } */           
        });     
        // other methods include fileDeleted, fileDataCreated, fileFolderCreated, fileRenamed, fileAttributeChanged

    }
    /*
    public void openWindow(String param) {            
        JLabel label1 = new JLabel(param);
        label1.setFont (new Font ("Serif", Font.ITALIC | Font.BOLD, 24));
        label1.setHorizontalAlignment (SwingConstants.CENTER);
        
        TopComponent comp = new TopComponent ();
        comp.setName (NbBundle.getBundle (FileChanged.class).getString ("LBL_test_window_title"));
        comp.setLayout (new BorderLayout ());
        comp.add (label1, BorderLayout.CENTER);
        comp.setPreferredSize (new Dimension (500, 200));
        comp.open ();
        comp.requestFocus ();
     }   
     */
}
