package jp.turbosql.modules.at.app.dialogs;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.io.*;
import javax.swing.*;
import javax.accessibility.*;
//-----------------------------------
// xml libraries
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.apache.xerces.dom.*;
import org.apache.xml.serialize.*;
import org.apache.xerces.parsers.*;
import org.w3c.dom.traversal.*;
import org.xml.sax.*;
//-----------------------------------

public class GenericPropertyPane extends JComponent implements Accessible
{
    protected JTabbedPane tabbedPane;
    protected JPanel tabbedPanel;
    protected JPanel buttonPanel;
    protected JPanel contentPanel;
    protected JDialog dialog;
    protected Box verticalBox;
    //protected Vector horizontalBoxVector;
    protected Vector propertyLabelVector;
    protected Vector propertyValueComponentVector;
    protected Vector propertyTypeVector;
    protected Vector originalPropertyValueVector;
    protected JButton okButton;
    protected JButton cancelButton;
    //protected boolean propertiesChanged = false;
    JFileChooser fileChooser;
   
    protected String originalTextValue = "";
    protected JTextField textValueField;
    protected Document doc;
    protected Node originalTextNode;
    
    protected ActionListener refreshListener;
    protected Node nodeObject;
      
    protected int adjustedHeight = 0;
    //protected boolean removeBlankPropertyValue = false;       // we should use auto removal
    
    protected String tabTitle = "";
    protected boolean hasTextElement = false;
    
    public static final int NORMAL_PROPERTY = 0, REQUIRED_PROPERTY = 1, UNKNOWN_PROPERTY = 2, GENERIC_PROPERTY = 3;
    
    public static final Color darkOrangeColor = new Color(255, 51, 0);
    
    public static final Font normalPropertyFont = new Font("Default", Font.ITALIC, 12);         // also know as optional property
    public static final Color normalPropertyColor = darkOrangeColor;
    public static final Font requiredPropertyFont = new Font("Default", Font.BOLD, 12);
    public static final Color requiredPropertyColor = darkOrangeColor;
    public static final Font unknownPropertyFont = new Font("Default", Font.PLAIN, 12);
    public static final Color unknownPropertyColor = new Color(128, 128, 128);
    public static final Font genericPropertyFont = new Font("Default", Font.PLAIN, 12); 
    public static final Color  genericPropertyColor = darkOrangeColor;
    
    
    public GenericPropertyPane(Node nodeObject, Document doc, ActionListener refreshListener, Node originalTextNode)
    {
        this(nodeObject, doc, false, refreshListener, "Properties", originalTextNode);
    } // public GenericPropertyPane(Node nodeObject, ActionListener refreshListener)
          
    public GenericPropertyPane(Node nodeObject, Document doc, boolean hasTextElement, ActionListener refreshListener, String tabTitle, Node originalTextNode)
    {        
        this.nodeObject = nodeObject;
        this.refreshListener = refreshListener;
        this.tabTitle = tabTitle;
        this.doc = doc;
        this.hasTextElement = hasTextElement;
        this.originalTextNode = originalTextNode;        
        
        propertyLabelVector = new Vector();
        propertyValueComponentVector = new Vector();
        originalPropertyValueVector = new Vector();
        propertyTypeVector = new Vector();
        
        tabbedPane = new JTabbedPane();
        tabbedPanel = new JPanel();
        verticalBox = Box.createVerticalBox();
        tabbedPanel.add(verticalBox);
        
        buttonPanel = new JPanel();
        okButton = new JButton("Ok");
        cancelButton = new JButton("Cancel");
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
              
        tabbedPane.addTab(tabTitle, null, tabbedPanel, tabTitle);
        tabbedPane.setSelectedIndex(0);
        //tabbedPane.setBounds(0, 0, 100, 100);
        //contentPanel.setPreferredSize(new Dimension(100, 100));
        
        contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout());
        contentPanel.add(tabbedPane, BorderLayout.CENTER);
        contentPanel.add(buttonPanel, BorderLayout.SOUTH);
        
    } // public GenericPropertyPane()
    
    public String getPropertyValueForPropertyName(String propertyName)
    {
        int propertyIndex = -1;
        Object propertyValueComponent;
        
        for(int i = 0; i < propertyLabelVector.size(); i++)
        {
            //propertyLabelVector.indexOf(new JLabel(propertyName));
            if(((JLabel) propertyLabelVector.get(i)).getText().equals(propertyName))
            {
                propertyIndex = i;
                break;
            } // if(((JLabel) propertyLabelVector.get(i)).getText().equals(propertyName))
        } // for(int i = 0; i < propertyLabelVector.size(); i++)
        
        //System.out.println("Property Name: " + propertyName + ", Index: " + propertyIndex);
        if(propertyIndex != -1)     // -1 means that this property does not exist
        {
            propertyValueComponent = propertyValueComponentVector.get(propertyIndex);
            
            if(propertyValueComponent instanceof JComboBox)
            {
                return (String) ((JComboBox) propertyValueComponent).getSelectedItem();
            } // if(propertyValueComponent instanceof JComboBox)
            else        // it is JTextField
                return ((JTextField) propertyValueComponent).getText();
        } // if(propertyIndex != -1)
        else        
            return "";      // if object does not exist, we don't return anything
    } // public void getPropertyValueForPropertyName(String propertyName)
    
    public void add(String propertyName, String propertyValue, boolean useFileChooser, boolean chooseOnlyDirectories, String[] possiblePropertyValues, int propertyType)
    {
        // possiblePropertyValues reserved for making a custom combo box
        //Box horizontalBox = Box.createHorizontalBox();
        JPanel horizontalPanel = new JPanel(new GridLayout(1, 2));
        //JPanel horizontalPanel = new JPanel();
        JLabel propertyLabel = new JLabel(propertyName);
        JTextField propertyField;
        JComboBox propertyComboBox;
        boolean hasPossiblePropertyValues = false;
        //JPanel smallPanel = new JPanel();
               
        horizontalPanel.add(propertyLabel);
        propertyLabelVector.add(propertyLabel);
        
        if(propertyType == NORMAL_PROPERTY)
        {
            propertyLabel.setFont(normalPropertyFont);
            propertyLabel.setForeground(normalPropertyColor);
            //System.out.println("added NORMAL_PROPERTY");
        } // if(propertyType == NORMAL_PROPERTY)
        else if(propertyType == REQUIRED_PROPERTY)
        {
            propertyLabel.setFont(requiredPropertyFont);
            propertyLabel.setForeground(requiredPropertyColor);
            //System.out.println("added REQUIRED_PROPERTY");
        } // else if(propertyType == REQUIRED_PROPERTY)
        else if(propertyType == UNKNOWN_PROPERTY)
        {
            propertyLabel.setFont(unknownPropertyFont);
            propertyLabel.setForeground(unknownPropertyColor);
            //System.out.println("added UNKNOWN_PROPERTY");
        } // else if(propertyType == UNKNOWN_PROPERTY)
        else if(propertyType == GENERIC_PROPERTY)
        {
            propertyLabel.setFont(genericPropertyFont);
            propertyLabel.setForeground(genericPropertyColor);
            //System.out.println("added GENERIC_PROPERTY");
        } // else if(propertyType == UNKNOWN_PROPERTY)
        else        // we treat it as a generic property
        {
            propertyLabel.setFont(genericPropertyFont);
            propertyLabel.setForeground(genericPropertyColor);
        } // else
        
        propertyTypeVector.add(new Integer(propertyType));
        
        //propertyLabel.setFont(genericPropertyFont);// requiredPropertyFont
        
        if(possiblePropertyValues != null)
        {
            hasPossiblePropertyValues = true;
            // create combo box here
            
            propertyComboBox = new JComboBox(possiblePropertyValues);
            propertyComboBox.setEditable(true);     // we have to set it to editabale for before calling setSelectedItem
            propertyComboBox.setSelectedItem(propertyValue);
            propertyComboBox.setPreferredSize(new Dimension(120, 21));
            horizontalPanel.add(propertyComboBox);
            
            propertyValueComponentVector.add(propertyComboBox);
                        
            //horizontalBox.add(propertyComboBox);
        } // if(possiblePropertyValues != null)
        else
        {
            propertyField = new JTextField(propertyValue);
            //propertyField.setHorizontalAlignment(JTextField.LEFT);
            //propertyField.setBounds(0, 0, 120, 36);
            propertyField.setPreferredSize(new Dimension(120, 21));
            //horizontalPanel.add(propertyField);
            
            propertyValueComponentVector.add(propertyField);
            if(useFileChooser)
            {
                propertyField.setPreferredSize(new Dimension(120, 17));
                JButton fileButton = new JButton("...");
                fileButton.setPreferredSize(new Dimension(17, 17));
                fileButton.addActionListener(new FileChooserAction("...", propertyValueComponentVector.size() - 1, chooseOnlyDirectories));
                               
                JPanel smallPanel = new JPanel();
                smallPanel.setBorder(BorderFactory.createEmptyBorder());
                smallPanel.add(propertyField);
                smallPanel.add(fileButton);
                horizontalPanel.add(smallPanel);
            } // if(useFileChooser)
            else
            {
                propertyField.setPreferredSize(new Dimension(120, 21));
                horizontalPanel.add(propertyField);
            } // else
        } // else
        
        originalPropertyValueVector.add(propertyValue);
        verticalBox.add(horizontalPanel);
    } // public void add(String propertyName, String propertyValue, String[] possiblePropertyValues, int propertyType)
    
    public void add(String propertyName, String propertyValue)
    {
        add(propertyName, propertyValue, false, false, null, GENERIC_PROPERTY);
    } // public void add(String propertyName, String propertyValue)
    
    public void add(String propertyName, String propertyValue, int propertyType)
    {
        add(propertyName, propertyValue, false, false, null, propertyType);
    } // public void add(String propertyName, String propertyValue)
    
    // only one text value allowed.
    // can only be called once
    public void addTextValue(String textValue)
    {
        this.originalTextValue = textValue;
        
        JPanel horizontalPanel = new JPanel(new GridLayout(1, 2));
        JLabel propertyLabel = new JLabel("VALUE");
        textValueField = new JTextField(textValue);
        
        textValueField.setPreferredSize(new Dimension(120, 21));
        
        horizontalPanel.add(propertyLabel);
        horizontalPanel.add(textValueField);
        
        adjustedHeight += 21;
        
        verticalBox.add(horizontalPanel);
    } // public void addTextValue(String textValue)
    
    // overwrite with own method for child
    public JDialog createDialog(Component parentComponent, String title)
    {
        int width = 360, height = 100;
        dialog = new JDialog((JFrame)parentComponent, true);
        Container contentPane = dialog.getContentPane();
        dialog.setTitle(title);
        
        int extraHeight = 21 * propertyLabelVector.size();
        extraHeight += adjustedHeight;
        
        //contentPanel.setBounds(new Rectangle(new Dimension(width, height + extraHeight)));
        okButton.addActionListener(new AbstractAction("Ok"){
            public void actionPerformed(ActionEvent e)
            {
                if(performOKAction() == 0)
                    if(refreshListener != null)
                        refreshListener.actionPerformed(new ActionEvent(this, ActionEvent.ACTION_PERFORMED, "data modified"));
                
                dialog.dispose();
            } // public void actionPerformed(ActionEvent e)
        });
        
        contentPane.add(contentPanel);
        cancelButton.addActionListener(new AbstractAction("Cancel"){
            public void actionPerformed(ActionEvent e)
            {
                dialog.dispose();
            } // public void actionPerformed(ActionEvent e)
        });
        dialog.setBounds(new Rectangle(new Dimension(width, height + extraHeight)));
               
        return dialog;
    } // public JDialog createDialog(Component parentComponent, String title)
    
    /*      // refactored to use auto-removal of blank attributes
    public boolean getRemoveBlankPropertyValue()
    {
        return removeBlankPropertyValue;
    } // public boolean getRemoveBlankPropertyValue()
    public void setRemoveBlankPropertyValue(boolean RemoveBlankPropertyValues)
    {
        this.removeBlankPropertyValue = removeBlankPropertyValue;
    } // public void setRemoveBlankPropertyValue(boolean RemoveBlankPropertyValues)
     */
    
    public boolean isPropertiesChanged()
    {
        int count = propertyLabelVector.size();
        boolean hasChanged = false;
        
        for(int i = 0; i < count; i++)
        {
            String originalPropertyValue = (String) originalPropertyValueVector.get(i);
            Object propertyValueComponent = propertyValueComponentVector.get(i);
            if(propertyValueComponent instanceof JComboBox)
            {
                if(!((String) ((JComboBox) propertyValueComponent).getSelectedItem()).equals(originalPropertyValue))
                {
                    hasChanged = true;
                    break;
                } // if(!((String) ((JComboBox) propertyValueComponent).getSelectedItem()).equals(originalPropertyValue))
            } // if(propertyValueComponent instanceof JComboBox)
            else        // it is a JTextField
            {
                if(!((JTextField) propertyValueComponent).getText().equals(originalPropertyValue))
                {
                    hasChanged = true;
                    break;
                } // if(!((JTextField) propertyValueComponent).getText().equals(originalPropertyValue))
            } // else
        } // for(int i = 0; i < count; i++)
        
        if(hasTextElement)
        {
            if(!textValueField.getText().equals(originalTextValue))
                hasChanged = true;
        } // if(hasTextElement)
                
        return hasChanged;
    } // public boolean isPropertiesChanged()
    
    protected int performOKAction()
    {
        if(isPropertiesChanged())
                {
                    if(nodeObject != null)
                    {
                        int count = propertyLabelVector.size();
                        NamedNodeMap namedNodeMap = nodeObject.getAttributes();
                        for(int i = 0; i < count; i++)
                        {
                            //propertyValueComponentVector.get(i);
                            Node tempNode;
                            String propertyName = ((JLabel) propertyLabelVector.get(i)).getText();
                            
                            if(namedNodeMap != null)        // the attribute already exists
                            {
                                tempNode = namedNodeMap.getNamedItem(propertyName);
                                if(tempNode != null)
                                {
                                    //if(removeBlankPropertyValue && getPropertyValueForPropertyName(propertyName).equals(""))      // refactored to use auto-removal of blank attributes
                                    if(getPropertyValueForPropertyName(propertyName).equals(""))
                                    {
                                        if(((Integer) propertyTypeVector.get(i)).intValue() == REQUIRED_PROPERTY)
                                        {
                                            JOptionPane.showMessageDialog(dialog, "Warning! " + "Required Attribute \"" + propertyName + "\" has been removed.");
                                            namedNodeMap.removeNamedItem(propertyName);
                                        } // if(((Integer) propertyTypeVector.get(i)).intValue() == REQUIRED_PROPERTY)
                                        else if(((Integer) propertyTypeVector.get(i)).intValue() == NORMAL_PROPERTY)
                                            namedNodeMap.removeNamedItem(propertyName);
                                        else    // Generic Properties and Unknown Properties will not be removed, but be set to blank
                                            tempNode.setNodeValue(getPropertyValueForPropertyName(""));
                                    } // if(removeBlankPropertyValues)
                                    else
                                        tempNode.setNodeValue(getPropertyValueForPropertyName(propertyName));
                                } // if(tempNode != 0)
                                else        // we will need to create the attribute
                                {
                                    //if(removeBlankPropertyValue && getPropertyValueForPropertyName(propertyName).equals(""))      // refactored to use auto-removal of blank attributes
                                    if(getPropertyValueForPropertyName(propertyName).equals(""))
                                    {
                                        //if(((Integer) propertyTypeVector.get(i)).intValue() == REQUIRED_PROPERTY)
                                        //    JOptionPane.showMessageDialog(dialog, "Warning! " + "Required Attribute \"" + propertyName + "\" has been removed.");
                                        ;       // do nothing
                                    } // if(removeBlankPropertyValues)
                                    else
                                    {
                                        Node newAttr = doc.createAttribute(propertyName);
                                        newAttr.setNodeValue(getPropertyValueForPropertyName(propertyName));
                                        namedNodeMap.setNamedItem(newAttr);
                                    } // else
                                    //doc
                                } // else
                                //System.out.println("Name: " + tempNode.getNodeName() + ", Value: " + tempNode.getNodeValue());
                                /*
                                for(int j = 0; j < namedNodeMap.getLength(); j++)
                                {
                                    if(namedNodeMap.item(j).getNodeName().equals("port"))
                                        namedNodeMap.item(j).setNodeValue("8006");
                                    //System.out.println("attributes: /Name: " + namedNodeMap.item(j).getNodeName() + " /Value: " + namedNodeMap.item(j).getNodeValue());
                                 } // for(int i = 0; i < namedNodeMap.getLenth(); i++)
                                 */
                            } // if(namedNodeMap != null)
                        } // for(int i = 0; i < count; i++)
                        //if(refreshListener != null)
                            //refreshListener.actionPerformed(new ActionEvent(this, ActionEvent.ACTION_PERFORMED, "data modified"));
                        if(hasTextElement)
                        {
                            if(!textValueField.getText().equals(originalTextValue))
                            {
                                if(originalTextNode != null)
                                    nodeObject.replaceChild(doc.createTextNode(textValueField.getText()), originalTextNode);
                                else
                                    nodeObject.appendChild(doc.createTextNode(textValueField.getText()));
                            } // if(!textValueField.getText().equals(originalTextValue))
                        } // if(hasTextElement)
                        return 0;    // we refresh if it is successful
                    } // if(nodeObject != null)
                } // if(isPropertiesChanged())
                //else
                //    System.out.println("Not changed");
                return 1;
    } // protected void performOKAction()
    
    protected JFileChooser getFileChooser()
    {
        if(fileChooser == null)
            fileChooser = new JFileChooser();
        return fileChooser;
    } // protected JFileChoose getFileChooser()
    
    class FileChooserAction extends AbstractAction
    {
        int index;      // pointing to the propertyValueComponentVector which created this action
        boolean chooseOnlyDirectories;
        
        public FileChooserAction(String name, int index, boolean chooseOnlyDirectories)
        {
            super(name);
            this.index = index;
            this.chooseOnlyDirectories = chooseOnlyDirectories;
        } // public FileChooserAction(String name, int index)
                                                       
        public void actionPerformed(ActionEvent e)
        {
            JFileChooser fc = getFileChooser();
            if(chooseOnlyDirectories)
                fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);

            int returnVal = fc.showOpenDialog(dialog); // Note: this means that the fileChooser only works after a call to create Dialog is made

            if(returnVal == JFileChooser.APPROVE_OPTION)
            {
                File file = fc.getSelectedFile();
                //this is where a real application would open the file.
                ((JTextField) propertyValueComponentVector.get(index)).setText(file.getAbsolutePath());
                 //log.append("Opening: " + file.getName() + "." + newline);
            } // if(returnVal == JFileChooser.APPROVE_OPTION)
            else 
            {
                //log.append("Open command cancelled by user." + newline);
            } // else
        } // public void actionPerformed(ActionEvent e)                
        
    } // class FileChooserAction extends AbstractAction
    
    public static void main(String[] args)
    {
        JFrame frame = new JFrame();
        String[] possiblePropertyValues = {"", "8080", "8180", "8281"};
        frame.setBounds(0, 0, 100, 100);
        frame.setVisible(true);
        frame.setDefaultCloseOperation(frame.DISPOSE_ON_CLOSE);
                
        GenericPropertyPane propertyPane = new GenericPropertyPane(null, null, false, null, "Properties", null);
        propertyPane.add("className", "jp.turbosql.modules.at.app.dialogs");
        propertyPane.add("port", "8085", true, true, null, GenericPropertyPane.NORMAL_PROPERTY);
        propertyPane.add("shutdown", "down");
        JDialog dialog = propertyPane.createDialog(frame, "Properties");
        dialog.show();
    } // public static void main(String[] args)
    
} // public class GenericPropertPane extends JComponent implements Accessible


