package jp.turbosql.modules.at.app.tomcat4;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
//-----------------------------------
// xml libraries
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.apache.xerces.dom.*;
import org.apache.xml.serialize.*;
import org.apache.xerces.parsers.*;
import org.w3c.dom.traversal.*;
import org.xml.sax.*;
//-----------------------------------
import jp.turbosql.modules.at.app.wizards.*;

// the GenericWizardlet provides alot of methods we can use directly
public class AliasElementWizardlet extends GenericWizardlet
{
    protected String[] allAttr = {};                         // holds all the attributes
    protected boolean[] requiredAttr = {};                    // required attributes
    protected String[] attrDefaultValue = {};
    protected boolean[] hasComboBoxValues = {};
    protected String[][] comboBoxValues = {};
    protected boolean[] useFileChooser = {};
    protected boolean[] chooseOnlyDirectories = {};
    
    //------------------------------------------------------------------------
    protected String originalTextValue = "";
    //protected JTextField textValueField;
    //protected Node originalTextNode;    
    protected String defaultTextValue = "";
    protected boolean hasTextElement = true;        // this indicates that it has a TextElement
    protected int adjustedHeight = 0;       // note: we only use this to adjust the height if this is a text element
    //------------------------------------------------------------------------
    
    public AliasElementWizardlet(Document doc)
    {
        super();
        super.allAttr = allAttr;
        super.requiredAttr = requiredAttr;
        super.attrDefaultValue = attrDefaultValue;
        super.hasComboBoxValues = hasComboBoxValues;
        super.comboBoxValues = comboBoxValues;
        super.useFileChooser = useFileChooser;
        super.chooseOnlyDirectories = chooseOnlyDirectories;
        this.doc = doc;
        
        //------------------------------------------------------------------------
        super.originalTextValue = originalTextValue;
        //super.textValueField = textValueField;
        //super.originalTextNode = originalTextNode;
        super.defaultTextValue = defaultTextValue;
        super.hasTextElement = hasTextElement;
        super.adjustedHeight = adjustedHeight;
        //------------------------------------------------------------------------
        
        doAllAttrProcessing();
    } // public AliasElementWizardlet(Document)
    
    public Object createUserObject()
    {
        Node aliasElementNode = doc.createElement("Alias");
        NamedNodeMap namedNodeMap = aliasElementNode.getAttributes();
        
        //getPropertyValueForPropertyName(String propertyName)
        for(int i = 0; i < allAttr.length; i++)
        {
            String attrValue = getPropertyValueForPropertyName(allAttr[i]);
            
            if(!attrValue.equals(""))
            {
                Node attr = doc.createAttribute(allAttr[i]);
                attr.setNodeValue(attrValue);
                namedNodeMap.setNamedItem(attr);
            } // if(!attrValue.equals(""))
        } // for(int i = 0; i < allAttr.length; i++)
        
        // create a text value
        if(hasTextElement)
            if(!super.textValueField.getText().equals(""))
                aliasElementNode.appendChild(doc.createTextNode(super.textValueField.getText()));
        
        userObject = aliasElementNode;
        return userObject;
    } // public Object createUserObject()
    
    public String getStepName()
    {
        return "Enter Alias Attributes";
    } // public String getStepName()
} // public class AliasElementWizardlet extends Wizardlet