package jp.turbosql.modules.at.app.tomcat4;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
//-----------------------------------
// xml libraries
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.apache.xerces.dom.*;
import org.apache.xml.serialize.*;
import org.apache.xerces.parsers.*;
import org.w3c.dom.traversal.*;
import org.xml.sax.*;
//-----------------------------------

import jp.turbosql.modules.at.app.*;
import jp.turbosql.modules.at.app.dialogs.*;
import jp.turbosql.modules.at.app.wizards.*;

public class EngineElementNodeObject extends ElementNodeObject
{
    protected Node engineElementNode;
    
    protected String nodeActionList_addHostAction = "Add Host", nodeActionList_AddValveAction = "Add Valve", nodeActionList_AddLoggerAction = "Add Logger";
    protected String[] nodeActionList = {nodeActionList_addHostAction, nodeActionList_addAttributesAction, nodeActionList_removeAttributesAction, nodeActionList_viewAttributesAction, "JSeparator", nodeActionList_AddValveAction, nodeActionList_AddLoggerAction};
    protected String multipleNodeActionList_viewAttributesAction = "Do nothing";
    protected String[] multipleNodeActionList = {multipleNodeActionList_viewAttributesAction};
    
    protected String[] allAttr = {"className", "defaultHost", "jvmRoute", "name", "debug"};                         // holds all the attributes
    protected boolean[] requiredAttr = {false, true, false, true, false};                    // required attributes
    protected String[] attrDefaultValue = {"", "", "", "", ""};                    // attributes values
    
    public EngineElementNodeObject(String objectName, Object userObject)
    {
        super(objectName, userObject);
                
        super.nodeActionList = nodeActionList;
        super.multipleNodeActionList = multipleNodeActionList;
        
        super.allAttr = allAttr;
        super.requiredAttr = requiredAttr;
        super.attrDefaultValue = attrDefaultValue;
                
        engineElementNode = (Node) userObject;
    } // public EngineElementNodeObject()
    
    public EngineElementNodeObject(String objectName)     // overloaded constructor
    {
        this(objectName, null);
    } // public EngineElementNodeObject()
    
    public EngineElementNodeObject()
    {
        this(null, null);
    } // public EngineElementNodeObject()
    
    // Only Handle the one we want to
    public void performSingleNodeAction(Component parentComponent, String actionName, JTree jTree, ActionListener refreshListener)
    {
        if(actionName.equals(nodeActionList_addHostAction))
        {
            performAddHostAction(parentComponent, actionName, jTree, refreshListener);
            //System.out.println("add Host");
        } // if(actionName.equals(nodeActionList_addHostAction))
        else if(actionName.equals(nodeActionList_addAttributesAction) || actionName.equals(nodeActionList_removeAttributesAction) || actionName.equals(nodeActionList_viewAttributesAction)) // we delegate to the ihe parent class
            super.performSingleNodeAction(parentComponent, actionName, jTree, refreshListener);
        else
            super.performSingleNodeAction(parentComponent, actionName, jTree, refreshListener);
    } // public void performSingleNodeAction(Component parentComponent, String actionName, JTree jTree, ActionListener refreshListener)
    
    protected void performAddHostAction(Component parentComponent, String actionName, JTree jTree, ActionListener refreshListener)
    {
        HostElementWizardlet hostElementWizardlet = new HostElementWizardlet(doc);
        ContextElementWizardlet contextElementWizardlet = new ContextElementWizardlet(doc);
        ValveElementWizardlet valveElementWizardlet = new ValveElementWizardlet("org.apache.catalina.valves.AccessLogValve", doc);
        LoggerElementWizardlet loggerElementWizardlet = new LoggerElementWizardlet("org.apache.catalina.logger.FileLogger", doc);
        
        Wizardlet[] wizardlets = {hostElementWizardlet, contextElementWizardlet, valveElementWizardlet, loggerElementWizardlet};
        WizardControllerPane wizardControllerPane = new WizardControllerPane(wizardlets);
        JDialog dialog = wizardControllerPane.createDialog(parentComponent, "Wizard");
        //System.out.println(wizardControllerPane.getNormalFinish());
        dialog.show();
        
        //System.out.println(wizardControllerPane.getNormalFinish());
        if(wizardControllerPane.getNormalFinish())
        {                      
            Node hostElementNode = (Node) hostElementWizardlet.createUserObject();
            Node contextElementNode = (Node) contextElementWizardlet.createUserObject();
            Node valveElementNode = (Node) valveElementWizardlet.createUserObject();
            Node loggerElementNode = (Node) loggerElementWizardlet.createUserObject();
            
            nodeObject.appendChild(hostElementNode);
            hostElementNode.appendChild(contextElementNode);
            hostElementNode.appendChild(valveElementNode);
            hostElementNode.appendChild(loggerElementNode);
            
            if(refreshListener != null)
                refreshListener.actionPerformed(new ActionEvent(this, ActionEvent.ACTION_PERFORMED, "data modified"));
        } // if(wizardControllerPane.getNormalFinish())
    } // protected void addHostAction(Component parentComponent, String actionName, JTree jTree, ActionListener refreshListener)
    
    protected void performAddValveAction(Component parentComponent, String actionName, JTree jTree, ActionListener refreshListener)
    {
        ValveElementWizardlet valveElementWizardlet = new ValveElementWizardlet("org.apache.catalina.valves.AccessLogValve", doc);
        Wizardlet[] wizardlets = {valveElementWizardlet};
        WizardControllerPane wizardControllerPane = new WizardControllerPane(wizardlets);
        JDialog dialog = wizardControllerPane.createDialog(parentComponent, "Wizard");
        //System.out.println(wizardControllerPane.getNormalFinish());
        dialog.show();
        
        //System.out.println(wizardControllerPane.getNormalFinish());
        if(wizardControllerPane.getNormalFinish())
        {                      
            Node valveElementNode = (Node) valveElementWizardlet.createUserObject();
            
            nodeObject.appendChild(valveElementNode);
            
            if(refreshListener != null)
                refreshListener.actionPerformed(new ActionEvent(this, ActionEvent.ACTION_PERFORMED, "data modified"));
        } // if(wizardControllerPane.getNormalFinish())
    } // protected void performAddValveAction(Component parentComponent, String actionName, JTree jTree, ActionListener refreshListener)
    
    protected void performAddLoggerAction(Component parentComponent, String actionName, JTree jTree, ActionListener refreshListener)
    {
        LoggerElementWizardlet loggerElementWizardlet = new LoggerElementWizardlet("org.apache.catalina.logger.FileLogger", doc);
        Wizardlet[] wizardlets = {loggerElementWizardlet};
        WizardControllerPane wizardControllerPane = new WizardControllerPane(wizardlets);
        JDialog dialog = wizardControllerPane.createDialog(parentComponent, "Wizard");
        //System.out.println(wizardControllerPane.getNormalFinish());
        dialog.show();
        
        //System.out.println(wizardControllerPane.getNormalFinish());
        if(wizardControllerPane.getNormalFinish())
        {                      
            Node LoggerElementNode = (Node) loggerElementWizardlet.createUserObject();
            
            nodeObject.appendChild(LoggerElementNode);
            
            if(refreshListener != null)
                refreshListener.actionPerformed(new ActionEvent(this, ActionEvent.ACTION_PERFORMED, "data modified"));
        } // if(wizardControllerPane.getNormalFinish())
    } // protected void performAddLoggerAction(Component parentComponent, String actionName, JTree jTree, ActionListener refreshListener)
    
} // public class EngineElementNodeObject