package jp.turbosql.modules.at.app.tomcat4;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.tree.*;
import java.io.*;
//-----------------------------------
// xml libraries
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.apache.xerces.dom.*;
import org.apache.xml.serialize.*;
import org.apache.xerces.parsers.*;
import org.w3c.dom.traversal.*;
import org.xml.sax.*;
//-----------------------------------

import jp.turbosql.modules.at.app.*;

// we will register our ElementNodeObjects here
public class ServerXMLObject
{
    private static final String defaultDirectory = "/var/tomcat4/conf/";
    private static final String defaultFile = "server.xml";
    
    private static final String defaultActionList_default = "no action";
    private static final String[] defaultActionList = {defaultActionList_default};
        
    private DefaultMutableTreeNode serverNode;                  // Root node for the database tree
    private String fileURL;                                     // url of server.xml
    private Document doc;                                // In-Memory document
    private ActionListener refreshListener;                // used for refreshing.
    
    // refreshListener.actionPerformed(null);
    
    /*
    public ServerXMLObject()
    {
        this("/var/tomcat4/conf/server.xml", null);
    } // public ServerXMLObject()
     */
    
    // we require the refreshListener for now.
    public ServerXMLObject(ActionListener refreshListener)
    {
        this(defaultDirectory + defaultFile, refreshListener);
    } // public ServerXMLObject()
    
    public ServerXMLObject(String fileURL, ActionListener refreshListener)
    {
        this.fileURL = fileURL;
        this.refreshListener = refreshListener;
        readFromFile();
        buildTree();
    } // public ServerXMLObject()
    
    public String getFileURL()
    {
        return fileURL;
    } // public String getFileURL()
    
    public void setFileURL(String fileURL)
    {
        this.fileURL = fileURL;
    } // public void setFileURL()
    
    public void buildTree()
    {
     
        //--------------------------------------------------------------------
        // xml document processing
        DefaultMutableTreeNode tempServerNode = new DefaultMutableTreeNode("server.xml");
        //atTreeModel = new DefaultTreeModel(serverNode);
        //atTree = new JTree(atTreeModel);
                     
        if(doc == null)     // we do nothing
            return;
        //try
        //{
           //----------------------------------------------------------------           
            DocumentImpl impl = (DocumentImpl) doc;
            NodeIterator iterator = impl.createNodeIterator(doc.getDocumentElement(),
                NodeFilter.SHOW_ELEMENT, null, true);
            Node node;
            
            /*
            if((node = iterator.nextNode()) != null)    // this takes care of the first node
            {
                serverNode = new DefaultMutableTreeNode(node);
            } // if((node = iterator.nextNode()) != null)
                   
            int c = 0;
            while ((node = iterator.nextNode()) != null) {
                c++;
                System.out.println("line " + c + ": " + node);
                processNode(node, serverNode);      
            }
             */
            node = doc.getDocumentElement();
            processNode(node, tempServerNode);
            serverNode = (DefaultMutableTreeNode) tempServerNode.getFirstChild();
            
            // clean it since we will not need it anymore
            tempServerNode.removeAllChildren();
            tempServerNode = null;
            //----------------------------------------------------------------                   
        /*
        } // try
        catch (SAXException e)
        {
            System.err.println(e); 
        } // catch (SAXException e)
        catch (IOException e)
        {
            System.err.println(e); 
        } // catch (IOException e)
         */
        //--------------------------------------------------------------------
    } // public void buildTree()
    
    public void refreshInMemoryTree()
    {
        buildTree();
    } // public void refreshTree()
    
    public void refreshTreeFromFile()
    {
        readFromFile();
        buildTree();
    } // public void refreshTreeFromFile()
        
    public DefaultMutableTreeNode getRootNode()
    {
        return serverNode;
    } // public DefaultMutableTreeNode getRootNode()
        
    public void processNode(Node node, DefaultMutableTreeNode treeNode)
    {
        String name = node.getNodeName();
        String type = getTypeName(node.getNodeType());
        String value = node.getNodeValue();
        DefaultMutableTreeNode newTreeNode = null; // (?)
        
        if(node != null) {
            if(!(type.equals("Text") || type.equals("Comment"))) {
                if(type.equals("Element")) {
                    NamedNodeMap namedNodeMap = node.getAttributes();
                    String nodeName = node.getNodeName();
                    Node namedItem;
                    
                    //--------------------------------------------------------
                    // adding new ElementNodeObjects    1 of 4            
                    if(nodeName.equals("Server"))
                    {
                        newTreeNode = new DefaultMutableTreeNode(new ServerElementNodeObject(nodeName, node));
                        //System.out.println("Server element added");
                    } // if(nodeName.equals("Server"))
                    else if(nodeName.equals("Engine"))
                    {
                        newTreeNode = new DefaultMutableTreeNode(new EngineElementNodeObject(nodeName, node));                        
                    } // if(nodeName.equals("Engine"))
                    else if(nodeName.equals("Host"))
                    {
                        newTreeNode = new DefaultMutableTreeNode(new HostElementNodeObject(nodeName, node));
                        //System.out.println("Host element added");
                    } // if(nodeName.equals("Host"))
                    else if(nodeName.equals("Context"))
                    {
                        newTreeNode = new DefaultMutableTreeNode(new ContextElementNodeObject(nodeName, node));
                        //System.out.println("Context element added");
                    } // if(nodeName.equals("Context"))
                    else if(nodeName.equals("Alias"))
                    {
                        newTreeNode = new DefaultMutableTreeNode(new AliasElementNodeObject(nodeName, node));
                        //System.out.println("Alias element added");
                    } // if(nodeName.equals("Alias"))
                    else if(nodeName.equals("Valve"))
                    {
                        newTreeNode = new DefaultMutableTreeNode(new ValveElementNodeObject(nodeName, node));
                        //System.out.println("Valve element added");
                    } // if(nodeName.equals("Valve"))
                    else if(nodeName.equals("Logger"))
                    {
                        newTreeNode = new DefaultMutableTreeNode(new LoggerElementNodeObject(nodeName, node));
                        //System.out.println("Logger element added");
                    } // if(nodeName.equals("Logger"))
                    else if(nodeName.equals("name") || nodeName.equals("value") || nodeName.equals("Alias"))
                    {
                        newTreeNode = new DefaultMutableTreeNode(new ElementNodeObject(nodeName, node, true));
                    } // if(nodeName.equals("name") || nodeName.equals("value") || nodeName.equals("Alias"))
                    else        // treat it as a default element
                    {                    
                        if(namedNodeMap != null) {
                            /*
                            for(int i = 0; i < namedNodeMap.getLength(); i++)
                            {
                                //System.out.println("attributes: /Name: " + namedNodeMap.item(i).getNodeName() + " /Value: " + namedNodeMap.item(i).getNodeValue());
                            } // for(int i = 0; i < namedNodeMap.getLenth(); i++)
                            */
                            if((namedItem = namedNodeMap.getNamedItem("name")) != null) {
                                nodeName = nodeName + ": " + namedItem.getNodeValue();
                            } // if((namedItem = namedNodeMap.getNamedItem("name")) != null)
                            else if((namedItem = namedNodeMap.getNamedItem("className")) != null) {
                                nodeName = nodeName + ": " + namedItem.getNodeValue();
                            } // else if((namedItem = namedNodeMap.getNamedItem("className")) != null)
                        } // if(namedNodeMap != null)
                    
                        newTreeNode = new DefaultMutableTreeNode(new ElementNodeObject(nodeName, node));
                    } // else
                } // if(type.equals("Element"))
                else {
                    newTreeNode = new DefaultMutableTreeNode(node);
                } // else
                
                treeNode.add(newTreeNode);
                
                if(node.hasChildNodes()) {
                    NodeList nodeList = node.getChildNodes();
                    for(int i = 0; i < nodeList.getLength(); i++) {
                        processNode(nodeList.item(i), newTreeNode);
                    } // for(int i = 0; i < nodeList.getLength(); i++)
                } // if(node.hasChildNodes())
            } // if(!type.equals("Text"))
            else {
                if(node.hasChildNodes()) {
                    NodeList nodeList = node.getChildNodes();
                    for(int i = 0; i < nodeList.getLength(); i++) {
                        processNode(nodeList.item(i), treeNode);
                    } // for(int i = 0; i < nodeList.getLength(); i++)
                } // if(node.hasChildNodes())
            } // else
            //treeNode.add(newTreeNode);
        } // if(node != null)
        
        //System.out.println("Type " + type + ": " + name
        //+ " \"" + value + "\"");
    } // public void processNode(Node node, DefaultMutableTreeNode treeNode)
    
    public static String getTypeName(int type)
    {
        switch (type) {
            case Node.ELEMENT_NODE: return "Element";
            case Node.ATTRIBUTE_NODE: return "Attribute";
            case Node.TEXT_NODE: return "Text";
            case Node.CDATA_SECTION_NODE: return "CDATA Section";
            case Node.ENTITY_REFERENCE_NODE: return "Entity Reference";
            case Node.ENTITY_NODE: return "Entity";
            case Node.PROCESSING_INSTRUCTION_NODE: return "Processing Instruction";
            case Node.COMMENT_NODE : return "Comment";
            case Node.DOCUMENT_NODE: return "Document";
            case Node.DOCUMENT_TYPE_NODE: return "Document Type Declaration";
            case Node.DOCUMENT_FRAGMENT_NODE: return "Document Fragment";
            case Node.NOTATION_NODE: return "Notation";
            default: return "Unknown Type";
        } // switch (type)
    } // public static String getTypeName(int type)
    
    // get the doc from File
    public int readFromFile()
    {
        DOMParser parser = new DOMParser();
        
        try
        {
             // Read the entire document into memory
            parser.parse(fileURL);
       
            doc = parser.getDocument();
            //atTree = new DOMTree(doc);
        } // try
        catch (SAXException e)
        {
            System.err.println(e);
            return 1;
        } // catch (SAXException e)
        catch (IOException e)
        {
            System.err.println(e);
            return 1;
        } // catch (IOException e)
        return 0;
    } // public void readFromFile()
    
    public int writeToFile()
    {
        //String fileEncoding = "UTF-8";
        String fileEncoding = "iso-8859-1";
        OutputFormat format = new OutputFormat(doc, fileEncoding, true);
        
        File originalFile = new File(defaultDirectory + defaultFile);
        boolean isRenamed  = originalFile.renameTo(new File(defaultDirectory + defaultFile + "~"));
        
        if(isRenamed)
        {
            try
            {
                //ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream("/root/java/xml/fibonacci_test.xml")));
                //out.writeObject(theApp.getModel());
                FileOutputStream out = new FileOutputStream(defaultDirectory + defaultFile);
                XMLSerializer serializer = new XMLSerializer(out, format);
                serializer.serialize(doc);
                out.flush();
                out.close();
            } // try
            catch(IOException e)
            {
                System.err.println(e);
                return 1;
            } // catch(IOException e)
        } // if(isReanamed)
        return 0;
    }
    
    public String[] getPopupMenuNodeActionList(NodeObject nodeObject) {
        String[] popupList;
        
        //--------------------------------------------------------
        // adding new ElementNodeObjects    2 of 4
        if(nodeObject instanceof ServerElementNodeObject)
        {
            popupList = ((ServerElementNodeObject) nodeObject).getNodeActionList();
            //System.out.println("Server element popped");
        } // if(nodeObject instanceof ServerElementNodeObject)
        else if(nodeObject instanceof EngineElementNodeObject)
        {
            popupList = ((EngineElementNodeObject) nodeObject).getNodeActionList();            
        } // if(nodeObject instanceof EngineElementNodeObject)
        else if(nodeObject instanceof HostElementNodeObject)
        {
            popupList = ((HostElementNodeObject) nodeObject).getNodeActionList();
            //System.out.println("Host element popped");
        } // else if(nodeObject instanceof HostElementNodeObject)
        else if(nodeObject instanceof ContextElementNodeObject)
        {
            popupList = ((ContextElementNodeObject) nodeObject).getNodeActionList();
            //System.out.println("Context element popped");
        } // else if(nodeObject instanceof ContextElementNodeObject)
        else if(nodeObject instanceof AliasElementNodeObject)
        {
            popupList = ((AliasElementNodeObject) nodeObject).getNodeActionList();
            //System.out.println("Server element popped");
        } // else if(nodeObject instanceof HostElementNodeObject)
        else if(nodeObject instanceof ValveElementNodeObject)
        {
            popupList = ((ValveElementNodeObject) nodeObject).getNodeActionList();
            //System.out.println("Valve element popped");
        } // else if(nodeObject instanceof ValveElementNodeObject)
        else if(nodeObject instanceof LoggerElementNodeObject)
        {
            popupList = ((LoggerElementNodeObject) nodeObject).getNodeActionList();
            //System.out.println("Logger element popped");
        } // else if(nodeObject instanceof LoggerElementNodeObject)
        else if(nodeObject instanceof WithTextElementNodeObject)
        {
            popupList = ((WithTextElementNodeObject) nodeObject).getNodeActionList();            
        } // else if(nodeObject instanceof WithTextElementNodeObject)
        else if(nodeObject instanceof ElementNodeObject)        // note: that this has to be checked in the last else if, since all other nodes are instances of ElementNodeObject
        {
            popupList = ((ElementNodeObject) nodeObject).getNodeActionList();
        } // else if(nodeObject instanceof ElementNodeObject)
        else
        {
            popupList = defaultActionList;
        } // else
        
        return popupList;
    }
    
    public String getNodePropertyInHTML(Component component, JTree jTree) {
        //System.out.println("getNodePropertyInHTML");
        int selectionCount = jTree.getSelectionCount();
        int[] selectedRows;
        
        //--------------------------------------------------------------------
        // node actions
        if(selectionCount != 0) {
            selectedRows = jTree.getSelectionRows();
            TreePath[] treePath = jTree.getSelectionPaths();
            //hasSelection = true;
            Object[] selectedNodes = new Object[selectionCount];
            for(int i = 0; i < selectionCount; i++) {
                selectedNodes[i] = ((DefaultMutableTreeNode) treePath[i].getLastPathComponent()).getUserObject();
            } // for(int i = 0; i < selectionCount; i++)
        
            //--------------------------------------------------------
            // adding new ElementNodeObjects    3 of 4
            
            if(selectedNodes[0] instanceof ServerElementNodeObject)
            {
                return ((ServerElementNodeObject) selectedNodes[0]).getPropertyHTML(); // show a blank property screen
                // Only one node selected
                /*
                if(selectedNodes.length == 1)
                {
                    return ""; // show a blank property screen
                } // if(selectedNodes.length == 1)
                // More than one node sslected
                else
                {
                    return ""; // show a blank property screen
                } // else
                 */
            } // if(nodeObject instanceof ServerNodeObject)
            else if(selectedNodes[0] instanceof EngineElementNodeObject)
            {
                return ((EngineElementNodeObject) selectedNodes[0]).getPropertyHTML();
            } // else if(selectedNodes[0] instanceof EngineElementNodeObject)
            else if(selectedNodes[0] instanceof HostElementNodeObject)
            {
                return ((HostElementNodeObject) selectedNodes[0]).getPropertyHTML();
            } // else if(selectedNodes[0] instanceof HostElementNodeObject)
            else if(selectedNodes[0] instanceof ContextElementNodeObject)
            {
                return ((ContextElementNodeObject) selectedNodes[0]).getPropertyHTML();
            } // else if(selectedNodes[0] instanceof ContextElementNodeObject)
            else if(selectedNodes[0] instanceof AliasElementNodeObject)
            {
                return ((AliasElementNodeObject) selectedNodes[0]).getPropertyHTML();
            } // else if(selectedNodes[0] instanceof HostElementNodeObject)
            else if(selectedNodes[0] instanceof ValveElementNodeObject)
            {
                return ((ValveElementNodeObject) selectedNodes[0]).getPropertyHTML();
            } // else if(selectedNodes[0] instanceof ValveElementNodeObject)
            else if(selectedNodes[0] instanceof LoggerElementNodeObject)
            {
                return ((LoggerElementNodeObject) selectedNodes[0]).getPropertyHTML();
            } // else if(selectedNodes[0] instanceof LoggerElementNodeObject)
            else if(selectedNodes[0] instanceof WithTextElementNodeObject)
            {
                return ((WithTextElementNodeObject) selectedNodes[0]).getPropertyHTML(); // show a blank property screen
            } // else if(selectedNodes[0] instanceof DatabaseListNodeObject)
            else if(selectedNodes[0] instanceof ElementNodeObject)      // note: that this has to be checked in the last else if, since all other nodes are instances of ElementNodeObject
            {
                return ((ElementNodeObject) selectedNodes[0]).getPropertyHTML(); // show a blank property screen
            } // else if(selectedNodes[0] instanceof DatabaseListNodeObject)
            else
            {
                return ""; // show a blank property screen
                /*
                // Only one node selected
                if(selectedNodes.length == 1)
                {
                    ;
                } // if(selectedNodes.length == 1)
                // More than one node sslected
                else
                {
                    ;
                } // else
                 */
            } // else
        } // else if(selectedNodes[0] instanceof TableNodeObject)
        else {
            //--------------------------------------------------------------------
            // default actions
            return ""; // show a blank property screen
            //return null;
        } // else
        
        //return null;            // should not reach here unless something goes wrong
    }
    
    public void performAction(Component component, String actionName, JTree jTree, ActionListener refreshListener)
    {
        int selectionCount = jTree.getSelectionCount();
        int[] selectedRows;
        //--------------------------------------------------------------------
        // node actions
        if(selectionCount != 0)
        {
            selectedRows = jTree.getSelectionRows();
            TreePath[] treePath = jTree.getSelectionPaths();
            //hasSelection = true;
            Object[] selectedNodes = new Object[selectionCount];
            for(int i = 0; i < selectionCount; i++) {
                selectedNodes[i] = ((DefaultMutableTreeNode) treePath[i].getLastPathComponent()).getUserObject();
            } // for(int i = 0; i < selectionCount; i++)
            
            //--------------------------------------------------------
            // adding new ElementNodeObjects    4 of 4
            if(selectedNodes[0] instanceof ServerElementNodeObject)
            {
                // Only one node selected
                if(selectedNodes.length == 1) {
                    ((ServerElementNodeObject) selectedNodes[0]).performSingleNodeAction(getParentFromPopupComponent(component), actionName, jTree, refreshListener);
                    //System.out.println("((ServerElementNodeObject) selectedNodes[0]).performSingleNodeAction(getParentFromPopupComponent(component), actionName, jTree, refreshListener);");
                } // if(selectedNodes.length == 1)
                // More than one node sslected
                else {
                    ;
                } // else
            } // if(nodeObject instanceof ServerElementNodeObject)
            else if(selectedNodes[0] instanceof EngineElementNodeObject)
            {
                // Only one node selected
                if(selectedNodes.length == 1) {
                    ((EngineElementNodeObject) selectedNodes[0]).performSingleNodeAction(getParentFromPopupComponent(component), actionName, jTree, refreshListener);
                    //System.out.println("((ServerElementNodeObject) selectedNodes[0]).performSingleNodeAction(getParentFromPopupComponent(component), actionName, jTree, refreshListener);");
                } // if(selectedNodes.length == 1)
                // More than one node sslected
                else {
                    ;
                } // else
            } // else if(selectedNodes[0] instanceof EngineElementNodeObject)
            else if(selectedNodes[0] instanceof HostElementNodeObject)
            {
                // Only one node selected
                if(selectedNodes.length == 1) {
                    ((HostElementNodeObject) selectedNodes[0]).performSingleNodeAction(getParentFromPopupComponent(component), actionName, jTree, refreshListener);
                    //System.out.println("((ServerElementNodeObject) selectedNodes[0]).performSingleNodeAction(getParentFromPopupComponent(component), actionName, jTree, refreshListener);");
                } // if(selectedNodes.length == 1)
                // More than one node sslected
                else {
                    ;
                } // else
            } // else if(selectedNodes[0] instanceof HostElementNodeObject)
            else if(selectedNodes[0] instanceof ContextElementNodeObject)
            {
                // Only one node selected
                if(selectedNodes.length == 1) {
                    ((ContextElementNodeObject) selectedNodes[0]).performSingleNodeAction(getParentFromPopupComponent(component), actionName, jTree, refreshListener);
                    //System.out.println("((ContextElementNodeObject) selectedNodes[0]).performSingleNodeAction(getParentFromPopupComponent(component), actionName, jTree, refreshListener);");
                } // if(selectedNodes.length == 1)
                // More than one node sslected
                else {
                    ;
                } // else
            } // else if(selectedNodes[0] instanceof ContextElementNodeObject)
            else if(selectedNodes[0] instanceof AliasElementNodeObject)
            {
                // Only one node selected
                if(selectedNodes.length == 1) {
                    ((AliasElementNodeObject) selectedNodes[0]).performSingleNodeAction(getParentFromPopupComponent(component), actionName, jTree, refreshListener);
                    //System.out.println("((ServerElementNodeObject) selectedNodes[0]).performSingleNodeAction(getParentFromPopupComponent(component), actionName, jTree, refreshListener);");
                } // if(selectedNodes.length == 1)
                // More than one node sslected
                else {
                    ;
                } // else
            } // else if(selectedNodes[0] instanceof AliasElementNodeObject)
            else if(selectedNodes[0] instanceof ValveElementNodeObject)
            {
                // Only one node selected
                if(selectedNodes.length == 1) {
                    ((ValveElementNodeObject) selectedNodes[0]).performSingleNodeAction(getParentFromPopupComponent(component), actionName, jTree, refreshListener);
                    //System.out.println("((ValveElementNodeObject) selectedNodes[0]).performSingleNodeAction(getParentFromPopupComponent(component), actionName, jTree, refreshListener);");
                } // if(selectedNodes.length == 1)
                // More than one node sslected
                else {
                    ;
                } // else
            } // else if(selectedNodes[0] instanceof ValveElementNodeObject)
            else if(selectedNodes[0] instanceof LoggerElementNodeObject)
            {
                // Only one node selected
                if(selectedNodes.length == 1) {
                    ((LoggerElementNodeObject) selectedNodes[0]).performSingleNodeAction(getParentFromPopupComponent(component), actionName, jTree, refreshListener);
                    //System.out.println("((ValveElementNodeObject) selectedNodes[0]).performSingleNodeAction(getParentFromPopupComponent(component), actionName, jTree, refreshListener);");
                } // if(selectedNodes.length == 1)
                // More than one node sslected
                else {
                    ;
                } // else
            } // else if(selectedNodes[0] instanceof LoggerElementNodeObject)
            else if(selectedNodes[0] instanceof WithTextElementNodeObject)
            {
                // Only one node selected
                if(selectedNodes.length == 1) {
                    ((WithTextElementNodeObject) selectedNodes[0]).performSingleNodeAction(getParentFromPopupComponent(component), actionName, jTree, refreshListener);
                    //System.out.println("((WithTextElementNodeObject) selectedNodes[0]).performSingleNodeAction(getParentFromPopupComponent(component), actionName, jTree, refreshListener)");
                } // if(selectedNodes.length == 1)
                // More than one node sslected
                else {
                    ;
                } // else
            } // else if(selectedNodes[0] instanceof TableNodeObject)
            else if(selectedNodes[0] instanceof ElementNodeObject)
            {
                // Only one node selected
                if(selectedNodes.length == 1) {
                    ((ElementNodeObject) selectedNodes[0]).performSingleNodeAction(getParentFromPopupComponent(component), actionName, jTree, refreshListener);
                    //System.out.println("((ElementNodeObject) selectedNodes[0]).performSingleNodeAction(getParentFromPopupComponent(component), actionName, jTree, refreshListener)");
                } // if(selectedNodes.length == 1)
                // More than one node sslected
                else {
                    ;
                } // else
            } // else if(selectedNodes[0] instanceof TableNodeObject)
            else {
                // Only one node selected
                if(selectedNodes.length == 1) {
                    ;
                } // if(selectedNodes.length == 1)
                // More than one node sslected
                else {
                    ;
                } // else
            } // else
        } // if(selectionCount != 0)
        else {
            //--------------------------------------------------------------------
            // default actions
            
            Component parent = getParentFromPopupComponent(component);
            
            
            JDialog jDialog = new JOptionPane(parent.getClass().toString(), JOptionPane.YES_NO_CANCEL_OPTION).createDialog(parent, "test");
            
            
            jDialog.show();
        } // else
        
    } // public void performAction(Component component, String actionName, JTree jTree, ActionListener refreshListener)
    
    public String[] getPopupMenuMultipleNodeActionList(NodeObject nodeObject)
    {
        String[] popupList;
        
        if(nodeObject instanceof ServerElementNodeObject)
        {
            popupList = ((ServerElementNodeObject) nodeObject).getMultipleNodeActionList();
        } // if(nodeObject instanceof ServerElementNodeObject)
        else if(nodeObject instanceof ElementNodeObject)
        {
            popupList = ((ElementNodeObject) nodeObject).getMultipleNodeActionList();
        } // else if(nodeObject instanceof ElementNodeObject)
        else {
            popupList = defaultActionList;
        } // else
        
        return popupList;
    }
    
    public Component getParentFromPopupComponent(Component popupComponent) {
        Component component_ptr = popupComponent;
        JPopupMenu jPopupMenu;
        
        // to get get the parent frame
        while(component_ptr.getParent() != null) {
            component_ptr = (Component) component_ptr.getParent();
            //if(component_ptr instanceof JPopupMenu)
            //break;
        } // while(component_ptr.getParent() != null)
        
        
        jPopupMenu = (JPopupMenu) component_ptr;
        component_ptr = (Component) jPopupMenu.getInvoker();
        
        
        while(component_ptr.getParent() != null) {
            component_ptr = (Component) component_ptr.getParent();
            //if(component_ptr instanceof JComponent)
            // break;
        } // while(component_ptr.getParent() != null)
        
        return component_ptr;
    }
    
 // public String[] getPopupMenuMultipleNodeActionList(NodeObject nodeObject)
    
 // public void writeToFile()
    
} // public class ServerXMLObject


