package jp.turbosql.modules.at.app.tomcat4;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
//-----------------------------------
// xml libraries
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.apache.xerces.dom.*;
import org.apache.xml.serialize.*;
import org.apache.xerces.parsers.*;
import org.w3c.dom.traversal.*;
import org.xml.sax.*;
//-----------------------------------

import jp.turbosql.modules.at.app.*;
import jp.turbosql.modules.at.app.dialogs.*;

// depreciated, we will use ElementNodeObject directly.
public class WithTextElementNodeObject extends ElementNodeObject
{
    //protected String nodeActionList_viewAttributesAction = "View/Edit Server Attributes";
    //protected String[]
    protected String[] nodeActionList = {nodeActionList_viewAttributesAction};
    protected String multipleNodeActionList_viewAttributesAction = "Do nothing";
    protected String[] multipleNodeActionList = {multipleNodeActionList_viewAttributesAction};
    
    /*
    private String classNameAttrName = "className";
    private String portAttrName = "port";
    private String shutdownAttrName = "shutdown";
    
    private String classNameAttrValue = "";
    private String portAttrValue = "";
    private String shutdownAttrValue = "";
    
    private boolean classNameAttrIsRequired = false;
    private boolean portAttrIsRequired = true;
    private boolean shutdownAttrIsRequired = true;
     */
    
    private Document doc;
    
    public WithTextElementNodeObject(String objectName, Object userObject)
    {
        super(objectName, userObject, true);
        doc = getDocumentFromNodeObject();
    } // public WithTextElementNodeObject(String objectName, Object userObject)
    
    public WithTextElementNodeObject(String objectName)     // overloaded constructor
    {
        super(objectName, null, true);
    } // public WithTextElementNodeObject(String objectName)
    
    public WithTextElementNodeObject()
    {
        super(null, null, true);
    } // public WithTextElementNodeObject()
    
    public String[] getNodeActionList()
    {
        return nodeActionList;
    } // public String[] getNodeActionList()
    
    public String[] getMultipleNodeActionList()
    {
        return multipleNodeActionList;
    } // public String[] getNodeActionList()
    
    // overwrite with own method
    public void performSingleNodeAction(Component component, String actionName, JTree jTree, ActionListener refreshListener)
    {
        if(actionName.equals(nodeActionList_viewAttributesAction))
        {
            WithTextPropertyPane propertyPane = new WithTextPropertyPane(nodeObject, doc, refreshListener, "Attributes", getTextNode());
                                    
            NamedNodeMap namedNodeMap = nodeObject.getAttributes();
            //System.out.println("Type " + type + ": " + name 
            //+ " \"" + value + "\"");
            if(namedNodeMap != null)
            {
                for(int j = 0; j < namedNodeMap.getLength(); j++)
                {
                    propertyPane.add(namedNodeMap.item(j).getNodeName(), namedNodeMap.item(j).getNodeValue());
                    //System.out.println("attributes: /Name: " + namedNodeMap.item(j).getNodeName() + " /Value: " + namedNodeMap.item(j).getNodeValue());
                } // for(int i = 0; i < namedNodeMap.getLenth(); i++)
            } // if(namedNodeMap != null)
            
            //propertyPane.add("VALUE", getNodeTextValue());
            propertyPane.addTextValue(getNodeTextValue());
            
            //propertyPane.add("className", "jp.turbosql.modules.at.app.dialogs");
            
            JDialog dialog = propertyPane.createDialog(component, "Attributes");
            dialog.show();
        } // if(actionName.equals(nodeActionList_viewAttributesAction))
    } // public void performAction(Component component, String actionName, JTree jTree, ActionListener refreshListener)
    
    // overwrite with own method
    public String getPropertyHTML()
    {
        String propertyStr = "<B>" + nodeObject.getNodeName() + " attributes</B><BR>";
        NamedNodeMap namedNodeMap = nodeObject.getAttributes();
            
        if(namedNodeMap != null)
        {
            for(int j = 0; j < namedNodeMap.getLength(); j++)
            {
                propertyStr = propertyStr + "<FONT color=" + htmlOrange + ">" + namedNodeMap.item(j).getNodeName() + "</FONT>: " + namedNodeMap.item(j).getNodeValue() + "<BR>";
                //propertyPane.add(namedNodeMap.item(j).getNodeName(), namedNodeMap.item(j).getNodeValue());
                //System.out.println("attributes: /Name: " + namedNodeMap.item(j).getNodeName() + " /Value: " + namedNodeMap.item(j).getNodeValue());
            } // for(int i = 0; i < namedNodeMap.getLenth(); i++)
        } // if(namedNodeMap != null)
        
        propertyStr = propertyStr + "<FONT color=" + htmlRed + ">VALUE</FONT>: " + getNodeTextValue() + "<BR>";
        
        return propertyStr;
    } // public String getPropertyHTML()

    public String getNodeTextValue()
    {
        NodeList childNodeList = nodeObject.getChildNodes();
        
        if(childNodeList.getLength() != 0)
        {
            for(int i = 0; i < childNodeList.getLength(); i++)
            {
                Node childNode = childNodeList.item(i);
                if(childNode.getNodeType() == Node.TEXT_NODE)
                    return childNode.getNodeValue();
            } // for(int i = 0; i < childNodeList.getLength(); i++)
        } // if(childNodeList.getLength != 0)
        
        return "";  // if we cannot find any Text nodes
    } // public String getNodeTextValue()
    
    public Node getTextNode()
    {
        NodeList childNodeList = nodeObject.getChildNodes();
        
        if(childNodeList.getLength() != 0)
        {
            for(int i = 0; i < childNodeList.getLength(); i++)
            {
                Node childNode = childNodeList.item(i);
                if(childNode.getNodeType() == Node.TEXT_NODE)
                    return childNode;
            } // for(int i = 0; i < childNodeList.getLength(); i++)
        } // if(childNodeList.getLength != 0)
        
        return null;  // if we cannot find any Text nodes
    } // public String getNodeTextValue()
    
} // public class WithTextElementNodeObject extends ElementNodeObject
