package jp.turbosql.modules.at.app.wizards;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.io.*;
import javax.swing.*;
//-----------------------------------
// xml libraries
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.apache.xerces.dom.*;
import org.apache.xml.serialize.*;
import org.apache.xerces.parsers.*;
import org.w3c.dom.traversal.*;
import org.xml.sax.*;
//-----------------------------------

public class GenericWizardlet extends Wizardlet
{
    protected Box verticalBox;
    
    protected Vector propertyLabelVector;
    protected Vector propertyValueComponentVector;
    protected Vector propertyTypeVector;
    protected Vector originalPropertyValueVector;
    protected JFileChooser fileChooser;
    
    protected Component verticalStrut;
    
    protected Document doc;
    
    protected String originalTextValue = "";
    protected JTextField textValueField;
    protected Node originalTextNode;    
    protected String defaultTextValue = "";
    protected boolean hasTextElement = false;
    protected int adjustedHeight = 0;       // note: we only use this to adjust the height if this is a text element
    
    protected String[] allAttr = {};                         // holds all the attributes
    protected boolean[] requiredAttr = {};                    // required attributes
    protected String[] attrDefaultValue = {};
    protected boolean[] hasComboBoxValues = {};
    protected String[][] comboBoxValues = {/*unpackWARs*/};
    protected boolean[] useFileChooser = {};
    protected boolean[] chooseOnlyDirectories = {};
        
    public static final int NORMAL_PROPERTY = 0, REQUIRED_PROPERTY = 1, UNKNOWN_PROPERTY = 2, GENERIC_PROPERTY = 3;
    
    public static final Color darkOrangeColor = new Color(255, 51, 0);
    
    public static final Font normalPropertyFont = new Font("Default", Font.ITALIC, 12);         // also know as optional property
    public static final Color normalPropertyColor = darkOrangeColor;
    public static final Font requiredPropertyFont = new Font("Default", Font.BOLD, 12);
    public static final Color requiredPropertyColor = darkOrangeColor;
    public static final Font unknownPropertyFont = new Font("Default", Font.PLAIN, 12);
    public static final Color unknownPropertyColor = new Color(128, 128, 128);
    public static final Font genericPropertyFont = new Font("Default", Font.PLAIN, 12); 
    public static final Color  genericPropertyColor = darkOrangeColor;
    
    public GenericWizardlet(String stepName, String[] attrNames, String[] attrDefaultValues, Document doc, boolean hasTextElement, String defaultTextValue)
    {
        super();
        //super.add(new JButton("Test2"));
        //super.setBackground(darkOrangeColor);
        
        this.stepName = stepName;
        verticalBox = Box.createVerticalBox();
        propertyLabelVector = new Vector();
        propertyValueComponentVector = new Vector();
        propertyTypeVector = new Vector();
        originalPropertyValueVector = new Vector();
        
        this.doc = doc;
        this.hasTextElement = hasTextElement;
        this.defaultTextValue = defaultTextValue;
        
        if(attrNames != null)
        {
            //System.out.println(attrNames.length);
            //int totalLabelHeight = 21 * attrNames.length;
            //totalLabelHeight += adjustedHeight;
                
            //verticalBox.add(Box.createVerticalStrut(180 - totalLabelHeight/2));
        
            //verticalBox.add(Box.createVerticalGlue());
                    
            for(int i = 0; i < attrNames.length; i++)
            {
                if(attrDefaultValues != null)
                    addTextFieldProperty(attrNames[i], attrDefaultValues[i]);    // adding the GenericWizardlet, not for adding to the panel
                else
                    addTextFieldProperty(attrNames[i], "");
                //verticalBox.add(Box.createVerticalGlue());
            } // for(int i = 0; i < attrNames.length; i++)
            
            if(hasTextElement)
            {
                addTextValue(defaultTextValue);
            } // if(hasTextElement)
        } // if(attrNames != null)
        //verticalBox
        //this.setAlignmentY(JPanel.CENTER_ALIGNMENT);
        //this.setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
        //this.setLayout(new BorderLayout());
        //verticalBox.setAlignmentY(Box.CENTER_ALIGNMENT);
        //setLayout();
        //Box horizontalBox = Box.createHorizontalBox();
        //horizontalBox.add(verticalBox, BorderLayout.CENTER);
        //verticalBox.add(Box.createVerticalGlue());
        //verticalBox.add(Box.createVerticalStrut(200 - totalLabelHeight/2));
        //extraHeight += adjustedHeight;
        
        //this.setLayout(new FlowLayout());
        //int extraHeight = 300;
        
        //verticalBox.setBounds(new Rectangle(480, extraHeight));
        //verticalBox.setSize(480, extraHeight);
        //verticalBox.setVisible(true);
        //verticalBox.setBackground(darkOrangeColor);
        //this.setPreferredSize(new Dimension(480, extraHeight));
        
        //verticalBox.add(new JButton("Test1"));
        add(verticalBox);
        //add(new JButton("Test"));
        //this.setVisible(true);
        doAttrLayout();
         
    } // public GenericWizardlet(String[] attrNames, String[] attrDefaultValues)
    
    public GenericWizardlet()
    {
        this(null, null, false);
    } // public GenericWizardlet()
    
    public GenericWizardlet(String[] attrNames, Document doc, boolean hasTextElement)
    {
        this(null, attrNames, null, doc, hasTextElement, "");
    } // public GenericWizardlet(String[] attrNames)
    
    public GenericWizardlet(String stepName, String[] attrNames, Document doc, boolean hasTextElement)
    {
        this(stepName, attrNames, null, doc, hasTextElement, "");
    } // public GenericWizardlet(String stepName, String[] attrNames)
    
    public void add(String propertyName, String propertyValue, boolean useFileChooser, boolean chooseOnlyDirectories, String[] possiblePropertyValues, int propertyType)
    {
        // possiblePropertyValues reserved for making a custom combo box
        //Box horizontalBox = Box.createHorizontalBox();
        JPanel horizontalPanel = new JPanel(new GridLayout(1, 2));
        JLabel propertyLabel = new JLabel(propertyName);
        JTextField propertyField;
        JComboBox propertyComboBox;
        boolean hasPossiblePropertyValues = false;
        //horizontalPanel.set
        
        //horizontalPanel.add(new JButton("Test3"));
        //System.out.println("Test3");
        horizontalPanel.add(propertyLabel);
        propertyLabelVector.add(propertyLabel);
        
        if(propertyType == NORMAL_PROPERTY)
        {
            propertyLabel.setFont(normalPropertyFont);
            propertyLabel.setForeground(normalPropertyColor);
            //System.out.println("added NORMAL_PROPERTY");
        } // if(propertyType == NORMAL_PROPERTY)
        else if(propertyType == REQUIRED_PROPERTY)
        {
            propertyLabel.setFont(requiredPropertyFont);
            propertyLabel.setForeground(requiredPropertyColor);
            //System.out.println("added REQUIRED_PROPERTY");
        } // else if(propertyType == REQUIRED_PROPERTY)
        else if(propertyType == UNKNOWN_PROPERTY)
        {
            propertyLabel.setFont(unknownPropertyFont);
            propertyLabel.setForeground(unknownPropertyColor);
            //System.out.println("added UNKNOWN_PROPERTY");
        } // else if(propertyType == UNKNOWN_PROPERTY)
        else if(propertyType == GENERIC_PROPERTY)
        {
            propertyLabel.setFont(genericPropertyFont);
            propertyLabel.setForeground(genericPropertyColor);
            //System.out.println("added GENERIC_PROPERTY");
        } // else if(propertyType == UNKNOWN_PROPERTY)
        else        // we treat it as a generic property
        {
            propertyLabel.setFont(genericPropertyFont);
            propertyLabel.setForeground(genericPropertyColor);
        } // else
        
        propertyTypeVector.add(new Integer(propertyType));
        
        //propertyLabel.setFont(genericPropertyFont);// requiredPropertyFont
        
        if(possiblePropertyValues != null)
        {
            hasPossiblePropertyValues = true;
            // create combo box here
            
            propertyComboBox = new JComboBox(possiblePropertyValues);
            propertyComboBox.setEditable(true);     // we have to set it to editabale for before calling setSelectedItem
            propertyComboBox.setSelectedItem(propertyValue);
            propertyComboBox.setPreferredSize(new Dimension(200, 21));
            horizontalPanel.add(propertyComboBox);
            
            propertyValueComponentVector.add(propertyComboBox);
                        
            //horizontalBox.add(propertyComboBox);
        } // if(possiblePropertyValues != null)
        else
        {
            propertyField = new JTextField(propertyValue);
            //propertyField.setHorizontalAlignment(JTextField.LEFT);
            //propertyField.setBounds(0, 0, 120, 36);
            propertyField.setPreferredSize(new Dimension(200, 21));
            //horizontalPanel.add(propertyField);
            
            propertyValueComponentVector.add(propertyField);
            
            if(useFileChooser)
            {
                propertyField.setPreferredSize(new Dimension(180, 18));
                JButton fileButton = new JButton("...");
                fileButton.setPreferredSize(new Dimension(18, 18));
                fileButton.addActionListener(new FileChooserAction("...", propertyValueComponentVector.size() - 1, chooseOnlyDirectories));
                               
                JPanel smallPanel = new JPanel();
                smallPanel.setBorder(BorderFactory.createEmptyBorder());
                smallPanel.add(propertyField);
                smallPanel.add(fileButton);
                horizontalPanel.add(smallPanel);
            } // if(useFileChooser)
            else
            {
                propertyField.setPreferredSize(new Dimension(120, 21));
                horizontalPanel.add(propertyField);
            } // else
            
        } // else
        
        originalPropertyValueVector.add(propertyValue);
        //horizontalPanel.setPreferredSize(new Dimension(400, 21));
        
        verticalBox.add(horizontalPanel);
    } // public void add(String propertyName, String propertyValue, boolean useFileChooser, boolean chooseOnlyDirectories, String[] possiblePropertyValues, int propertyType)
    
    public void addTextFieldProperty(String propertyName, String propertyValue)
    {
        add(propertyName, propertyValue, false, false, null, GENERIC_PROPERTY);
    } // public void add(String propertyName, String propertyValue)
    
    public void addTextFieldProperty(String propertyName, String propertyValue, int propertyType)
    {
        add(propertyName, propertyValue, false, false, null, propertyType);
    } // public void add(String propertyName, String propertyValue)
    
    public void addComboBoxProperty(String propertyName, String propertyValue, String[] possiblePropertyValues, int propertyType)
    {
        add(propertyName, propertyValue, false, false, possiblePropertyValues, propertyType);
    } // public void addComboBoxProperty(String propertyName, String propertyValue, String[] possiblePropertyValues, int propertyType
    
    public void addFileChooserProperty(String propertyName, String propertyValue, boolean useFileChooser, boolean chooseOnlyDirectories, String[] possiblePropertyValues, int propertyType)
    {
        add(propertyName, propertyValue, useFileChooser, chooseOnlyDirectories, possiblePropertyValues, propertyType);
    } // public void addFileChooserProperty(String propertyName, String propertyValue, boolean useFileChooser, boolean chooseOnlyDirectories, String[] possiblePropertyValues, int propertyType)
    
    // only one text value allowed.
    // can only be called once
    public void addTextValue(String textValue)
    {
        this.originalTextValue = textValue;
        
        JPanel horizontalPanel = new JPanel(new GridLayout(1, 2));
        JLabel propertyLabel = new JLabel("VALUE");
        textValueField = new JTextField(textValue);
        
        textValueField.setPreferredSize(new Dimension(120, 21));
        
        horizontalPanel.add(propertyLabel);
        horizontalPanel.add(textValueField);
        
        adjustedHeight += 21;
        
        verticalBox.add(horizontalPanel);
    } // public void addTextValue(String textValue)
    
    public String getTextValue()
    {
        return textValueField.getText();
    } // public String getTextValue()
    
    public void doAllAttrProcessing()
    {
        for(int i = 0; i < allAttr.length; i++)
        {
            int propertyType = NORMAL_PROPERTY;
            
            if(requiredAttr[i])
                propertyType = REQUIRED_PROPERTY;
                
            add(allAttr[i], attrDefaultValue[i], useFileChooser[i], chooseOnlyDirectories[i], comboBoxValues[i], propertyType);
        } // for(int i = 0; i < allAttr.length; i++)
        
        //if(allAttr.length != 0)
        
        if(hasTextElement)
        {
            addTextValue(defaultTextValue);
        } // if(hasTextElement)
        
        doAttrLayout();         
    } // public void doAllAttrProcessing()
    
    // Layouts everything
    public void doAttrLayout()
    {
        if(verticalStrut != null)
            verticalBox.remove(verticalStrut);
        
        int totalLabelHeight = 21 * propertyLabelVector.size();
        totalLabelHeight += adjustedHeight;
        int verticalStrutHeight = 0;
        if(totalLabelHeight != 0)
        {
            verticalStrutHeight = 180 - totalLabelHeight/2;
            if(verticalStrutHeight < 0)
                verticalStrutHeight = 0;
        } // if(totalLabelHeight != 0)

        verticalStrut = Box.createVerticalStrut(verticalStrutHeight);
        
        verticalBox.add(verticalStrut, 0);
        
        //verticalBox.setBounds(new Rectangle(480, totalLabelHeight));
        //verticalBox.setSize(480, totalLabelHeight);
        //this.setPreferredSize(new Dimension(480, totalLabelHeight));
        
    } // public void doAttrLayout()
    
    public Object createUserObject()
    {
        return null;
    } // public Object createUserObject()
    
    public String getPropertyValueForPropertyName(String propertyName)
    {
        int propertyIndex = -1;
        Object propertyValueComponent;
        
        for(int i = 0; i < propertyLabelVector.size(); i++)
        {
            //propertyLabelVector.indexOf(new JLabel(propertyName));
            if(((JLabel) propertyLabelVector.get(i)).getText().equals(propertyName))
            {
                propertyIndex = i;
                break;
            } // if(((JLabel) propertyLabelVector.get(i)).getText().equals(propertyName))
        } // for(int i = 0; i < propertyLabelVector.size(); i++)
        
        //System.out.println("Property Name: " + propertyName + ", Index: " + propertyIndex);
        if(propertyIndex != -1)     // -1 means that this property does not exist
        {
            propertyValueComponent = propertyValueComponentVector.get(propertyIndex);
            
            if(propertyValueComponent instanceof JComboBox)
            {
                return (String) ((JComboBox) propertyValueComponent).getSelectedItem();
            } // if(propertyValueComponent instanceof JComboBox)
            else        // it is JTextField
                return ((JTextField) propertyValueComponent).getText();
        } // if(propertyIndex != -1)
        else        
            return "";      // if object does not exist, we don't return anything
    } // public void getPropertyValueForPropertyName(String propertyName)
    
    public String getStepName()
    {
        return "Enter Attributes";
    } // public String getStepName()
    
    public boolean hasHelpMenu()
    {
        return true;
    } // public String getStepName()
    
    public JDialog getHelpMenu(Component parentComponent)
    {
        HelpPane helpPane = new HelpPane("No Help Available");
        
        return helpPane.createDialog(parentComponent, "Help Menu");
    } // public JDialog getHelp()
    
    protected JFileChooser getFileChooser()
    {
        if(fileChooser == null)
            fileChooser = new JFileChooser();
        return fileChooser;
    } // protected JFileChoose getFileChooser()
    
    protected Component getReferenceToSelf()
    {
        return this;
    } // protected Component getReferenceToSelf()
        
    class FileChooserAction extends AbstractAction
    {
        int index;      // pointing to the propertyValueComponentVector which created this action
        boolean chooseOnlyDirectories;
        
        public FileChooserAction(String name, int index, boolean chooseOnlyDirectories)
        {
            super(name);
            this.index = index;
            this.chooseOnlyDirectories = chooseOnlyDirectories;
        } // public FileChooserAction(String name, int index)
                                                       
        public void actionPerformed(ActionEvent e)
        {
            JFileChooser fc = getFileChooser();
            if(chooseOnlyDirectories)
                fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);

            int returnVal = fc.showOpenDialog(getReferenceToSelf()); // Note: this means that the fileChooser only works after a call to create Dialog is made

            if(returnVal == JFileChooser.APPROVE_OPTION)
            {
                File file = fc.getSelectedFile();
                //this is where a real application would open the file.
                ((JTextField) propertyValueComponentVector.get(index)).setText(file.getAbsolutePath());
                 //log.append("Opening: " + file.getName() + "." + newline);
            } // if(returnVal == JFileChooser.APPROVE_OPTION)
            else 
            {
                //log.append("Open command cancelled by user." + newline);
            } // else
        } // public void actionPerformed(ActionEvent e)                
        
    } // class FileChooserAction extends AbstractAction
} // public class GenericWizardlet