package jp.turbosql.modules.at.app.wizards;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.accessibility.*;
import javax.swing.text.html.*;

public class HelpPane extends JComponent implements Accessible
{
    protected Dimension screenSize;
    protected JDialog dialog;
    protected JEditorPane helpEditorPane;
    
    protected String htmlStr;
    
    public HelpPane(String htmlStr)
    {
        this.htmlStr = htmlStr;
        helpEditorPane = new JEditorPane();
        helpEditorPane.setEditorKit(new HTMLEditorKit());
        helpEditorPane.setEditable(false);        
        helpEditorPane.setText(htmlStr);
        screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    } // public HelpPane()
    
    public JDialog createDialog(Component parentComponent, String title)
    {
        int width = 440, height = 360;
        dialog = new JDialog((JFrame)parentComponent, true);   // the help screen should be non-modal
        dialog.setTitle(title);
        Container contentPane = dialog.getContentPane();
        contentPane.add(helpEditorPane);
        
        dialog.setBounds((screenSize.width - width)/2, (screenSize.height - height)/2, width, height);
        
        return dialog;
    } // public JDialog createDialog(Component parentComponent, String title)
    
    public void setHTMLStr(String htmlStr)
    {
        this.htmlStr = htmlStr;
    } // public void setHTMLStr(String htmlStr)
    
    public String getHTMLStr()
    {
        return htmlStr;
    } // public String getHTMLStr()
    
} // public class HelpPane extends JComponent implements Accessible