import java.awt.*;
import java.awt.geom.*;
import java.io.*;
import java.util.Vector;

public abstract class Element implements Serializable
{
    protected Color color;
    
    protected boolean highlighted = false;
    
    //public abstract Shape getShape();
    
    public abstract java.awt.Rectangle getBounds();
    public abstract void modify(Point start, Point last);
    public abstract void draw(Graphics2D g2D);
    
    final static Point origin = new Point();
    protected Point position;
    protected double angle = 0.0;
           
    public Element(Color color)
    {
        this.color = color;
    } // public Element(Color color)
    
    public Color getColor()
    {
        return color;
    } // public Color getColor()
    
    public void setHighlighted(boolean highlighted)
    {
        this.highlighted = highlighted;
    } // public void setHighlighted(boolean highlighted)
    
    public Point getPosition()
    {
        return position;
    } // public Point getPosition()
    
    public void rotate(double angle)
    {
        this.angle += angle;
    } // public void rotate(double angle)
    
    protected void draw(Graphics2D g2D, Shape element) {
        g2D.setPaint(highlighted ? Color.magenta : color);
        AffineTransform old = g2D.getTransform();
        g2D.translate(position.x, position.y);
        g2D.rotate(angle);
        g2D.draw(element);
        g2D.setTransform(old);
    }
     
    protected java.awt.Rectangle getBounds(java.awt.Rectangle bounds)
    {
        AffineTransform at = AffineTransform.getTranslateInstance(position.x, position.y);
        
        at.rotate(angle);
        
        return at.createTransformedShape(bounds).getBounds();
    } // protected java.awt.Rectangle getBounds(java.awt.Rectangle bounds)
    
    public void move(int deltax, int deltay)
    {
        position.x += deltax;
        position.y += deltay;
    } // public void move(int deltax, int deltay)
    
    public static class Line extends Element
    {
        private Line2D.Double line;
        
        public Line(Point start, Point end, Color color)
        {
            super(color);
            //line = new Line2D.Double(start, end);
            position = start;
            line = new Line2D.Double(origin, new Point(end.x - position.x, end.y - position.y));
        } // public Line(Point start, Point end, Color color)
        
        public java.awt.Rectangle getBounds() {
            return getBounds(line.getBounds());
        }
        
        public Shape getShape() {
            return line;
        }
        
        public void modify(Point start, Point last) {
            line.x2 = last.x - position.x;
            line.y2 = last.y - position.y;
        }
        
        public void draw(Graphics2D g2D) {
            draw(g2D, line);
        }
        
        private void writeObject(ObjectOutputStream out) throws IOException
        {
            out.writeDouble(line.x2);
            out.writeDouble(line.y2);
        } // private void writeObject(ObjectOutputStream out) throws IOException
        
        private void readObject(java.io.ObjectInputStream in) throws IOException, ClassNotFoundException
        {
            double x2 = in.readDouble();
            double y2 = in.readDouble();
            line = new Line2D.Double(0, 0, x2, y2);
        } // private void readObject(java.io.ObjectInputStream in) throws IOException, ClassNotFoundException
        
    } // public static class Line extends Element
    
    public static class Rectangle extends Element
    {
        private Rectangle2D.Double rectangle;
        
        public Rectangle(Point start, Point end, Color color)
        {
            super(color);
            //rectangle = new Rectangle2D.Double(Math.min(start.x, end.x), Math.min(start.y, end.y), Math.abs(start.x - end.x), Math.abs(start.y - end.y));
            position = new Point(Math.min(start.x, end.x), Math.min(start.y, end.y));
            rectangle = new Rectangle2D.Double(origin.x, origin.y, Math.abs(start.x - end.x), Math.abs(start.y - end.y));
        } // public Rectangle(Point start, Point end, Color color)
        
        public java.awt.Rectangle getBounds() {
            return getBounds(rectangle.getBounds());
        }
        
        public Shape getShape() {
            return rectangle;
        }
        
        public void modify(Point start, Point last) {
            position.x = Math.min(start.x, last.x);
            position.y = Math.min(start.y, last.y);
            rectangle.width = Math.abs(start.x - last.x);
            rectangle.height = Math.abs(start.y - last.y);
        }
        
        public void draw(Graphics2D g2D) {
            draw(g2D, rectangle);
        }
        
        private void writeObject(ObjectOutputStream out) throws IOException
        {
            out.writeDouble(rectangle.width);
            out.writeDouble(rectangle.height);
        } // private void writeObject(ObjectOutputStream out) throws IOException
        
        private void readObject(java.io.ObjectInputStream in) throws IOException, ClassNotFoundException
        {
            double width = in.readDouble();
            double height = in.readDouble();
            rectangle = new Rectangle2D.Double(0, 0, width, height);
        } // private void readObject(java.io.ObjectInputStream in) throws IOException, ClassNotFoundException
        
    } // public static class Rectangle extends Element
    
    public static class Circle extends Element
    {
        private Ellipse2D.Double circle;
        
        public Circle(Point center, Point circum, Color color)
        {
            super(color);
            
            double radius = center.distance(circum);
            
            //circle = new Ellipse2D.Double(center.x - radius, center.y - radius, 2.*radius, 2.*radius);
            position = new Point(center.x - (int) radius, center.y - (int)radius);
            circle = new Ellipse2D.Double(origin.x, origin.y, 2.*radius, 2.*radius);
        } // public Circle(Point center, Point circum, Color color)
        
        public java.awt.Rectangle getBounds() {
            return getBounds(circle.getBounds());
        }
        
        public Shape getShape() {
            return circle;
        }
        
        public void modify(Point center, Point circum) {
            double radius = center.distance(circum);
            position.x = center.x - (int) radius;
            position.y = center.y - (int) radius;
            circle.width = circle.height = 2*radius;
        }
        
        public void draw(Graphics2D g2D) {
            draw(g2D, circle);
        }
        
        private void writeObject(ObjectOutputStream out) throws IOException
        {
            out.writeDouble(circle.width);            
        } // private void writeObject(ObjectOutputStream out) throws IOException
        
        private void readObject(java.io.ObjectInputStream in) throws IOException, ClassNotFoundException
        {
            double width = in.readDouble();
            circle = new Ellipse2D.Double(0, 0, width, width);
        } // private void readObject(java.io.ObjectInputStream in) throws IOException, ClassNotFoundException
        
    } // public static class Circle extends Element
    
    public static class Curve extends Element
    {
        private GeneralPath curve;
        
        public Curve(Point start, Point next, Color color)
        {
            super(color);
            curve = new GeneralPath();
            //curve.moveTo(start.x, start.y);
            //curve.lineTo(next.x, next.y);
            position = start;
            curve.moveTo(origin.x, origin.y);
            curve.lineTo(next.x - position.x, next.y - position.y);
        } // public Curve(Point start, Point next, Color)
        
        public java.awt.Rectangle getBounds() {
            return getBounds(curve.getBounds());
        }
        
        public Shape getShape() {
            return curve;
        }
        
        public void modify(Point start, Point next) {
            curve.lineTo(next.x - start.x, next.y - start.y);
        }
        
        public void draw(Graphics2D g2D) {
            draw(g2D, curve);
        }
        
        private void writeObject(ObjectOutputStream out) throws IOException
        {
            PathIterator iterator = curve.getPathIterator(new AffineTransform());
            Vector coords = new Vector();
            int maxCoordCount = 6;
            float[] temp = new float[maxCoordCount];
            
            int result = iterator.currentSegment(temp);
            if(!(result == iterator.SEG_MOVETO))
            {
                System.out.println("No starting moveTo");
                return;
            } // if(!(result == iterator.SEG_MOVETO))
            iterator.next();
            while(!iterator.isDone())
            {
                result = iterator.currentSegment(temp);
                if(!(result == iterator.SEG_LINETO))
                {
                    System.out.println("Invalid segment type");
                    return;
                } // if(!(result == iterator.SEG_LINETO))
                coords.add(new Float(temp[0]));
                coords.add(new Float(temp[1]));
                iterator.next();
            } // while(!iterator.isDone())
            out.writeObject(coords);
        } // private void writeObject(ObjectOutputStream out) throws IOException
        
        private void readObject(java.io.ObjectInputStream in) throws IOException, ClassNotFoundException
        {
            Vector coords = (Vector) in.readObject();
            curve = new GeneralPath();
            
            curve.moveTo(0, 0);
            
            float x, y;
            for(int i = 0; i < coords.size(); i += 2)
            {
                x = ((Float) coords.get(i)).floatValue();
                y = ((Float) coords.get(i+1)).floatValue();
                
                curve.lineTo(x, y);
            } // for(int i = 0; i < coords.size(); i += 2)
        } // private void readObject(java.io.ObjectInputStream in) throws IOException, ClassNotFoundException
        
    } // public static class Curve extends Element
    
    public static class Text extends Element
    {
        private Font font;
        private String text;
        Point position;
        java.awt.Rectangle bounds = null;
        
        public Text(Font font, String text, Point position, Color color, java.awt.Rectangle bounds)
        {
            super(color);
            this.font = font;
            this.position = position;
            this.position.y -= (int) bounds.getHeight();
            this.text = text;
            //this.bounds = bounds;
            //this.bounds.setLocation(position.x, position.y - (int) bounds.getHeight());
            this.bounds = new java.awt.Rectangle(origin.x, origin.y, bounds.width, bounds.height);
//---------------------------------------------------------------------------
            super.position = position;
//---------------------------------------------------------------------------
        } // public Text(Font font, String text, Point position, Color color, java.awt.Rectangle bounds)
        
        public void draw(Graphics2D g2D) {
            g2D.setPaint(highlighted ? Color.magenta : color);
            Font oldFont = g2D.getFont();
            g2D.setFont(font);
            
            //g2D.drawString(text, position.x, position.y);
            AffineTransform old = g2D.getTransform();
            g2D.translate(position.x, position.y);
            g2D.rotate(angle);
            g2D.drawString(text, origin.x, origin.y + (int) bounds.getHeight());
            g2D.setTransform(old);
            
            g2D.setFont(oldFont);
        }
        
        public java.awt.Rectangle getBounds() {
            return getBounds(bounds);
            //return bounds;
        }
        
        public void modify(Point start, Point last) {
        }
        
    } // public static class Text element
} // public abstract class Element