import java.util.*;
import java.awt.*;
import java.io.*;

class SketchModel extends Observable implements Serializable
{
    protected LinkedList elementList = new LinkedList();
    
    public boolean remove(Element element)
    {
        boolean removed = elementList.remove(element);
        if(removed)
        {
            setChanged();
            notifyObservers(element.getBounds());
        } // if(removed)
        
        return removed;
    } // public boolean remove(Element element)
    
    public void add(Element element)
    {
        elementList.add(element);
        setChanged();
        notifyObservers(element.getBounds());
    } // public void add(Element element)
    
    public Iterator getIterator()
    {
        return elementList.listIterator();
    } // public Iterator getIterator()
    
} // class SketchModel extends Observable
