import java.util.*;

import org.openide.nodes.*;

/** List of children of a containing node.
 * Remember to document what your permitted keys are!
 *
 * @author root
 */
public class ContainerChildren extends Children.Keys {
    
    /** Optional holder for the keys, to be used when changing them dynamically. */
    protected List myKeys;
    
    public ContainerChildren() {
        myKeys = null;
    }
    
    protected void addNotify() {
        super.addNotify();
        if (myKeys != null) return;
        myKeys = new LinkedList();
        // add whatever keys you need
        setKeys(myKeys);
    }
    
    protected void removeNotify() {
        myKeys = null;
        setKeys(Collections.EMPTY_SET);
        super.removeNotify();
    }
    
    protected Node[] createNodes(Object key) {
        // interpret your key here...usually one node generated, but could be zero or more
        return new Node[] { new MyNode((MyParameter) key) };
    }
    
    /** Optional accessor method for the keys, for use by the container node or maybe subclasses. */
    /*
    protected addKey (Object newKey) {
        // Make sure some keys already exist:
        addNotify ();
        myKeys.add (newKey);
        // Ensure that the node(s) is displayed:
        refreshKey (newKey);
    }
     */
    
    /** Optional accessor method for keys, for use by the container node or maybe subclasses. */
    /*
    protected void setKeys (Collection keys) {
        myKeys = new LinkedList ();
        myKeys.addAll (keys);
        super.setKeys (keys);
    }
     */
    
    // Could also write e.g. removeKey to be used by the nodes in this children.
    // Or, could listen to changes in their status (NodeAdapter.nodeDestroyed)
    // and automatically remove them from the keys list here. Etc.
    
}
