import java.math.BigInteger;
import java.io.*;
import org.w3c.dom.*;
import org.apache.xerces.dom.*;
import org.apache.xml.serialize.*;


public class FibonacciDOMSerializer {

  public static void main(String[] args) {

    try {

      DOMImplementation impl
       = DOMImplementationImpl.getDOMImplementation();

      Document fibonacci = impl.createDocument(
                             null, // no namespace URI
                             "Fibonacci_Numbers", // root element
                             null  // no DOCTYPE declaration
                            );

      BigInteger low  = BigInteger.ZERO;
      BigInteger high = BigInteger.ONE;

      org.w3c.dom.Element root = fibonacci.getDocumentElement();

      for (int i = 0; i <= 25; i++) {
        org.w3c.dom.Element number = fibonacci.createElement("fibonacci");
        number.setAttribute("index", Integer.toString(i));
        Text text = fibonacci.createTextNode(low.toString());
        number.appendChild(text);
        root.appendChild(number);

        BigInteger temp = high;
        high = high.add(low);
        low = temp;
      }

      /*try {
        // Now that the document is created we need to *serialize* it
        OutputFormat format = new OutputFormat(fibonacci);
        XMLSerializer serializer
         = new XMLSerializer(System.out, format);
        serializer.serialize(fibonacci);
      }
      catch (IOException e) {
        System.err.println(e);
      }*/
       try {
  // Now that the document is created we need to *serialize* it
  //OutputFormat format = new OutputFormat(fibonacci);
  
  OutputFormat format = new OutputFormat(fibonacci, "8859_1", true);
  format.setLineSeparator("\r\n");
  format.setLineWidth(72);
  format.setDoctype(null, "fibonacci.dtd");
  
  //XMLSerializer serializer = new XMLSerializer(System.out, format);
  //serializer.serialize(root);
  try
        {
            
            //ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream("/root/java/xml/fibonacci_test.xml")));
            FileOutputStream out = new FileOutputStream("/root/java/xml/fibonacci_test.xml");
            
            //out.writeObject(theApp.getModel());
            XMLSerializer serializer = new XMLSerializer(out, format);
            serializer.serialize(root);
            out.flush();
            out.close();
        } // try
        catch(IOException e)
        {
            System.out.println(e);            
        } // catch(IOException e)
}
catch (Exception e) {
  System.err.println(e); 
}


    }
    catch (DOMException e) {
      e.printStackTrace();
    }

  }

}


