import java.io.*;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.apache.xerces.dom.*;
import org.apache.xml.serialize.*;
import org.apache.xerces.parsers.*;
import org.xml.sax.*;

public class TestParsing
{
    public TestParsing()
    {
        DOMParser parser = new DOMParser();
                
        try
        {
            // Read the entire document into memory
            parser.parse("/var/tomcat4/conf/server.xml");
       
            Document doc = parser.getDocument();
            NodeList nodeList = doc.getElementsByTagName("Server");
            for(int i = 0; i < nodeList.getLength(); i++)
            {
               //System.out.println(nodeList.item(i));
               Node serverNode = nodeList.item(i);
               System.out.println("Server Node: " + serverNode);
               NamedNodeMap namedNodeMap = serverNode.getAttributes();
                //System.out.println("Type " + type + ": " + name 
                //+ " \"" + value + "\"");
                if(namedNodeMap != null)
                {
                    for(int j = 0; j < namedNodeMap.getLength(); j++)
                    {
                        if(namedNodeMap.item(j).getNodeName().equals("port"))
                            namedNodeMap.item(j).setNodeValue("8006");
                        System.out.println("attributes: /Name: " + namedNodeMap.item(j).getNodeName() + " /Value: " + namedNodeMap.item(j).getNodeValue());
                    } // for(int i = 0; i < namedNodeMap.getLenth(); i++)
                } // if(namedNodeMap != null)
            } // for(int i = 0; i < nodeList.getLength(); i++)
            //iterator.followNode(doc);
            
            //OutputFormat format = new OutputFormat(doc, "8859_1", true);
            OutputFormat format = new OutputFormat(doc, "8859_1", true);
            
            try
            {
                //ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream("/root/java/xml/fibonacci_test.xml")));
                //out.writeObject(theApp.getModel());
                FileOutputStream out = new FileOutputStream("/var/tomcat4/conf/server_new.xml");
                XMLSerializer serializer = new XMLSerializer(out, format);
                serializer.serialize(doc);
                out.flush();
                out.close();
            } // try
            catch(IOException e)
            {
                System.out.println(e);            
            } // catch(IOException e)
            
        } // try
        catch (SAXException e)
        {
            System.err.println(e); 
        } // catch (SAXException e)
        catch (IOException e)
        {
            System.err.println(e); 
        } // catch (IOException e)
    } // public TestParsing()
    
    public static void main(String[] args)
    {
        TestParsing tp = new TestParsing();
    } // public static void main(String[] args)
} // public class TestParsing
