/*
 * Copyright (c) 2002 Sosnoski Software Solutions, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

import org.xml.sax.*;
import org.xml.sax.helpers.*;

/**
 * SAX2 handler for parsing trade history information stream.
 *
 * @author Dennis M. Sosnoski
 * @version 1.0
 */

public class StockStreamHandler extends DefaultHandler
{
	/** Name of element containing entire trade. */
	protected String TRADE_ELEMENT_NAME = "stock-trade";
	
	/** Name of element containing stock symbol. */
	protected String SYMBOL_ELEMENT_NAME = "symbol";
	
	/** Name of element containing timestamp. */
	protected String TIME_ELEMENT_NAME = "time";
	
	/** Name of element containing trade price. */
	protected String PRICE_ELEMENT_NAME = "price";
	
	/** Name of element containing quantity  */
	protected String QUANTITY_ELEMENT_NAME = "quantity";
	
	/** Character data collection buffer. */
	protected StringBuffer m_contentBuffer = new StringBuffer();
	
	/** Symbol of stock traded. */
	protected String m_stockSymbol;
	
	/** Timestamp on trade. */
	protected String m_tradeTime;
	
	/** Price at which trade took place. */
	protected double m_tradePrice;
	
	/** Number of shares traded. */
	protected int m_sharesTraded;
	
	public void startElement(String uri, String lname, String qname,
		Attributes attributes) {
		m_contentBuffer.setLength(0);
	}
	
	public void characters(char[] chars, int start, int length) {
		m_contentBuffer.append(chars, start, length);
	}
	
	public void endElement(String uri, String lname, String qname) {
		if (lname.equals(TRADE_ELEMENT_NAME)) {
			StockTrack.recordTrade(m_stockSymbol, m_tradeTime, m_tradePrice,
				m_sharesTraded);
		} else {
			String content = m_contentBuffer.toString().trim();
			if (lname.equals(SYMBOL_ELEMENT_NAME)) {
				m_stockSymbol = content;
			} else if (lname.equals(TIME_ELEMENT_NAME)) {
				m_tradeTime = content;
			} else if (lname.equals(PRICE_ELEMENT_NAME)) {
				m_tradePrice = Double.parseDouble(content);
			} else if (lname.equals(QUANTITY_ELEMENT_NAME)) {
				m_sharesTraded = Integer.parseInt(content);
			}
		}
	}
}

